/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.support.filter;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.transit.model.site.StopType;
import org.opentripplanner.utils.collection.CollectionUtils;
import org.opentripplanner.utils.collection.EnumSetUtils;

public class StopArrivalByTypeFilter {
    @Nullable
    private final Set<StopType> allowedTypes;

    public StopArrivalByTypeFilter(@Nullable Collection<GraphQLTypes.GraphQLStopType> types) {
        CollectionUtils.requireNullOrNonEmpty(types, (String)"Stop types must be non-empty or null");
        this.allowedTypes = StopArrivalByTypeFilter.map(types);
    }

    public List<StopArrival> filter(@Nullable List<StopArrival> arrivals) {
        if (this.allowedTypes == null || arrivals == null) {
            return arrivals;
        }
        return arrivals.stream().filter((? super T arrival) -> this.allowedTypes.contains((Object)arrival.place.stop.getStopType())).toList();
    }

    private static Set<StopType> map(@Nullable Collection<GraphQLTypes.GraphQLStopType> types) {
        if (types == null) {
            return null;
        }
        Set allowed = types.stream().map(type -> switch (type) {
            default -> throw new MatchException(null, null);
            case GraphQLTypes.GraphQLStopType.LOCATION -> StopType.FLEXIBLE_AREA;
            case GraphQLTypes.GraphQLStopType.LOCATION_GROUP -> StopType.FLEXIBLE_GROUP;
            case GraphQLTypes.GraphQLStopType.STOP -> StopType.REGULAR;
        }).collect(Collectors.toSet());
        return EnumSetUtils.unmodifiableEnumSet(allowed, StopType.class);
    }
}

