/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.service;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.ArrivalDeparture;
import org.opentripplanner.transit.service.TransitService;

public class ApiTransitService {
    private final TransitService transitService;

    public ApiTransitService(TransitService transitService) {
        this.transitService = transitService;
    }

    public List<TripTimeOnDate> getTripTimeOnDatesForPatternAtStopIncludingTripsWithSkippedStops(StopLocation stop, TripPattern originalPattern, Instant startTime, Duration timeRange, int numDepartures, ArrivalDeparture arrivalDeparture) {
        LocalDate date = startTime.atZone(this.transitService.getTimeZone()).toLocalDate();
        return Stream.concat(this.getRealtimeAddedPatternsAsStream(originalPattern, date), Stream.of(originalPattern)).distinct().flatMap(tripPattern -> this.transitService.findTripTimesOnDate(stop, (TripPattern)tripPattern, startTime, timeRange, numDepartures, arrivalDeparture, false).stream()).sorted(Comparator.comparing(tts -> tts.getServiceDayMidnight() + (long)tts.getRealtimeDeparture())).limit(numDepartures).toList();
    }

    public List<TripTimeOnDate> findStopCalls(Leg leg) {
        if (leg.isTransitLeg()) {
            List<TripTimeOnDate> calls = this.transitService.findTripTimesOnDate(leg.trip(), leg.serviceDate()).orElseThrow(() -> new IllegalStateException("Cannot find times for %s on service date %s".formatted(leg.trip(), leg.serviceDate())));
            return calls.subList(leg.boardStopPosInPattern(), leg.alightStopPosInPattern() + 1);
        }
        return List.of();
    }

    private Stream<TripPattern> getRealtimeAddedPatternsAsStream(TripPattern originalPattern, LocalDate date) {
        return originalPattern.scheduledTripsAsStream().map(trip -> this.transitService.findNewTripPatternForModifiedTrip(trip.getId(), date)).filter(tripPattern -> tripPattern != null && tripPattern.isModifiedFromTripPatternWithEqualStops(originalPattern));
    }
}

