/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.TransitModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ArgumentUtils;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.routing.api.request.preference.TransferPreferences;
import org.opentripplanner.routing.api.request.preference.TransitPreferences;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.utils.collection.CollectionUtils;
import org.opentripplanner.utils.time.DurationUtils;

public class TransitPreferencesMapper {
    static void setTransitPreferences(TransitPreferences.Builder transitPreferences, TransferPreferences.Builder transferPreferences, GraphQLTypes.GraphQLQueryTypePlanConnectionArgs args, DataFetchingEnvironment environment) {
        GraphQLTypes.GraphQLTimetablePreferencesInput timetable;
        GraphQLTypes.GraphQLTransferPreferencesInput transfer;
        Duration slack;
        GraphQLTypes.GraphQLAlightPreferencesInput alight;
        GraphQLTypes.GraphQLTransitPreferencesInput transitArgs;
        GraphQLTypes.GraphQLPlanModesInput modes = args.getGraphQLModes();
        List<Map<String, Object>> transit = ArgumentUtils.getTransitModes(environment);
        if (!Boolean.TRUE.equals(modes.getGraphQLDirectOnly()) && !CollectionUtils.isEmpty(transit)) {
            Map<TransitMode, Double> reluctanceForMode = transit.stream().filter(mode -> mode.containsKey("cost")).collect(Collectors.toMap(mode -> TransitModeMapper.map(GraphQLTypes.GraphQLTransitMode.valueOf((String)mode.get("mode"))), mode -> (Double)((Map)mode.get("cost")).get("reluctance")));
            transitPreferences.setReluctanceForMode(reluctanceForMode);
        }
        if ((transitArgs = args.getGraphQLPreferences().getGraphQLTransit()) == null) {
            return;
        }
        GraphQLTypes.GraphQLBoardPreferencesInput board = transitArgs.getGraphQLBoard();
        if (board != null) {
            Double waitReluctance;
            Duration slack2 = board.getGraphQLSlack();
            if (slack2 != null) {
                transitPreferences.withDefaultBoardSlackSec((int)DurationUtils.requireNonNegativeMax2hours((Duration)slack2, (String)"board slack").toSeconds());
            }
            if ((waitReluctance = board.getGraphQLWaitReluctance()) != null) {
                transferPreferences.withWaitReluctance(waitReluctance);
            }
        }
        if ((alight = transitArgs.getGraphQLAlight()) != null && (slack = alight.getGraphQLSlack()) != null) {
            transitPreferences.withDefaultAlightSlackSec((int)DurationUtils.requireNonNegativeMax2hours((Duration)slack, (String)"alight slack").toSeconds());
        }
        if ((transfer = transitArgs.getGraphQLTransfer()) != null) {
            Integer additionalTransfers;
            Integer maxTransfers;
            Duration slack3;
            Cost cost = transfer.getGraphQLCost();
            if (cost != null) {
                transferPreferences.withCost(cost.toSeconds());
            }
            if ((slack3 = transfer.getGraphQLSlack()) != null) {
                transferPreferences.withSlack(DurationUtils.requireNonNegativeMax2hours((Duration)slack3, (String)"transfer slack"));
            }
            if ((maxTransfers = transfer.getGraphQLMaximumTransfers()) != null) {
                if (maxTransfers < 0) {
                    throw new IllegalArgumentException("Maximum transfers must be non-negative.");
                }
                transferPreferences.withMaxTransfers(maxTransfers + 1);
            }
            if ((additionalTransfers = transfer.getGraphQLMaximumAdditionalTransfers()) != null) {
                if (additionalTransfers < 0) {
                    throw new IllegalArgumentException("Maximum additional transfers must be non-negative.");
                }
                transferPreferences.withMaxAdditionalTransfers(additionalTransfers);
            }
        }
        if ((timetable = transitArgs.getGraphQLTimetable()) != null) {
            Boolean includeRealtimeCancellations;
            Boolean includePlannedCancellations;
            Boolean excludeUpdates = timetable.getGraphQLExcludeRealTimeUpdates();
            if (excludeUpdates != null) {
                transitPreferences.setIgnoreRealtimeUpdates(excludeUpdates);
            }
            if ((includePlannedCancellations = timetable.getGraphQLIncludePlannedCancellations()) != null) {
                transitPreferences.setIncludePlannedCancellations(includePlannedCancellations);
            }
            if ((includeRealtimeCancellations = timetable.getGraphQLIncludeRealTimeCancellations()) != null) {
                transitPreferences.setIncludeRealtimeCancellations(includeRealtimeCancellations);
            }
        }
    }
}

