/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import java.util.HashSet;
import java.util.List;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.JourneyRequest;

public class StreetModeMapper {
    public static StreetMode getStreetModeForRouting(List<StreetMode> modes) {
        if (modes.size() > 2) {
            throw new IllegalArgumentException("Only one or two modes can be specified for a leg, got: " + String.valueOf(modes) + ".");
        }
        if (modes.size() == 1) {
            StreetMode mode2 = modes.getFirst();
            if (!StreetModeMapper.isAlwaysPresentInLeg(mode2)) {
                throw new IllegalArgumentException("For the time being, " + String.valueOf(mode2) + " needs to be combined with WALK mode for the same leg.");
            }
            return mode2;
        }
        if (modes.contains(StreetMode.BIKE)) {
            throw new IllegalArgumentException("Bicycle can't be combined with other modes for the same leg: " + String.valueOf(modes) + ".");
        }
        if (modes.contains(StreetMode.CAR)) {
            throw new IllegalArgumentException("Car can't be combined with other modes for the same leg: " + String.valueOf(modes) + ".");
        }
        if (!modes.contains(StreetMode.WALK)) {
            throw new IllegalArgumentException("For the time being, WALK needs to be added as a mode for a leg when using " + String.valueOf(modes) + " and these two can't be used in the same leg.");
        }
        return modes.stream().filter(mode -> mode != StreetMode.WALK).findFirst().get();
    }

    public static List<StreetMode> getStreetModesForApi(StreetMode mode) {
        if (StreetModeMapper.isAlwaysPresentInLeg(mode)) {
            return List.of(mode);
        }
        return List.of(StreetMode.WALK, mode);
    }

    public static void validateStreetModes(JourneyRequest journey) {
        HashSet<StreetMode> modes = new HashSet<StreetMode>();
        modes.add(journey.access().mode());
        modes.add(journey.egress().mode());
        modes.add(journey.transfer().mode());
        if (modes.contains(StreetMode.BIKE) && modes.size() != 1) {
            throw new IllegalArgumentException("If BICYCLE is used for access, egress or transfer, then it should be used for all.");
        }
        if (modes.contains(StreetMode.CAR) && modes.size() != 1) {
            throw new IllegalArgumentException("If CAR is used for access, egress or transfer, then it should be used for all.");
        }
    }

    private static boolean isAlwaysPresentInLeg(StreetMode mode) {
        return mode == StreetMode.BIKE || mode == StreetMode.CAR || mode == StreetMode.WALK || mode.includesParking();
    }
}

