/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import java.util.List;
import org.opentripplanner.apis.gtfs.GraphQLUtils;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.collection.CollectionUtils;

class SelectRequestMapper {
    SelectRequestMapper() {
    }

    static SelectRequest.Builder mapSelectRequest(GraphQLTypes.GraphQLTransitFilterSelectInput input, String name) {
        List<String> routes = input.getGraphQLRoutes();
        List<String> agencies = input.getGraphQLAgencies();
        CollectionUtils.requireNullOrNonEmpty(routes, (String)"preferences.transit.filters.%s.routes".formatted(name));
        CollectionUtils.requireNullOrNonEmpty(agencies, (String)"preferences.transit.filters.%s.agencies".formatted(name));
        if (CollectionUtils.isEmpty(routes) && CollectionUtils.isEmpty(agencies)) {
            String type = GraphQLUtils.typeName(input);
            throw new IllegalArgumentException("%s must contain at least one element in either 'routes or 'agencies'.".formatted(type));
        }
        SelectRequest.Builder selectRequestBuilder = SelectRequest.of();
        if (CollectionUtils.hasValue(routes)) {
            selectRequestBuilder.withRoutes(FeedScopedId.parse(routes));
        }
        if (CollectionUtils.hasValue(agencies)) {
            selectRequestBuilder.withAgencies(FeedScopedId.parse(agencies));
        }
        return selectRequestBuilder;
    }
}

