/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import java.util.List;
import java.util.Set;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.routerequest.VehicleOptimizationTypeMapper;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.routing.api.request.preference.ScooterPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.core.VehicleRoutingOptimizeType;

public class ScooterPreferencesMapper {
    static void setScooterPreferences(ScooterPreferences.Builder preferences, GraphQLTypes.GraphQLScooterPreferencesInput args) {
        Double reluctance;
        if (args == null) {
            return;
        }
        Double speed = args.getGraphQLSpeed();
        if (speed != null) {
            preferences.withSpeed(speed);
        }
        if ((reluctance = args.getGraphQLReluctance()) != null) {
            preferences.withReluctance(reluctance);
        }
        preferences.withRental(rental -> ScooterPreferencesMapper.setScooterRentalPreferences(rental, args.getGraphQLRental()));
        ScooterPreferencesMapper.setScooterOptimization(preferences, args.getGraphQLOptimization());
    }

    private static void setScooterRentalPreferences(VehicleRentalPreferences.Builder preferences, GraphQLTypes.GraphQLScooterRentalPreferencesInput args) {
        GraphQLTypes.GraphQLDestinationScooterPolicyInput destinationPolicy;
        List<String> bannedNetworks;
        if (args == null) {
            return;
        }
        List<String> allowedNetworks = args.getGraphQLAllowedNetworks();
        if (allowedNetworks != null) {
            if (allowedNetworks.isEmpty()) {
                throw new IllegalArgumentException("Allowed scooter rental networks must not be empty.");
            }
            preferences.withAllowedNetworks(Set.copyOf(allowedNetworks));
        }
        if ((bannedNetworks = args.getGraphQLBannedNetworks()) != null) {
            preferences.withBannedNetworks(Set.copyOf(bannedNetworks));
        }
        if ((destinationPolicy = args.getGraphQLDestinationScooterPolicy()) != null) {
            Cost cost;
            Boolean allowed = destinationPolicy.getGraphQLAllowKeeping();
            if (allowed != null) {
                preferences.withAllowArrivingInRentedVehicleAtDestination(allowed);
            }
            if ((cost = destinationPolicy.getGraphQLKeepingCost()) != null) {
                preferences.withArrivingInRentalVehicleAtDestinationCost(cost.toSeconds());
            }
        }
    }

    private static void setScooterOptimization(ScooterPreferences.Builder preferences, GraphQLTypes.GraphQLScooterOptimizationInput args) {
        GraphQLTypes.GraphQLTriangleScooterFactorsInput triangleArgs;
        VehicleRoutingOptimizeType mappedType;
        if (args == null) {
            return;
        }
        GraphQLTypes.GraphQLScooterOptimizationType type = args.getGraphQLType();
        VehicleRoutingOptimizeType vehicleRoutingOptimizeType = mappedType = type != null ? VehicleOptimizationTypeMapper.map(type) : null;
        if (mappedType != null) {
            preferences.withOptimizeType(mappedType);
        }
        if (ScooterPreferencesMapper.isScooterTriangleSet(triangleArgs = args.getGraphQLTriangle())) {
            preferences.withForcedOptimizeTriangle(triangle -> triangle.withSlope(triangleArgs.getGraphQLFlatness()).withSafety(triangleArgs.getGraphQLSafety()).withTime(triangleArgs.getGraphQLTime()));
        }
    }

    private static boolean isScooterTriangleSet(GraphQLTypes.GraphQLTriangleScooterFactorsInput args) {
        return args != null && args.getGraphQLFlatness() != null && args.getGraphQLSafety() != null && args.getGraphQLTime() != null;
    }
}

