/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.routerequest.BicyclePreferencesMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.CarPreferencesMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ItineraryFilterDebugProfileMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ModePreferencesMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ScooterPreferencesMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.TransitPreferencesMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ViaLocationMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.WalkPreferencesMapper;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteRequestBuilder;
import org.opentripplanner.routing.api.request.preference.ItineraryFilterPreferences;
import org.opentripplanner.routing.api.request.preference.RoutingPreferencesBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.time.DurationUtils;

public class RouteRequestMapper {
    public static RouteRequest toRouteRequest(DataFetchingEnvironment environment, GraphQLRequestContext context) {
        RouteRequestBuilder request = context.defaultRouteRequest().copyOf();
        GraphQLTypes.GraphQLQueryTypePlanConnectionArgs args = new GraphQLTypes.GraphQLQueryTypePlanConnectionArgs(environment.getArguments());
        GraphQLTypes.GraphQLPlanDateTimeInput dateTime = args.getGraphQLDateTime();
        if (dateTime.getGraphQLEarliestDeparture() != null) {
            request.withDateTime(args.getGraphQLDateTime().getGraphQLEarliestDeparture().toInstant());
        } else if (dateTime.getGraphQLLatestArrival() != null) {
            request.withDateTime(args.getGraphQLDateTime().getGraphQLLatestArrival().toInstant());
            request.withArriveBy(true);
        } else {
            request.withDateTime(Instant.now());
        }
        boolean isTripPlannedForNow = RouteRequest.isAPIGtfsTripPlannedForNow(request.dateTime());
        request.withFrom(RouteRequestMapper.parseGenericLocation(args.getGraphQLOrigin()));
        request.withTo(RouteRequestMapper.parseGenericLocation(args.getGraphQLDestination()));
        request.withSearchWindow(args.getGraphQLSearchWindow() != null ? DurationUtils.requireNonNegativeMax2days((Duration)args.getGraphQLSearchWindow(), (String)"searchWindow") : null);
        if (args.getGraphQLBefore() != null) {
            request.withPageCursorFromEncoded(args.getGraphQLBefore());
            if (args.getGraphQLLast() != null) {
                request.withNumItineraries(args.getGraphQLLast());
            }
        } else if (args.getGraphQLAfter() != null) {
            request.withPageCursorFromEncoded(args.getGraphQLAfter());
            if (args.getGraphQLFirst() != null) {
                request.withNumItineraries(args.getGraphQLFirst());
            }
        } else if (args.getGraphQLFirst() != null) {
            request.withNumItineraries(args.getGraphQLFirst());
        }
        request.withPreferences(preferences -> RouteRequestMapper.setPreferences(preferences, request, isTripPlannedForNow, args, environment));
        request.withJourney(journeyRequestBuilder -> ModePreferencesMapper.setModes(journeyRequestBuilder, args, environment));
        RouteRequestMapper.mapViaPoints(request, (List)environment.getArgument("via"));
        return request.buildRequest();
    }

    private static void setPreferences(RoutingPreferencesBuilder prefs, RouteRequestBuilder requestBuilder, boolean isTripPlannedForNow, GraphQLTypes.GraphQLQueryTypePlanConnectionArgs args, DataFetchingEnvironment environment) {
        GraphQLTypes.GraphQLPlanPreferencesInput preferenceArgs = args.getGraphQLPreferences();
        prefs.withItineraryFilter(filters -> RouteRequestMapper.setItineraryFilters(filters, args.getGraphQLItineraryFilter()));
        prefs.withTransit(transit -> prefs.withTransfer(transfer -> TransitPreferencesMapper.setTransitPreferences(transit, transfer, args, environment)));
        RouteRequestMapper.setStreetPreferences(prefs, isTripPlannedForNow, preferenceArgs.getGraphQLStreet(), environment);
        RouteRequestMapper.setAccessibilityPreferences(requestBuilder, preferenceArgs.getGraphQLAccessibility());
        prefs.withLocale(GraphQLUtils.getLocale(environment, args.getGraphQLLocale()));
    }

    private static void setItineraryFilters(ItineraryFilterPreferences.Builder filterPreferences, GraphQLTypes.GraphQLPlanItineraryFilterInput filters) {
        if (filters.getGraphQLItineraryFilterDebugProfile() != null) {
            filterPreferences.withDebug(ItineraryFilterDebugProfileMapper.map(filters.getGraphQLItineraryFilterDebugProfile()));
        }
        if (filters.getGraphQLGroupSimilarityKeepOne() != null) {
            filterPreferences.withGroupSimilarityKeepOne(filters.getGraphQLGroupSimilarityKeepOne());
        }
        if (filters.getGraphQLGroupSimilarityKeepThree() != null) {
            filterPreferences.withGroupSimilarityKeepThree(filters.getGraphQLGroupSimilarityKeepThree());
        }
        if (filters.getGraphQLGroupedOtherThanSameLegsMaxCostMultiplier() != null) {
            filterPreferences.withGroupedOtherThanSameLegsMaxCostMultiplier(filters.getGraphQLGroupedOtherThanSameLegsMaxCostMultiplier());
        }
    }

    private static void setStreetPreferences(RoutingPreferencesBuilder preferences, boolean isTripPlannedForNow, @Nullable GraphQLTypes.GraphQLPlanStreetPreferencesInput args, DataFetchingEnvironment environment) {
        RouteRequestMapper.setRentalAvailabilityPreferences(preferences, isTripPlannedForNow);
        if (args == null) {
            return;
        }
        preferences.withBike(bicycle -> BicyclePreferencesMapper.setBicyclePreferences(bicycle, args.getGraphQLBicycle(), environment));
        preferences.withCar(car -> CarPreferencesMapper.setCarPreferences(car, args.getGraphQLCar(), environment));
        preferences.withScooter(scooter -> ScooterPreferencesMapper.setScooterPreferences(scooter, args.getGraphQLScooter()));
        preferences.withWalk(walk -> WalkPreferencesMapper.setWalkPreferences(walk, args.getGraphQLWalk()));
    }

    private static void setRentalAvailabilityPreferences(RoutingPreferencesBuilder preferences, boolean isTripPlannedForNow) {
        preferences.withBike(bike -> bike.withRental(rental -> rental.withUseAvailabilityInformation(isTripPlannedForNow)));
        preferences.withCar(car -> car.withRental(rental -> rental.withUseAvailabilityInformation(isTripPlannedForNow)));
        preferences.withScooter(scooter -> scooter.withRental(rental -> rental.withUseAvailabilityInformation(isTripPlannedForNow)));
    }

    private static void setAccessibilityPreferences(RouteRequestBuilder requestBuilder, @Nullable GraphQLTypes.GraphQLAccessibilityPreferencesInput preferenceArgs) {
        if (preferenceArgs != null && preferenceArgs.getGraphQLWheelchair() != null) {
            requestBuilder.withJourney(j -> j.withWheelchair(preferenceArgs.getGraphQLWheelchair().getGraphQLEnabled()));
        }
    }

    private static GenericLocation parseGenericLocation(GraphQLTypes.GraphQLPlanLabeledLocationInput locationInput) {
        GraphQLTypes.GraphQLPlanStopLocationInput stopLocation = locationInput.getGraphQLLocation().getGraphQLStopLocation();
        if (stopLocation.getGraphQLStopLocationId() != null) {
            String stopId = stopLocation.getGraphQLStopLocationId();
            if (FeedScopedId.isValidString(stopId)) {
                return new GenericLocation(locationInput.getGraphQLLabel(), FeedScopedId.parse(stopId), null, null);
            }
            throw new IllegalArgumentException("Stop id %s is not of valid format.".formatted(stopId));
        }
        GraphQLTypes.GraphQLPlanCoordinateInput coordinate = locationInput.getGraphQLLocation().getGraphQLCoordinate();
        return new GenericLocation(locationInput.getGraphQLLabel(), null, coordinate.getGraphQLLatitude(), coordinate.getGraphQLLongitude());
    }

    static void mapViaPoints(RouteRequestBuilder request, List<Map<String, Object>> via) {
        request.withViaLocations(ViaLocationMapper.mapToViaLocations(via));
    }
}

