/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.TransitModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.AccessModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ArgumentUtils;
import org.opentripplanner.apis.gtfs.mapping.routerequest.DirectModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.EgressModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.FilterMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.StreetModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.TransferModeMapper;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.JourneyRequestBuilder;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.api.request.request.TransitRequestBuilder;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.routing.api.request.request.filter.TransitFilter;
import org.opentripplanner.routing.api.request.request.filter.TransitFilterRequest;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.utils.collection.CollectionUtils;

public class ModePreferencesMapper {
    static void setModes(JourneyRequestBuilder journey, GraphQLTypes.GraphQLQueryTypePlanConnectionArgs args, DataFetchingEnvironment environment) {
        GraphQLTypes.GraphQLPlanModesInput modesInput = args.getGraphQLModes();
        List<GraphQLTypes.GraphQLPlanDirectMode> direct = modesInput.getGraphQLDirect();
        if (Boolean.TRUE.equals(modesInput.getGraphQLTransitOnly())) {
            journey.withDirect(new StreetRequest(StreetMode.NOT_SET));
        } else if (direct != null) {
            if (direct.isEmpty()) {
                throw new IllegalArgumentException("Direct modes must not be empty.");
            }
            List<StreetMode> streetModes = direct.stream().map(DirectModeMapper::map).toList();
            journey.withDirect(new StreetRequest(StreetModeMapper.getStreetModeForRouting(streetModes)));
        }
        GraphQLTypes.GraphQLPlanTransitModesInput transit = modesInput.getGraphQLTransit();
        if (Boolean.TRUE.equals(modesInput.getGraphQLDirectOnly())) {
            journey.withTransit(TransitRequestBuilder::disable);
        } else if (transit == null) {
            ModePreferencesMapper.setTransitFilters(journey, MainAndSubMode.all(), args);
        } else {
            List<GraphQLTypes.GraphQLPlanTransferMode> transfer;
            List<GraphQLTypes.GraphQLPlanEgressMode> egress;
            List<GraphQLTypes.GraphQLPlanAccessMode> access = transit.getGraphQLAccess();
            if (access != null) {
                if (access.isEmpty()) {
                    throw new IllegalArgumentException("Access modes must not be empty.");
                }
                List<StreetMode> streetModes = access.stream().map(AccessModeMapper::map).toList();
                journey.withAccess(new StreetRequest(StreetModeMapper.getStreetModeForRouting(streetModes)));
            }
            if ((egress = transit.getGraphQLEgress()) != null) {
                if (egress.isEmpty()) {
                    throw new IllegalArgumentException("Egress modes must not be empty.");
                }
                List<StreetMode> streetModes = egress.stream().map(EgressModeMapper::map).toList();
                journey.withEgress(new StreetRequest(StreetModeMapper.getStreetModeForRouting(streetModes)));
            }
            if ((transfer = transit.getGraphQLTransfer()) != null) {
                if (transfer.isEmpty()) {
                    throw new IllegalArgumentException("Transfer modes must not be empty.");
                }
                List<StreetMode> streetModes = transfer.stream().map(TransferModeMapper::map).toList();
                journey.withTransfer(new StreetRequest(StreetModeMapper.getStreetModeForRouting(streetModes)));
            }
            StreetModeMapper.validateStreetModes(journey.build());
            List<Map<String, Object>> transitModes = ArgumentUtils.getTransitModes(environment);
            if (transitModes == null) {
                ModePreferencesMapper.setTransitFilters(journey, MainAndSubMode.all(), args);
            } else {
                if (transitModes.isEmpty()) {
                    throw new IllegalArgumentException("Transit modes must not be empty.");
                }
                List<MainAndSubMode> mainAndSubModes = transitModes.stream().map(mode -> new MainAndSubMode(TransitModeMapper.map(GraphQLTypes.GraphQLTransitMode.valueOf((String)mode.get("mode"))))).toList();
                ModePreferencesMapper.setTransitFilters(journey, mainAndSubModes, args);
            }
        }
    }

    private static void setTransitFilters(JourneyRequestBuilder journey, List<MainAndSubMode> modes, GraphQLTypes.GraphQLQueryTypePlanConnectionArgs args) {
        List<GraphQLTypes.GraphQLTransitFilterInput> graphQlFilters = Optional.ofNullable(args.getGraphQLPreferences()).map(GraphQLTypes.GraphQLPlanPreferencesInput::getGraphQLTransit).map(GraphQLTypes.GraphQLTransitPreferencesInput::getGraphQLFilters).orElse(List.of());
        if (CollectionUtils.hasValue(graphQlFilters)) {
            List<TransitFilter> filters = FilterMapper.mapFilters(modes, graphQlFilters);
            journey.withTransit(b -> b.setFilters(filters));
        } else if (!modes.equals(MainAndSubMode.all())) {
            TransitFilterRequest filter = TransitFilterRequest.of().addSelect(SelectRequest.of().withTransportModes(modes).build()).build();
            journey.withTransit(b -> b.setFilters(List.of(filter)));
        }
    }
}

