/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opentripplanner.api.common.LocationStringParser;
import org.opentripplanner.api.parameter.QualifiedMode;
import org.opentripplanner.api.parameter.QualifiedModeSet;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ArgumentUtils;
import org.opentripplanner.apis.gtfs.mapping.routerequest.OptimizationTypeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ViaLocationMapper;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.framework.time.ZoneIdFallback;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteRequestBuilder;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;
import org.opentripplanner.routing.api.request.preference.ItineraryFilterDebugProfile;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleWalkingPreferences;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.routing.api.request.request.filter.TransitFilterRequest;
import org.opentripplanner.routing.api.request.via.ViaLocation;
import org.opentripplanner.routing.core.VehicleRoutingOptimizeType;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class LegacyRouteRequestMapper {
    public static RouteRequest toRouteRequest(DataFetchingEnvironment environment, GraphQLRequestContext context) {
        RouteRequestBuilder request = context.defaultRouteRequest().copyOf();
        CallerWithEnvironment callWith = new CallerWithEnvironment(environment);
        callWith.argument("fromPlace", from -> request.withFrom(LocationStringParser.fromOldStyleString(from)));
        callWith.argument("toPlace", to -> request.withTo(LocationStringParser.fromOldStyleString(to)));
        callWith.argument("from", v -> request.withFrom(LegacyRouteRequestMapper.toGenericLocation(v)));
        callWith.argument("to", v -> request.withTo(LegacyRouteRequestMapper.toGenericLocation(v)));
        LegacyRouteRequestMapper.mapViaLocations(request, environment);
        request.withDateTime((String)environment.getArgument("date"), (String)environment.getArgument("time"), ZoneIdFallback.zoneId(context.transitService().getTimeZone()));
        boolean isTripPlannedForNow = RouteRequest.isAPIGtfsTripPlannedForNow(request.dateTime());
        callWith.argument("numItineraries", request::withNumItineraries);
        callWith.argument("searchWindow", m -> request.withSearchWindow(Duration.ofSeconds(m)));
        callWith.argument("pageCursor", request::withPageCursorFromEncoded);
        request.withPreferences(preferences -> {
            preferences.withBike(bike -> {
                callWith.argument("bikeReluctance", bike::withReluctance);
                callWith.argument("bikeSpeed", bike::withSpeed);
                callWith.argument("bikeBoardCost", bike::withBoardCost);
                if (environment.getArgument("optimize") != null) {
                    bike.withOptimizeType(OptimizationTypeMapper.map(GraphQLTypes.GraphQLOptimizeType.valueOf((String)environment.getArgument("optimize"))));
                }
                if (bike.optimizeType() == VehicleRoutingOptimizeType.TRIANGLE) {
                    bike.withOptimizeTriangle(triangle -> {
                        callWith.argument("triangle.timeFactor", triangle::withTime);
                        callWith.argument("triangle.slopeFactor", triangle::withSlope);
                        callWith.argument("triangle.safetyFactor", triangle::withSafety);
                    });
                }
                bike.withParking(parking -> LegacyRouteRequestMapper.setParkingPreferences(callWith, parking));
                bike.withRental(rental -> LegacyRouteRequestMapper.setRentalPreferences(callWith, isTripPlannedForNow, rental));
                bike.withWalking(walking -> LegacyRouteRequestMapper.setVehicleWalkingPreferences(callWith, walking));
            });
            preferences.withCar(car -> {
                callWith.argument("carReluctance", car::withReluctance);
                car.withParking(parking -> LegacyRouteRequestMapper.setParkingPreferences(callWith, parking));
                car.withRental(rental -> LegacyRouteRequestMapper.setRentalPreferences(callWith, isTripPlannedForNow, rental));
            });
            preferences.withScooter(scooter -> {
                callWith.argument("bikeReluctance", scooter::withReluctance);
                callWith.argument("bikeSpeed", scooter::withSpeed);
                if (environment.getArgument("optimize") != null) {
                    scooter.withOptimizeType(OptimizationTypeMapper.map(GraphQLTypes.GraphQLOptimizeType.valueOf((String)environment.getArgument("optimize"))));
                }
                if (scooter.optimizeType() == VehicleRoutingOptimizeType.TRIANGLE) {
                    scooter.withOptimizeTriangle(triangle -> {
                        callWith.argument("triangle.timeFactor", triangle::withTime);
                        callWith.argument("triangle.slopeFactor", triangle::withSlope);
                        callWith.argument("triangle.safetyFactor", triangle::withSafety);
                    });
                }
                scooter.withRental(rental -> LegacyRouteRequestMapper.setRentalPreferences(callWith, isTripPlannedForNow, rental));
            });
            preferences.withWalk(b -> {
                callWith.argument("walkReluctance", b::withReluctance);
                callWith.argument("walkSpeed", b::withSpeed);
                callWith.argument("walkBoardCost", b::withBoardCost);
                callWith.argument("walkSafetyFactor", b::withSafetyFactor);
            });
            callWith.argument("debugItineraryFilter", v -> preferences.withItineraryFilter(it -> it.withDebug(ItineraryFilterDebugProfile.ofDebugEnabled(v))));
            preferences.withTransit(tr -> {
                callWith.argument("boardSlack", tr::withDefaultBoardSlackSec);
                callWith.argument("alightSlack", tr::withDefaultAlightSlackSec);
                callWith.argument("preferred.otherThanPreferredRoutesPenalty", tr::setOtherThanPreferredRoutesPenalty);
                callWith.argument("unpreferred.useUnpreferredRoutesPenalty", v -> tr.setUnpreferredCost(CostLinearFunction.of(Duration.ofSeconds(v.intValue()), 0.0)));
                callWith.argument("unpreferred.unpreferredCost", tr::setUnpreferredCostString);
                callWith.argument("ignoreRealtimeUpdates", tr::setIgnoreRealtimeUpdates);
                callWith.argument("modeWeight", modeWeights -> tr.setReluctanceForMode(modeWeights.entrySet().stream().collect(Collectors.toMap(e -> TransitMode.valueOf((String)e.getKey()), e -> (Double)e.getValue()))));
            });
            preferences.withTransfer(tx -> {
                callWith.argument("transferPenalty", tx::withCost);
                callWith.argument("minTransferTime", tx::withSlackSec);
                callWith.argument("waitReluctance", tx::withWaitReluctance);
                callWith.argument("maxTransfers", tx::withMaxTransfers);
                callWith.argument("nonpreferredTransferPenalty", tx::withNonpreferredCost);
            });
            callWith.argument("locale", v -> preferences.withLocale(GraphQLUtils.getLocale(environment, v)));
        });
        callWith.argument("arriveBy", request::withArriveBy);
        request.withJourney(journeyBuilder -> {
            callWith.argument("wheelchair", journeyBuilder::withWheelchair);
            journeyBuilder.withTransit(transitBuilder -> {
                callWith.argument("unpreferred.routes", v -> transitBuilder.withUnpreferredRoutes(FeedScopedId.parseList(v)));
                callWith.argument("unpreferred.agencies", v -> transitBuilder.withUnpreferredAgencies(FeedScopedId.parseList(v)));
                boolean transitDisabled = false;
                if (LegacyRouteRequestMapper.hasArgument(environment, "banned") || LegacyRouteRequestMapper.hasArgument(environment, "transportModes")) {
                    TransitFilterRequest.Builder filterRequestBuilder = TransitFilterRequest.of();
                    callWith.argument("banned.routes", v -> filterRequestBuilder.addNot(SelectRequest.of().withRoutes(FeedScopedId.parseList(v)).build()));
                    callWith.argument("banned.agencies", v -> filterRequestBuilder.addNot(SelectRequest.of().withAgencies(FeedScopedId.parseList(v)).build()));
                    callWith.argument("banned.trips", v -> journeyBuilder.withTransit(b -> b.withBannedTrips(FeedScopedId.parseList(v))));
                    if (LegacyRouteRequestMapper.hasArgument(environment, "transportModes")) {
                        QualifiedModeSet modes = new QualifiedModeSet("WALK");
                        modes.qModes = ((List)environment.getArgument("transportModes")).stream().map(transportMode -> new QualifiedMode((String)transportMode.get("mode") + (String)(transportMode.get("qualifier") == null ? "" : "_" + (String)transportMode.get("qualifier")))).collect(Collectors.toSet());
                        journeyBuilder.setModes(modes.getRequestModes());
                        List<MainAndSubMode> tModes = modes.getTransitModes().stream().map(MainAndSubMode::new).toList();
                        if (tModes.isEmpty()) {
                            transitDisabled = true;
                        } else {
                            filterRequestBuilder.addSelect(SelectRequest.of().withTransportModes(tModes).build());
                        }
                    }
                    if (transitDisabled) {
                        transitBuilder.disable();
                    } else {
                        transitBuilder.setFilters(List.of(filterRequestBuilder.build()));
                    }
                }
            });
        });
        if (LegacyRouteRequestMapper.hasArgument(environment, "allowedTicketTypes")) {
            // empty if block
        }
        return request.buildRequest();
    }

    static void mapViaLocations(RouteRequestBuilder request, DataFetchingEnvironment env) {
        Object args = env.getArgument("via");
        List<ViaLocation> locs = ViaLocationMapper.mapToViaLocations((List)args);
        request.withViaLocations(locs);
    }

    private static <T> boolean hasArgument(Map<String, T> m, String name) {
        return m.containsKey(name) && m.get(name) != null;
    }

    private static boolean hasArgument(DataFetchingEnvironment environment, String name) {
        return environment.containsArgument(name) && environment.getArgument(name) != null;
    }

    private static GenericLocation toGenericLocation(Map<String, Object> m) {
        double lat = (Double)m.get("lat");
        double lng = (Double)m.get("lon");
        String address = (String)m.get("address");
        if (address != null) {
            return new GenericLocation(address, null, lat, lng);
        }
        return GenericLocation.fromCoordinate(lat, lng);
    }

    private static void setParkingPreferences(CallerWithEnvironment callWith, VehicleParkingPreferences.Builder parking) {
        callWith.argument("parking.unpreferredCost", parking::withUnpreferredVehicleParkingTagCost);
        callWith.argument("parking.filters", filters -> {
            parking.withRequiredVehicleParkingTags(ArgumentUtils.parseSelectFilters(filters));
            parking.withBannedVehicleParkingTags(ArgumentUtils.parseNotFilters(filters));
        });
        callWith.argument("parking.preferred", preferred -> {
            parking.withPreferredVehicleParkingTags(ArgumentUtils.parseSelectFilters(preferred));
            parking.withNotPreferredVehicleParkingTags(ArgumentUtils.parseNotFilters(preferred));
        });
    }

    private static void setRentalPreferences(CallerWithEnvironment callWith, boolean isTripPlannedForNow, VehicleRentalPreferences.Builder rental) {
        callWith.argument("keepingRentedBicycleAtDestinationCost", rental::withArrivingInRentalVehicleAtDestinationCost);
        rental.withUseAvailabilityInformation(isTripPlannedForNow);
        callWith.argument("allowKeepingRentedBicycleAtDestination", rental::withAllowArrivingInRentedVehicleAtDestination);
        callWith.argument("allowedBikeRentalNetworks", v -> rental.withAllowedNetworks(new HashSet<String>((Collection<String>)v)));
        callWith.argument("allowedVehicleRentalNetworks", v -> rental.withAllowedNetworks(new HashSet<String>((Collection<String>)v)));
        callWith.argument("bannedVehicleRentalNetworks", v -> rental.withBannedNetworks(new HashSet<String>((Collection<String>)v)));
    }

    private static void setVehicleWalkingPreferences(CallerWithEnvironment callWith, VehicleWalkingPreferences.Builder walking) {
        callWith.argument("bikeWalkingReluctance", walking::withReluctance);
        callWith.argument("bikeWalkingSpeed", walking::withSpeed);
        callWith.argument("bikeSwitchTime", time -> walking.withMountDismountTime((Integer)time));
        callWith.argument("bikeSwitchCost", cost -> walking.withMountDismountCost((Integer)cost));
    }

    private static class CallerWithEnvironment {
        private final DataFetchingEnvironment environment;

        public CallerWithEnvironment(DataFetchingEnvironment e) {
            this.environment = e;
        }

        private static <T> void call(DataFetchingEnvironment environment, String name, Consumer<T> consumer) {
            if (!name.contains(".")) {
                if (LegacyRouteRequestMapper.hasArgument(environment, name)) {
                    consumer.accept(environment.getArgument(name));
                }
            } else {
                String[] parts = name.split("\\.");
                if (LegacyRouteRequestMapper.hasArgument(environment, parts[0])) {
                    Map nm = (Map)environment.getArgument(parts[0]);
                    CallerWithEnvironment.call(nm, String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length)), consumer);
                }
            }
        }

        private static <T> void call(Map<String, T> m, String name, Consumer<T> consumer) {
            if (!name.contains(".")) {
                if (LegacyRouteRequestMapper.hasArgument(m, name)) {
                    T v = m.get(name);
                    consumer.accept(v);
                }
            } else {
                String[] parts = name.split("\\.");
                if (LegacyRouteRequestMapper.hasArgument(m, parts[0])) {
                    Map nm = (Map)m.get(parts[0]);
                    CallerWithEnvironment.call(nm, String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length)), consumer);
                }
            }
        }

        private <T> void argument(String name, Consumer<T> consumer) {
            CallerWithEnvironment.call(this.environment, name, consumer);
        }
    }
}

