/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.apis.gtfs.GraphQLUtils;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.routerequest.SelectRequestMapper;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.routing.api.request.request.filter.TransitFilter;
import org.opentripplanner.routing.api.request.request.filter.TransitFilterRequest;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.utils.collection.CollectionUtils;
import org.opentripplanner.utils.collection.ListUtils;

class FilterMapper {
    FilterMapper() {
    }

    static List<TransitFilter> mapFilters(List<MainAndSubMode> modes, List<GraphQLTypes.GraphQLTransitFilterInput> filters) {
        ArrayList<TransitFilter> filterRequests = new ArrayList<TransitFilter>();
        for (GraphQLTypes.GraphQLTransitFilterInput filterInput : filters) {
            List<GraphQLTypes.GraphQLTransitFilterSelectInput> includes = filterInput.getGraphQLInclude();
            List<GraphQLTypes.GraphQLTransitFilterSelectInput> excludes = filterInput.getGraphQLExclude();
            CollectionUtils.requireNullOrNonEmpty(includes, (String)"filters.include");
            CollectionUtils.requireNullOrNonEmpty(excludes, (String)"filters.exclude");
            if (CollectionUtils.isEmpty(excludes) && CollectionUtils.isEmpty(includes)) {
                String typeName = GraphQLUtils.typeName(filterInput);
                throw new IllegalArgumentException("%s must contain at least one 'include' or 'exclude'.".formatted(typeName));
            }
            TransitFilterRequest.Builder filterRequestBuilder = TransitFilterRequest.of();
            if (CollectionUtils.isEmpty(includes)) {
                SelectRequest modeSelect = SelectRequest.of().withTransportModes(modes).build();
                filterRequestBuilder.addSelect(modeSelect);
            } else {
                for (GraphQLTypes.GraphQLTransitFilterSelectInput selectInput : ListUtils.nullSafeImmutableList(includes)) {
                    SelectRequest.Builder builder = SelectRequestMapper.mapSelectRequest(selectInput, "include");
                    builder.withTransportModes(modes);
                    filterRequestBuilder.addSelect(builder.build());
                }
            }
            for (GraphQLTypes.GraphQLTransitFilterSelectInput selectInput : ListUtils.nullSafeImmutableList(excludes)) {
                filterRequestBuilder.addNot(SelectRequestMapper.mapSelectRequest(selectInput, "exclude").build());
            }
            filterRequests.add(filterRequestBuilder.build());
        }
        return filterRequests;
    }
}

