/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ArgumentUtils;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.routing.api.request.preference.CarPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;

public class CarPreferencesMapper {
    static void setCarPreferences(CarPreferences.Builder preferences, GraphQLTypes.GraphQLCarPreferencesInput args, DataFetchingEnvironment environment) {
        Cost boardCost;
        if (args == null) {
            return;
        }
        Double reluctance = args.getGraphQLReluctance();
        if (reluctance != null) {
            preferences.withReluctance(reluctance);
        }
        if ((boardCost = args.getGraphQLBoardCost()) != null) {
            preferences.withBoardCost(boardCost.toSeconds());
        }
        preferences.withParking(parking -> CarPreferencesMapper.setCarParkingPreferences(parking, args.getGraphQLParking(), environment));
        preferences.withRental(rental -> CarPreferencesMapper.setCarRentalPreferences(rental, args.getGraphQLRental()));
    }

    private static void setCarParkingPreferences(VehicleParkingPreferences.Builder preferences, GraphQLTypes.GraphQLCarParkingPreferencesInput args, DataFetchingEnvironment environment) {
        if (args == null) {
            return;
        }
        Cost unpreferredCost = args.getGraphQLUnpreferredCost();
        if (unpreferredCost != null) {
            preferences.withUnpreferredVehicleParkingTagCost(unpreferredCost.toSeconds());
        }
        Collection<Map<String, Object>> filters = ArgumentUtils.getParkingFilters(environment, "car");
        preferences.withRequiredVehicleParkingTags(ArgumentUtils.parseSelectFilters(filters));
        preferences.withBannedVehicleParkingTags(ArgumentUtils.parseNotFilters(filters));
        Collection<Map<String, Object>> preferred = ArgumentUtils.getParkingPreferred(environment, "car");
        preferences.withPreferredVehicleParkingTags(ArgumentUtils.parseSelectFilters(preferred));
        preferences.withNotPreferredVehicleParkingTags(ArgumentUtils.parseNotFilters(preferred));
    }

    private static void setCarRentalPreferences(VehicleRentalPreferences.Builder preferences, GraphQLTypes.GraphQLCarRentalPreferencesInput args) {
        List<String> bannedNetworks;
        if (args == null) {
            return;
        }
        List<String> allowedNetworks = args.getGraphQLAllowedNetworks();
        if (allowedNetworks != null) {
            if (allowedNetworks.isEmpty()) {
                throw new IllegalArgumentException("Allowed car rental networks must not be empty.");
            }
            preferences.withAllowedNetworks(Set.copyOf(allowedNetworks));
        }
        if ((bannedNetworks = args.getGraphQLBannedNetworks()) != null) {
            preferences.withBannedNetworks(Set.copyOf(bannedNetworks));
        }
    }
}

