/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.routerequest.ArgumentUtils;
import org.opentripplanner.apis.gtfs.mapping.routerequest.VehicleOptimizationTypeMapper;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.routing.api.request.preference.BikePreferences;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleWalkingPreferences;
import org.opentripplanner.routing.core.VehicleRoutingOptimizeType;
import org.opentripplanner.utils.time.DurationUtils;

public class BicyclePreferencesMapper {
    static void setBicyclePreferences(BikePreferences.Builder preferences, GraphQLTypes.GraphQLBicyclePreferencesInput args, DataFetchingEnvironment environment) {
        Cost boardCost;
        Double reluctance;
        if (args == null) {
            return;
        }
        Double speed = args.getGraphQLSpeed();
        if (speed != null) {
            preferences.withSpeed(speed);
        }
        if ((reluctance = args.getGraphQLReluctance()) != null) {
            preferences.withReluctance(reluctance);
        }
        if ((boardCost = args.getGraphQLBoardCost()) != null) {
            preferences.withBoardCost(boardCost.toSeconds());
        }
        preferences.withWalking(walk -> BicyclePreferencesMapper.setBicycleWalkPreferences(walk, args.getGraphQLWalk()));
        preferences.withParking(parking -> BicyclePreferencesMapper.setBicycleParkingPreferences(parking, args.getGraphQLParking(), environment));
        preferences.withRental(rental -> BicyclePreferencesMapper.setBicycleRentalPreferences(rental, args.getGraphQLRental()));
        BicyclePreferencesMapper.setBicycleOptimization(preferences, args.getGraphQLOptimization());
    }

    private static void setBicycleWalkPreferences(VehicleWalkingPreferences.Builder preferences, GraphQLTypes.GraphQLBicycleWalkPreferencesInput args) {
        GraphQLTypes.GraphQLBicycleWalkPreferencesCostInput cost;
        Duration mountTime;
        if (args == null) {
            return;
        }
        Double speed = args.getGraphQLSpeed();
        if (speed != null) {
            preferences.withSpeed(speed);
        }
        if ((mountTime = args.getGraphQLMountDismountTime()) != null) {
            preferences.withMountDismountTime(DurationUtils.requireNonNegativeMax30minutes((Duration)mountTime, (String)"bicycle mount dismount time"));
        }
        if ((cost = args.getGraphQLCost()) != null) {
            Cost mountCost;
            Double reluctance = cost.getGraphQLReluctance();
            if (reluctance != null) {
                preferences.withReluctance(reluctance);
            }
            if ((mountCost = cost.getGraphQLMountDismountCost()) != null) {
                preferences.withMountDismountCost(mountCost.toSeconds());
            }
        }
    }

    private static void setBicycleParkingPreferences(VehicleParkingPreferences.Builder preferences, GraphQLTypes.GraphQLBicycleParkingPreferencesInput args, DataFetchingEnvironment environment) {
        if (args == null) {
            return;
        }
        Cost unpreferredCost = args.getGraphQLUnpreferredCost();
        if (unpreferredCost != null) {
            preferences.withUnpreferredVehicleParkingTagCost(unpreferredCost.toSeconds());
        }
        Collection<Map<String, Object>> filters = ArgumentUtils.getParkingFilters(environment, "bicycle");
        preferences.withRequiredVehicleParkingTags(ArgumentUtils.parseSelectFilters(filters));
        preferences.withBannedVehicleParkingTags(ArgumentUtils.parseNotFilters(filters));
        Collection<Map<String, Object>> preferred = ArgumentUtils.getParkingPreferred(environment, "bicycle");
        preferences.withPreferredVehicleParkingTags(ArgumentUtils.parseSelectFilters(preferred));
        preferences.withNotPreferredVehicleParkingTags(ArgumentUtils.parseNotFilters(preferred));
    }

    private static void setBicycleRentalPreferences(VehicleRentalPreferences.Builder preferences, GraphQLTypes.GraphQLBicycleRentalPreferencesInput args) {
        GraphQLTypes.GraphQLDestinationBicyclePolicyInput destinationPolicy;
        List<String> bannedNetworks;
        if (args == null) {
            return;
        }
        List<String> allowedNetworks = args.getGraphQLAllowedNetworks();
        if (allowedNetworks != null) {
            if (allowedNetworks.isEmpty()) {
                throw new IllegalArgumentException("Allowed bicycle rental networks must not be empty.");
            }
            preferences.withAllowedNetworks(Set.copyOf(allowedNetworks));
        }
        if ((bannedNetworks = args.getGraphQLBannedNetworks()) != null) {
            preferences.withBannedNetworks(Set.copyOf(bannedNetworks));
        }
        if ((destinationPolicy = args.getGraphQLDestinationBicyclePolicy()) != null) {
            Cost cost;
            Boolean allowed = destinationPolicy.getGraphQLAllowKeeping();
            if (allowed != null) {
                preferences.withAllowArrivingInRentedVehicleAtDestination(allowed);
            }
            if ((cost = destinationPolicy.getGraphQLKeepingCost()) != null) {
                preferences.withArrivingInRentalVehicleAtDestinationCost(cost.toSeconds());
            }
        }
    }

    private static void setBicycleOptimization(BikePreferences.Builder preferences, GraphQLTypes.GraphQLCyclingOptimizationInput args) {
        GraphQLTypes.GraphQLTriangleCyclingFactorsInput triangleArgs;
        VehicleRoutingOptimizeType mappedType;
        if (args == null) {
            return;
        }
        GraphQLTypes.GraphQLCyclingOptimizationType type = args.getGraphQLType();
        VehicleRoutingOptimizeType vehicleRoutingOptimizeType = mappedType = type != null ? VehicleOptimizationTypeMapper.map(type) : null;
        if (mappedType != null) {
            preferences.withOptimizeType(mappedType);
        }
        if (BicyclePreferencesMapper.isBicycleTriangleSet(triangleArgs = args.getGraphQLTriangle())) {
            preferences.withForcedOptimizeTriangle(triangle -> triangle.withSlope(triangleArgs.getGraphQLFlatness()).withSafety(triangleArgs.getGraphQLSafety()).withTime(triangleArgs.getGraphQLTime()));
        }
    }

    private static boolean isBicycleTriangleSet(GraphQLTypes.GraphQLTriangleCyclingFactorsInput args) {
        return args != null && args.getGraphQLFlatness() != null && args.getGraphQLSafety() != null && args.getGraphQLTime() != null;
    }
}

