/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ArgumentUtils {
    @Nullable
    static List<Map<String, Object>> getTransitModes(DataFetchingEnvironment environment) {
        Map transitArgs;
        Map modesArgs;
        if (environment.containsArgument("modes") && (modesArgs = (Map)environment.getArgument("modes")).containsKey("transit") && (transitArgs = (Map)modesArgs.get("transit")).containsKey("transit")) {
            return (List)transitArgs.get("transit");
        }
        return null;
    }

    @Nullable
    static Map<String, Object> getParking(DataFetchingEnvironment environment, String type) {
        return (Map)((Map)((Map)((Map)environment.getArgument("preferences")).get("street")).get(type)).get("parking");
    }

    static Collection<Map<String, Object>> getParkingFilters(DataFetchingEnvironment environment, String type) {
        Map<String, Object> parking = ArgumentUtils.getParking(environment, type);
        Object filters = parking != null && parking.containsKey("filters") ? ArgumentUtils.getParking(environment, type).get("filters") : null;
        return filters != null ? (Collection)filters : List.of();
    }

    static Collection<Map<String, Object>> getParkingPreferred(DataFetchingEnvironment environment, String type) {
        Map<String, Object> parking = ArgumentUtils.getParking(environment, type);
        Object preferred = parking != null && parking.containsKey("preferred") ? ArgumentUtils.getParking(environment, type).get("preferred") : null;
        return preferred != null ? (Collection)preferred : List.of();
    }

    static Set<String> parseNotFilters(Collection<Map<String, Object>> filters) {
        return ArgumentUtils.parseFilters(filters, "not");
    }

    static Set<String> parseSelectFilters(Collection<Map<String, Object>> filters) {
        return ArgumentUtils.parseFilters(filters, "select");
    }

    private static Set<String> parseFilters(Collection<Map<String, Object>> filters, String key) {
        return filters.stream().flatMap(f -> ArgumentUtils.parseOperation(f.getOrDefault(key, List.of()))).collect(Collectors.toSet());
    }

    private static Stream<String> parseOperation(Collection<Map<String, Collection<String>>> map) {
        return map.stream().flatMap(f -> {
            Collection tags = f.getOrDefault("tags", List.of());
            return tags.stream();
        });
    }
}

