/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.mapping.routerequest;

import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.routing.api.request.StreetMode;

public class AccessModeMapper {
    public static StreetMode map(GraphQLTypes.GraphQLPlanAccessMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case GraphQLTypes.GraphQLPlanAccessMode.BICYCLE -> StreetMode.BIKE;
            case GraphQLTypes.GraphQLPlanAccessMode.BICYCLE_RENTAL -> StreetMode.BIKE_RENTAL;
            case GraphQLTypes.GraphQLPlanAccessMode.BICYCLE_PARKING -> StreetMode.BIKE_TO_PARK;
            case GraphQLTypes.GraphQLPlanAccessMode.CAR -> StreetMode.CAR;
            case GraphQLTypes.GraphQLPlanAccessMode.CAR_RENTAL -> StreetMode.CAR_RENTAL;
            case GraphQLTypes.GraphQLPlanAccessMode.CAR_PARKING -> StreetMode.CAR_TO_PARK;
            case GraphQLTypes.GraphQLPlanAccessMode.CAR_DROP_OFF -> StreetMode.CAR_PICKUP;
            case GraphQLTypes.GraphQLPlanAccessMode.FLEX -> StreetMode.FLEXIBLE;
            case GraphQLTypes.GraphQLPlanAccessMode.SCOOTER_RENTAL -> StreetMode.SCOOTER_RENTAL;
            case GraphQLTypes.GraphQLPlanAccessMode.WALK -> StreetMode.WALK;
        };
    }

    public static GraphQLTypes.GraphQLPlanAccessMode map(StreetMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case StreetMode.BIKE -> GraphQLTypes.GraphQLPlanAccessMode.BICYCLE;
            case StreetMode.BIKE_RENTAL -> GraphQLTypes.GraphQLPlanAccessMode.BICYCLE_RENTAL;
            case StreetMode.BIKE_TO_PARK -> GraphQLTypes.GraphQLPlanAccessMode.BICYCLE_PARKING;
            case StreetMode.CAR -> GraphQLTypes.GraphQLPlanAccessMode.CAR;
            case StreetMode.CAR_RENTAL -> GraphQLTypes.GraphQLPlanAccessMode.CAR_RENTAL;
            case StreetMode.CAR_TO_PARK -> GraphQLTypes.GraphQLPlanAccessMode.CAR_PARKING;
            case StreetMode.CAR_PICKUP -> GraphQLTypes.GraphQLPlanAccessMode.CAR_DROP_OFF;
            case StreetMode.FLEXIBLE -> GraphQLTypes.GraphQLPlanAccessMode.FLEX;
            case StreetMode.SCOOTER_RENTAL -> GraphQLTypes.GraphQLPlanAccessMode.SCOOTER_RENTAL;
            case StreetMode.WALK, StreetMode.CAR_HAILING, StreetMode.NOT_SET -> GraphQLTypes.GraphQLPlanAccessMode.WALK;
        };
    }
}

