/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.generated;

import graphql.relay.Relay;
import java.time.Duration;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.framework.model.Cost;

public class GraphQLTypes {

    public static class GraphQLWheelchairPreferencesInput {
        private Boolean enabled;

        public GraphQLWheelchairPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.enabled = (Boolean)args.get("enabled");
            }
        }

        public Boolean getGraphQLEnabled() {
            return this.enabled;
        }

        public void setGraphQLEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static enum GraphQLWheelchairBoarding {
        NOT_POSSIBLE,
        NO_INFORMATION,
        POSSIBLE;

    }

    public static class GraphQLWalkPreferencesInput {
        private Cost boardCost;
        private Double reluctance;
        private Double safetyFactor;
        private Double speed;

        public GraphQLWalkPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.boardCost = (Cost)args.get("boardCost");
                this.reluctance = (Double)args.get("reluctance");
                this.safetyFactor = (Double)args.get("safetyFactor");
                this.speed = (Double)args.get("speed");
            }
        }

        public Cost getGraphQLBoardCost() {
            return this.boardCost;
        }

        public Double getGraphQLReluctance() {
            return this.reluctance;
        }

        public Double getGraphQLSafetyFactor() {
            return this.safetyFactor;
        }

        public Double getGraphQLSpeed() {
            return this.speed;
        }

        public void setGraphQLBoardCost(Cost boardCost) {
            this.boardCost = boardCost;
        }

        public void setGraphQLReluctance(Double reluctance) {
            this.reluctance = reluctance;
        }

        public void setGraphQLSafetyFactor(Double safetyFactor) {
            this.safetyFactor = safetyFactor;
        }

        public void setGraphQLSpeed(Double speed) {
            this.speed = speed;
        }
    }

    public static enum GraphQLVertexType {
        BIKEPARK,
        BIKESHARE,
        NORMAL,
        PARKANDRIDE,
        TRANSIT;

    }

    public static enum GraphQLVehicleStopStatus {
        INCOMING_AT,
        IN_TRANSIT_TO,
        STOPPED_AT;

    }

    public static enum GraphQLVehicleParkingState {
        CLOSED,
        OPERATIONAL,
        TEMPORARILY_CLOSED;

    }

    public static class GraphQLVehicleParkingInput {
        private List<GraphQLParkingFilterInput> filters;
        private List<GraphQLParkingFilterInput> preferred;
        private Integer unpreferredCost;

        public GraphQLVehicleParkingInput(Map<String, Object> args) {
            if (args != null) {
                if (args.get("filters") != null) {
                    this.filters = ((List)args.get("filters")).stream().map(o -> o == null ? null : new GraphQLParkingFilterInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                if (args.get("preferred") != null) {
                    this.preferred = ((List)args.get("preferred")).stream().map(o -> o == null ? null : new GraphQLParkingFilterInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                this.unpreferredCost = (Integer)args.get("unpreferredCost");
            }
        }

        public List<GraphQLParkingFilterInput> getGraphQLFilters() {
            return this.filters;
        }

        public List<GraphQLParkingFilterInput> getGraphQLPreferred() {
            return this.preferred;
        }

        public Integer getGraphQLUnpreferredCost() {
            return this.unpreferredCost;
        }

        public void setGraphQLFilters(List<GraphQLParkingFilterInput> filters) {
            this.filters = filters;
        }

        public void setGraphQLPreferred(List<GraphQLParkingFilterInput> preferred) {
            this.preferred = preferred;
        }

        public void setGraphQLUnpreferredCost(Integer unpreferredCost) {
            this.unpreferredCost = unpreferredCost;
        }
    }

    public static class GraphQLVehicleParkingNoteArgs {
        private String language;

        public GraphQLVehicleParkingNoteArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLVehicleParkingNameArgs {
        private String language;

        public GraphQLVehicleParkingNameArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static enum GraphQLTripAlertType {
        AGENCY,
        PATTERN,
        ROUTE,
        ROUTE_TYPE,
        STOPS_ON_TRIP,
        TRIP;

    }

    public static class GraphQLTripTripHeadsignArgs {
        private String language;

        public GraphQLTripTripHeadsignArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLTripStoptimesForDateArgs {
        private String serviceDate;

        public GraphQLTripStoptimesForDateArgs(Map<String, Object> args) {
            if (args != null) {
                this.serviceDate = (String)args.get("serviceDate");
            }
        }

        public String getGraphQLServiceDate() {
            return this.serviceDate;
        }

        public void setGraphQLServiceDate(String serviceDate) {
            this.serviceDate = serviceDate;
        }
    }

    public static class GraphQLTripDepartureStoptimeArgs {
        private String serviceDate;

        public GraphQLTripDepartureStoptimeArgs(Map<String, Object> args) {
            if (args != null) {
                this.serviceDate = (String)args.get("serviceDate");
            }
        }

        public String getGraphQLServiceDate() {
            return this.serviceDate;
        }

        public void setGraphQLServiceDate(String serviceDate) {
            this.serviceDate = serviceDate;
        }
    }

    public static class GraphQLTripArrivalStoptimeArgs {
        private String serviceDate;

        public GraphQLTripArrivalStoptimeArgs(Map<String, Object> args) {
            if (args != null) {
                this.serviceDate = (String)args.get("serviceDate");
            }
        }

        public String getGraphQLServiceDate() {
            return this.serviceDate;
        }

        public void setGraphQLServiceDate(String serviceDate) {
            this.serviceDate = serviceDate;
        }
    }

    public static class GraphQLTripAlertsArgs {
        private List<GraphQLTripAlertType> types;

        public GraphQLTripAlertsArgs(Map<String, Object> args) {
            if (args != null && args.get("types") != null) {
                this.types = ((List)args.get("types")).stream().map(item -> item instanceof GraphQLTripAlertType ? item : GraphQLTripAlertType.valueOf((String)item)).map(GraphQLTripAlertType.class::cast).collect(Collectors.toList());
            }
        }

        public List<GraphQLTripAlertType> getGraphQLTypes() {
            return this.types;
        }

        public void setGraphQLTypes(List<GraphQLTripAlertType> types) {
            this.types = types;
        }
    }

    public static class GraphQLTriangleScooterFactorsInput {
        private Double flatness;
        private Double safety;
        private Double time;

        public GraphQLTriangleScooterFactorsInput(Map<String, Object> args) {
            if (args != null) {
                this.flatness = (Double)args.get("flatness");
                this.safety = (Double)args.get("safety");
                this.time = (Double)args.get("time");
            }
        }

        public Double getGraphQLFlatness() {
            return this.flatness;
        }

        public Double getGraphQLSafety() {
            return this.safety;
        }

        public Double getGraphQLTime() {
            return this.time;
        }

        public void setGraphQLFlatness(Double flatness) {
            this.flatness = flatness;
        }

        public void setGraphQLSafety(Double safety) {
            this.safety = safety;
        }

        public void setGraphQLTime(Double time) {
            this.time = time;
        }
    }

    public static class GraphQLTriangleCyclingFactorsInput {
        private Double flatness;
        private Double safety;
        private Double time;

        public GraphQLTriangleCyclingFactorsInput(Map<String, Object> args) {
            if (args != null) {
                this.flatness = (Double)args.get("flatness");
                this.safety = (Double)args.get("safety");
                this.time = (Double)args.get("time");
            }
        }

        public Double getGraphQLFlatness() {
            return this.flatness;
        }

        public Double getGraphQLSafety() {
            return this.safety;
        }

        public Double getGraphQLTime() {
            return this.time;
        }

        public void setGraphQLFlatness(Double flatness) {
            this.flatness = flatness;
        }

        public void setGraphQLSafety(Double safety) {
            this.safety = safety;
        }

        public void setGraphQLTime(Double time) {
            this.time = time;
        }
    }

    public static class GraphQLTransportModeInput {
        private GraphQLMode mode;
        private GraphQLQualifier qualifier;

        public GraphQLTransportModeInput(Map<String, Object> args) {
            if (args != null) {
                if (args.get("mode") instanceof GraphQLMode) {
                    this.mode = (GraphQLMode)((Object)args.get("mode"));
                } else if (args.get("mode") != null) {
                    this.mode = GraphQLMode.valueOf((String)args.get("mode"));
                }
                if (args.get("qualifier") instanceof GraphQLQualifier) {
                    this.qualifier = (GraphQLQualifier)((Object)args.get("qualifier"));
                } else if (args.get("qualifier") != null) {
                    this.qualifier = GraphQLQualifier.valueOf((String)args.get("qualifier"));
                }
            }
        }

        public GraphQLMode getGraphQLMode() {
            return this.mode;
        }

        public GraphQLQualifier getGraphQLQualifier() {
            return this.qualifier;
        }

        public void setGraphQLMode(GraphQLMode mode) {
            this.mode = mode;
        }

        public void setGraphQLQualifier(GraphQLQualifier qualifier) {
            this.qualifier = qualifier;
        }
    }

    public static class GraphQLTransitPreferencesInput {
        private GraphQLAlightPreferencesInput alight;
        private GraphQLBoardPreferencesInput board;
        private List<GraphQLTransitFilterInput> filters;
        private GraphQLTimetablePreferencesInput timetable;
        private GraphQLTransferPreferencesInput transfer;

        public GraphQLTransitPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.alight = new GraphQLAlightPreferencesInput((Map)args.get("alight"));
                this.board = new GraphQLBoardPreferencesInput((Map)args.get("board"));
                if (args.get("filters") != null) {
                    this.filters = ((List)args.get("filters")).stream().map(o -> o == null ? null : new GraphQLTransitFilterInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                this.timetable = new GraphQLTimetablePreferencesInput((Map)args.get("timetable"));
                this.transfer = new GraphQLTransferPreferencesInput((Map)args.get("transfer"));
            }
        }

        public GraphQLAlightPreferencesInput getGraphQLAlight() {
            return this.alight;
        }

        public GraphQLBoardPreferencesInput getGraphQLBoard() {
            return this.board;
        }

        public List<GraphQLTransitFilterInput> getGraphQLFilters() {
            return this.filters;
        }

        public GraphQLTimetablePreferencesInput getGraphQLTimetable() {
            return this.timetable;
        }

        public GraphQLTransferPreferencesInput getGraphQLTransfer() {
            return this.transfer;
        }

        public void setGraphQLAlight(GraphQLAlightPreferencesInput alight) {
            this.alight = alight;
        }

        public void setGraphQLBoard(GraphQLBoardPreferencesInput board) {
            this.board = board;
        }

        public void setGraphQLFilters(List<GraphQLTransitFilterInput> filters) {
            this.filters = filters;
        }

        public void setGraphQLTimetable(GraphQLTimetablePreferencesInput timetable) {
            this.timetable = timetable;
        }

        public void setGraphQLTransfer(GraphQLTransferPreferencesInput transfer) {
            this.transfer = transfer;
        }
    }

    public static class GraphQLTransitModePreferenceCostInput {
        private Double reluctance;

        public GraphQLTransitModePreferenceCostInput(Map<String, Object> args) {
            if (args != null) {
                this.reluctance = (Double)args.get("reluctance");
            }
        }

        public Double getGraphQLReluctance() {
            return this.reluctance;
        }

        public void setGraphQLReluctance(Double reluctance) {
            this.reluctance = reluctance;
        }
    }

    public static enum GraphQLTransitMode {
        AIRPLANE,
        BUS,
        CABLE_CAR,
        CARPOOL,
        COACH,
        FERRY,
        FUNICULAR,
        GONDOLA,
        MONORAIL,
        RAIL,
        SUBWAY,
        TAXI,
        TRAM,
        TROLLEYBUS;

    }

    public static class GraphQLTransitFilterSelectInput {
        private List<String> agencies;
        private List<String> routes;

        public GraphQLTransitFilterSelectInput(Map<String, Object> args) {
            if (args != null) {
                this.agencies = (List)args.get("agencies");
                this.routes = (List)args.get("routes");
            }
        }

        public List<String> getGraphQLAgencies() {
            return this.agencies;
        }

        public List<String> getGraphQLRoutes() {
            return this.routes;
        }

        public void setGraphQLAgencies(List<String> agencies) {
            this.agencies = agencies;
        }

        public void setGraphQLRoutes(List<String> routes) {
            this.routes = routes;
        }
    }

    public static class GraphQLTransitFilterInput {
        private List<GraphQLTransitFilterSelectInput> exclude;
        private List<GraphQLTransitFilterSelectInput> include;

        public GraphQLTransitFilterInput(Map<String, Object> args) {
            if (args != null) {
                if (args.get("exclude") != null) {
                    this.exclude = ((List)args.get("exclude")).stream().map(o -> o == null ? null : new GraphQLTransitFilterSelectInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                if (args.get("include") != null) {
                    this.include = ((List)args.get("include")).stream().map(o -> o == null ? null : new GraphQLTransitFilterSelectInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
            }
        }

        public List<GraphQLTransitFilterSelectInput> getGraphQLExclude() {
            return this.exclude;
        }

        public List<GraphQLTransitFilterSelectInput> getGraphQLInclude() {
            return this.include;
        }

        public void setGraphQLExclude(List<GraphQLTransitFilterSelectInput> exclude) {
            this.exclude = exclude;
        }

        public void setGraphQLInclude(List<GraphQLTransitFilterSelectInput> include) {
            this.include = include;
        }
    }

    public static class GraphQLTransferPreferencesInput {
        private Cost cost;
        private Integer maximumAdditionalTransfers;
        private Integer maximumTransfers;
        private Duration slack;

        public GraphQLTransferPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.cost = (Cost)args.get("cost");
                this.maximumAdditionalTransfers = (Integer)args.get("maximumAdditionalTransfers");
                this.maximumTransfers = (Integer)args.get("maximumTransfers");
                this.slack = (Duration)args.get("slack");
            }
        }

        public Cost getGraphQLCost() {
            return this.cost;
        }

        public Integer getGraphQLMaximumAdditionalTransfers() {
            return this.maximumAdditionalTransfers;
        }

        public Integer getGraphQLMaximumTransfers() {
            return this.maximumTransfers;
        }

        public Duration getGraphQLSlack() {
            return this.slack;
        }

        public void setGraphQLCost(Cost cost) {
            this.cost = cost;
        }

        public void setGraphQLMaximumAdditionalTransfers(Integer maximumAdditionalTransfers) {
            this.maximumAdditionalTransfers = maximumAdditionalTransfers;
        }

        public void setGraphQLMaximumTransfers(Integer maximumTransfers) {
            this.maximumTransfers = maximumTransfers;
        }

        public void setGraphQLSlack(Duration slack) {
            this.slack = slack;
        }
    }

    public static class GraphQLTimetablePreferencesInput {
        private Boolean excludeRealTimeUpdates;
        private Boolean includePlannedCancellations;
        private Boolean includeRealTimeCancellations;

        public GraphQLTimetablePreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.excludeRealTimeUpdates = (Boolean)args.get("excludeRealTimeUpdates");
                this.includePlannedCancellations = (Boolean)args.get("includePlannedCancellations");
                this.includeRealTimeCancellations = (Boolean)args.get("includeRealTimeCancellations");
            }
        }

        public Boolean getGraphQLExcludeRealTimeUpdates() {
            return this.excludeRealTimeUpdates;
        }

        public Boolean getGraphQLIncludePlannedCancellations() {
            return this.includePlannedCancellations;
        }

        public Boolean getGraphQLIncludeRealTimeCancellations() {
            return this.includeRealTimeCancellations;
        }

        public void setGraphQLExcludeRealTimeUpdates(Boolean excludeRealTimeUpdates) {
            this.excludeRealTimeUpdates = excludeRealTimeUpdates;
        }

        public void setGraphQLIncludePlannedCancellations(Boolean includePlannedCancellations) {
            this.includePlannedCancellations = includePlannedCancellations;
        }

        public void setGraphQLIncludeRealTimeCancellations(Boolean includeRealTimeCancellations) {
            this.includeRealTimeCancellations = includeRealTimeCancellations;
        }
    }

    public static class GraphQLStoptimeHeadsignArgs {
        private String language;

        public GraphQLStoptimeHeadsignArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static enum GraphQLStopType {
        LOCATION,
        LOCATION_GROUP,
        STOP;

    }

    public static enum GraphQLStopAlertType {
        AGENCIES_OF_ROUTES,
        PATTERNS,
        ROUTES,
        STOP,
        STOP_ON_ROUTES,
        STOP_ON_TRIPS,
        TRIPS;

    }

    public static class GraphQLStopUrlArgs {
        private String language;

        public GraphQLStopUrlArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLStopTransfersArgs {
        private Integer maxDistance;

        public GraphQLStopTransfersArgs(Map<String, Object> args) {
            if (args != null) {
                this.maxDistance = (Integer)args.get("maxDistance");
            }
        }

        public Integer getGraphQLMaxDistance() {
            return this.maxDistance;
        }

        public void setGraphQLMaxDistance(Integer maxDistance) {
            this.maxDistance = maxDistance;
        }
    }

    public static class GraphQLStopStoptimesWithoutPatternsArgs {
        private Integer numberOfDepartures;
        private Boolean omitCanceled;
        private Boolean omitNonPickups;
        private Long startTime;
        private Integer timeRange;

        public GraphQLStopStoptimesWithoutPatternsArgs(Map<String, Object> args) {
            if (args != null) {
                this.numberOfDepartures = (Integer)args.get("numberOfDepartures");
                this.omitCanceled = (Boolean)args.get("omitCanceled");
                this.omitNonPickups = (Boolean)args.get("omitNonPickups");
                this.startTime = (Long)args.get("startTime");
                this.timeRange = (Integer)args.get("timeRange");
            }
        }

        public Integer getGraphQLNumberOfDepartures() {
            return this.numberOfDepartures;
        }

        public Boolean getGraphQLOmitCanceled() {
            return this.omitCanceled;
        }

        public Boolean getGraphQLOmitNonPickups() {
            return this.omitNonPickups;
        }

        public Long getGraphQLStartTime() {
            return this.startTime;
        }

        public Integer getGraphQLTimeRange() {
            return this.timeRange;
        }

        public void setGraphQLNumberOfDepartures(Integer numberOfDepartures) {
            this.numberOfDepartures = numberOfDepartures;
        }

        public void setGraphQLOmitCanceled(Boolean omitCanceled) {
            this.omitCanceled = omitCanceled;
        }

        public void setGraphQLOmitNonPickups(Boolean omitNonPickups) {
            this.omitNonPickups = omitNonPickups;
        }

        public void setGraphQLStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public void setGraphQLTimeRange(Integer timeRange) {
            this.timeRange = timeRange;
        }
    }

    public static class GraphQLStopStoptimesForServiceDateArgs {
        private String date;
        private Boolean omitCanceled;
        private Boolean omitNonPickups;

        public GraphQLStopStoptimesForServiceDateArgs(Map<String, Object> args) {
            if (args != null) {
                this.date = (String)args.get("date");
                this.omitCanceled = (Boolean)args.get("omitCanceled");
                this.omitNonPickups = (Boolean)args.get("omitNonPickups");
            }
        }

        public String getGraphQLDate() {
            return this.date;
        }

        public Boolean getGraphQLOmitCanceled() {
            return this.omitCanceled;
        }

        public Boolean getGraphQLOmitNonPickups() {
            return this.omitNonPickups;
        }

        public void setGraphQLDate(String date) {
            this.date = date;
        }

        public void setGraphQLOmitCanceled(Boolean omitCanceled) {
            this.omitCanceled = omitCanceled;
        }

        public void setGraphQLOmitNonPickups(Boolean omitNonPickups) {
            this.omitNonPickups = omitNonPickups;
        }
    }

    public static class GraphQLStopStoptimesForPatternsArgs {
        private Integer numberOfDepartures;
        private Boolean omitCanceled;
        private Boolean omitNonPickups;
        private Long startTime;
        private Integer timeRange;

        public GraphQLStopStoptimesForPatternsArgs(Map<String, Object> args) {
            if (args != null) {
                this.numberOfDepartures = (Integer)args.get("numberOfDepartures");
                this.omitCanceled = (Boolean)args.get("omitCanceled");
                this.omitNonPickups = (Boolean)args.get("omitNonPickups");
                this.startTime = (Long)args.get("startTime");
                this.timeRange = (Integer)args.get("timeRange");
            }
        }

        public Integer getGraphQLNumberOfDepartures() {
            return this.numberOfDepartures;
        }

        public Boolean getGraphQLOmitCanceled() {
            return this.omitCanceled;
        }

        public Boolean getGraphQLOmitNonPickups() {
            return this.omitNonPickups;
        }

        public Long getGraphQLStartTime() {
            return this.startTime;
        }

        public Integer getGraphQLTimeRange() {
            return this.timeRange;
        }

        public void setGraphQLNumberOfDepartures(Integer numberOfDepartures) {
            this.numberOfDepartures = numberOfDepartures;
        }

        public void setGraphQLOmitCanceled(Boolean omitCanceled) {
            this.omitCanceled = omitCanceled;
        }

        public void setGraphQLOmitNonPickups(Boolean omitNonPickups) {
            this.omitNonPickups = omitNonPickups;
        }

        public void setGraphQLStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public void setGraphQLTimeRange(Integer timeRange) {
            this.timeRange = timeRange;
        }
    }

    public static class GraphQLStopStopTimesForPatternArgs {
        private String id;
        private Integer numberOfDepartures;
        private Boolean omitCanceled;
        private Boolean omitNonPickups;
        private Long startTime;
        private Integer timeRange;

        public GraphQLStopStopTimesForPatternArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
                this.numberOfDepartures = (Integer)args.get("numberOfDepartures");
                this.omitCanceled = (Boolean)args.get("omitCanceled");
                this.omitNonPickups = (Boolean)args.get("omitNonPickups");
                this.startTime = (Long)args.get("startTime");
                this.timeRange = (Integer)args.get("timeRange");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public Integer getGraphQLNumberOfDepartures() {
            return this.numberOfDepartures;
        }

        public Boolean getGraphQLOmitCanceled() {
            return this.omitCanceled;
        }

        public Boolean getGraphQLOmitNonPickups() {
            return this.omitNonPickups;
        }

        public Long getGraphQLStartTime() {
            return this.startTime;
        }

        public Integer getGraphQLTimeRange() {
            return this.timeRange;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }

        public void setGraphQLNumberOfDepartures(Integer numberOfDepartures) {
            this.numberOfDepartures = numberOfDepartures;
        }

        public void setGraphQLOmitCanceled(Boolean omitCanceled) {
            this.omitCanceled = omitCanceled;
        }

        public void setGraphQLOmitNonPickups(Boolean omitNonPickups) {
            this.omitNonPickups = omitNonPickups;
        }

        public void setGraphQLStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public void setGraphQLTimeRange(Integer timeRange) {
            this.timeRange = timeRange;
        }
    }

    public static class GraphQLStopRoutesArgs {
        private GraphQLLocalDateRangeInput serviceDates;

        public GraphQLStopRoutesArgs(Map<String, Object> args) {
            if (args != null) {
                this.serviceDates = new GraphQLLocalDateRangeInput((Map)args.get("serviceDates"));
            }
        }

        public GraphQLLocalDateRangeInput getGraphQLServiceDates() {
            return this.serviceDates;
        }

        public void setGraphQLServiceDates(GraphQLLocalDateRangeInput serviceDates) {
            this.serviceDates = serviceDates;
        }
    }

    public static class GraphQLStopNameArgs {
        private String language;

        public GraphQLStopNameArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLStopDescArgs {
        private String language;

        public GraphQLStopDescArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLStopAlertsArgs {
        private List<GraphQLStopAlertType> types;

        public GraphQLStopAlertsArgs(Map<String, Object> args) {
            if (args != null && args.get("types") != null) {
                this.types = ((List)args.get("types")).stream().map(item -> item instanceof GraphQLStopAlertType ? item : GraphQLStopAlertType.valueOf((String)item)).map(GraphQLStopAlertType.class::cast).collect(Collectors.toList());
            }
        }

        public List<GraphQLStopAlertType> getGraphQLTypes() {
            return this.types;
        }

        public void setGraphQLTypes(List<GraphQLStopAlertType> types) {
            this.types = types;
        }
    }

    public static class GraphQLScooterRentalPreferencesInput {
        private List<String> allowedNetworks;
        private List<String> bannedNetworks;
        private GraphQLDestinationScooterPolicyInput destinationScooterPolicy;

        public GraphQLScooterRentalPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.allowedNetworks = (List)args.get("allowedNetworks");
                this.bannedNetworks = (List)args.get("bannedNetworks");
                this.destinationScooterPolicy = new GraphQLDestinationScooterPolicyInput((Map)args.get("destinationScooterPolicy"));
            }
        }

        public List<String> getGraphQLAllowedNetworks() {
            return this.allowedNetworks;
        }

        public List<String> getGraphQLBannedNetworks() {
            return this.bannedNetworks;
        }

        public GraphQLDestinationScooterPolicyInput getGraphQLDestinationScooterPolicy() {
            return this.destinationScooterPolicy;
        }

        public void setGraphQLAllowedNetworks(List<String> allowedNetworks) {
            this.allowedNetworks = allowedNetworks;
        }

        public void setGraphQLBannedNetworks(List<String> bannedNetworks) {
            this.bannedNetworks = bannedNetworks;
        }

        public void setGraphQLDestinationScooterPolicy(GraphQLDestinationScooterPolicyInput destinationScooterPolicy) {
            this.destinationScooterPolicy = destinationScooterPolicy;
        }
    }

    public static class GraphQLScooterPreferencesInput {
        private GraphQLScooterOptimizationInput optimization;
        private Double reluctance;
        private GraphQLScooterRentalPreferencesInput rental;
        private Double speed;

        public GraphQLScooterPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.optimization = new GraphQLScooterOptimizationInput((Map)args.get("optimization"));
                this.reluctance = (Double)args.get("reluctance");
                this.rental = new GraphQLScooterRentalPreferencesInput((Map)args.get("rental"));
                this.speed = (Double)args.get("speed");
            }
        }

        public GraphQLScooterOptimizationInput getGraphQLOptimization() {
            return this.optimization;
        }

        public Double getGraphQLReluctance() {
            return this.reluctance;
        }

        public GraphQLScooterRentalPreferencesInput getGraphQLRental() {
            return this.rental;
        }

        public Double getGraphQLSpeed() {
            return this.speed;
        }

        public void setGraphQLOptimization(GraphQLScooterOptimizationInput optimization) {
            this.optimization = optimization;
        }

        public void setGraphQLReluctance(Double reluctance) {
            this.reluctance = reluctance;
        }

        public void setGraphQLRental(GraphQLScooterRentalPreferencesInput rental) {
            this.rental = rental;
        }

        public void setGraphQLSpeed(Double speed) {
            this.speed = speed;
        }
    }

    public static enum GraphQLScooterOptimizationType {
        FLAT_STREETS,
        SAFEST_STREETS,
        SAFE_STREETS,
        SHORTEST_DURATION;

    }

    public static class GraphQLScooterOptimizationInput {
        private GraphQLTriangleScooterFactorsInput triangle;
        private GraphQLScooterOptimizationType type;

        public GraphQLScooterOptimizationInput(Map<String, Object> args) {
            if (args != null) {
                this.triangle = new GraphQLTriangleScooterFactorsInput((Map)args.get("triangle"));
                if (args.get("type") instanceof GraphQLScooterOptimizationType) {
                    this.type = (GraphQLScooterOptimizationType)((Object)args.get("type"));
                } else if (args.get("type") != null) {
                    this.type = GraphQLScooterOptimizationType.valueOf((String)args.get("type"));
                }
            }
        }

        public GraphQLTriangleScooterFactorsInput getGraphQLTriangle() {
            return this.triangle;
        }

        public GraphQLScooterOptimizationType getGraphQLType() {
            return this.type;
        }

        public void setGraphQLTriangle(GraphQLTriangleScooterFactorsInput triangle) {
            this.triangle = triangle;
        }

        public void setGraphQLType(GraphQLScooterOptimizationType type) {
            this.type = type;
        }
    }

    public static enum GraphQLRoutingErrorCode {
        LOCATION_NOT_FOUND,
        NO_STOPS_IN_RANGE,
        NO_TRANSIT_CONNECTION,
        NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW,
        OUTSIDE_BOUNDS,
        OUTSIDE_SERVICE_PERIOD,
        WALKING_BETTER_THAN_TRANSIT;

    }

    public static enum GraphQLRouteAlertType {
        AGENCY,
        PATTERNS,
        ROUTE,
        ROUTE_TYPE,
        STOPS_ON_ROUTE,
        STOPS_ON_TRIPS,
        TRIPS;

    }

    public static class GraphQLRoutePatternsArgs {
        private GraphQLLocalDateRangeInput serviceDates;

        public GraphQLRoutePatternsArgs(Map<String, Object> args) {
            if (args != null) {
                this.serviceDates = new GraphQLLocalDateRangeInput((Map)args.get("serviceDates"));
            }
        }

        public GraphQLLocalDateRangeInput getGraphQLServiceDates() {
            return this.serviceDates;
        }

        public void setGraphQLServiceDates(GraphQLLocalDateRangeInput serviceDates) {
            this.serviceDates = serviceDates;
        }
    }

    public static class GraphQLRouteLongNameArgs {
        private String language;

        public GraphQLRouteLongNameArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLRouteAlertsArgs {
        private List<GraphQLRouteAlertType> types;

        public GraphQLRouteAlertsArgs(Map<String, Object> args) {
            if (args != null && args.get("types") != null) {
                this.types = ((List)args.get("types")).stream().map(item -> item instanceof GraphQLRouteAlertType ? item : GraphQLRouteAlertType.valueOf((String)item)).map(GraphQLRouteAlertType.class::cast).collect(Collectors.toList());
            }
        }

        public List<GraphQLRouteAlertType> getGraphQLTypes() {
            return this.types;
        }

        public void setGraphQLTypes(List<GraphQLRouteAlertType> types) {
            this.types = types;
        }
    }

    public static enum GraphQLRelativeDirection {
        CIRCLE_CLOCKWISE,
        CIRCLE_COUNTERCLOCKWISE,
        CONTINUE,
        DEPART,
        ELEVATOR,
        ENTER_STATION,
        EXIT_STATION,
        FOLLOW_SIGNS,
        HARD_LEFT,
        HARD_RIGHT,
        LEFT,
        RIGHT,
        SLIGHTLY_LEFT,
        SLIGHTLY_RIGHT,
        UTURN_LEFT,
        UTURN_RIGHT;

    }

    public static enum GraphQLRealtimeState {
        ADDED,
        CANCELED,
        MODIFIED,
        SCHEDULED,
        UPDATED;

    }

    public static class GraphQLQueryTypeVehicleRentalsByBboxArgs {
        private Double maximumLatitude;
        private Double maximumLongitude;
        private Double minimumLatitude;
        private Double minimumLongitude;

        public GraphQLQueryTypeVehicleRentalsByBboxArgs(Map<String, Object> args) {
            if (args != null) {
                this.maximumLatitude = (Double)args.get("maximumLatitude");
                this.maximumLongitude = (Double)args.get("maximumLongitude");
                this.minimumLatitude = (Double)args.get("minimumLatitude");
                this.minimumLongitude = (Double)args.get("minimumLongitude");
            }
        }

        public Double getGraphQLMaximumLatitude() {
            return this.maximumLatitude;
        }

        public Double getGraphQLMaximumLongitude() {
            return this.maximumLongitude;
        }

        public Double getGraphQLMinimumLatitude() {
            return this.minimumLatitude;
        }

        public Double getGraphQLMinimumLongitude() {
            return this.minimumLongitude;
        }

        public void setGraphQLMaximumLatitude(Double maximumLatitude) {
            this.maximumLatitude = maximumLatitude;
        }

        public void setGraphQLMaximumLongitude(Double maximumLongitude) {
            this.maximumLongitude = maximumLongitude;
        }

        public void setGraphQLMinimumLatitude(Double minimumLatitude) {
            this.minimumLatitude = minimumLatitude;
        }

        public void setGraphQLMinimumLongitude(Double minimumLongitude) {
            this.minimumLongitude = minimumLongitude;
        }
    }

    public static class GraphQLQueryTypeVehicleRentalStationsArgs {
        private List<String> ids;

        public GraphQLQueryTypeVehicleRentalStationsArgs(Map<String, Object> args) {
            if (args != null) {
                this.ids = (List)args.get("ids");
            }
        }

        public List<String> getGraphQLIds() {
            return this.ids;
        }

        public void setGraphQLIds(List<String> ids) {
            this.ids = ids;
        }
    }

    public static class GraphQLQueryTypeVehicleRentalStationArgs {
        private String id;

        public GraphQLQueryTypeVehicleRentalStationArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeVehicleParkingsArgs {
        private List<String> ids;

        public GraphQLQueryTypeVehicleParkingsArgs(Map<String, Object> args) {
            if (args != null) {
                this.ids = (List)args.get("ids");
            }
        }

        public List<String> getGraphQLIds() {
            return this.ids;
        }

        public void setGraphQLIds(List<String> ids) {
            this.ids = ids;
        }
    }

    public static class GraphQLQueryTypeVehicleParkingArgs {
        private String id;

        public GraphQLQueryTypeVehicleParkingArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeTripsArgs {
        private List<String> feeds;

        public GraphQLQueryTypeTripsArgs(Map<String, Object> args) {
            if (args != null) {
                this.feeds = (List)args.get("feeds");
            }
        }

        public List<String> getGraphQLFeeds() {
            return this.feeds;
        }

        public void setGraphQLFeeds(List<String> feeds) {
            this.feeds = feeds;
        }
    }

    public static class GraphQLQueryTypeTripArgs {
        private String id;

        public GraphQLQueryTypeTripArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeStopsByRadiusArgs {
        private String after;
        private String before;
        private List<String> feeds;
        private Integer first;
        private Integer last;
        private Double lat;
        private Double lon;
        private Integer radius;

        public GraphQLQueryTypeStopsByRadiusArgs(Map<String, Object> args) {
            if (args != null) {
                this.after = (String)args.get("after");
                this.before = (String)args.get("before");
                this.feeds = (List)args.get("feeds");
                this.first = (Integer)args.get("first");
                this.last = (Integer)args.get("last");
                this.lat = (Double)args.get("lat");
                this.lon = (Double)args.get("lon");
                this.radius = (Integer)args.get("radius");
            }
        }

        public String getGraphQLAfter() {
            return this.after;
        }

        public String getGraphQLBefore() {
            return this.before;
        }

        public List<String> getGraphQLFeeds() {
            return this.feeds;
        }

        public Integer getGraphQLFirst() {
            return this.first;
        }

        public Integer getGraphQLLast() {
            return this.last;
        }

        public Double getGraphQLLat() {
            return this.lat;
        }

        public Double getGraphQLLon() {
            return this.lon;
        }

        public Integer getGraphQLRadius() {
            return this.radius;
        }

        public void setGraphQLAfter(String after) {
            this.after = after;
        }

        public void setGraphQLBefore(String before) {
            this.before = before;
        }

        public void setGraphQLFeeds(List<String> feeds) {
            this.feeds = feeds;
        }

        public void setGraphQLFirst(Integer first) {
            this.first = first;
        }

        public void setGraphQLLast(Integer last) {
            this.last = last;
        }

        public void setGraphQLLat(Double lat) {
            this.lat = lat;
        }

        public void setGraphQLLon(Double lon) {
            this.lon = lon;
        }

        public void setGraphQLRadius(Integer radius) {
            this.radius = radius;
        }
    }

    public static class GraphQLQueryTypeStopsByBboxArgs {
        private List<String> feeds;
        private Double maxLat;
        private Double maxLon;
        private Double minLat;
        private Double minLon;

        public GraphQLQueryTypeStopsByBboxArgs(Map<String, Object> args) {
            if (args != null) {
                this.feeds = (List)args.get("feeds");
                this.maxLat = (Double)args.get("maxLat");
                this.maxLon = (Double)args.get("maxLon");
                this.minLat = (Double)args.get("minLat");
                this.minLon = (Double)args.get("minLon");
            }
        }

        public List<String> getGraphQLFeeds() {
            return this.feeds;
        }

        public Double getGraphQLMaxLat() {
            return this.maxLat;
        }

        public Double getGraphQLMaxLon() {
            return this.maxLon;
        }

        public Double getGraphQLMinLat() {
            return this.minLat;
        }

        public Double getGraphQLMinLon() {
            return this.minLon;
        }

        public void setGraphQLFeeds(List<String> feeds) {
            this.feeds = feeds;
        }

        public void setGraphQLMaxLat(Double maxLat) {
            this.maxLat = maxLat;
        }

        public void setGraphQLMaxLon(Double maxLon) {
            this.maxLon = maxLon;
        }

        public void setGraphQLMinLat(Double minLat) {
            this.minLat = minLat;
        }

        public void setGraphQLMinLon(Double minLon) {
            this.minLon = minLon;
        }
    }

    public static class GraphQLQueryTypeStopsArgs {
        private List<String> ids;
        private String name;

        public GraphQLQueryTypeStopsArgs(Map<String, Object> args) {
            if (args != null) {
                this.ids = (List)args.get("ids");
                this.name = (String)args.get("name");
            }
        }

        public List<String> getGraphQLIds() {
            return this.ids;
        }

        public String getGraphQLName() {
            return this.name;
        }

        public void setGraphQLIds(List<String> ids) {
            this.ids = ids;
        }

        public void setGraphQLName(String name) {
            this.name = name;
        }
    }

    public static class GraphQLQueryTypeStopArgs {
        private String id;

        public GraphQLQueryTypeStopArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeStationsArgs {
        private List<String> ids;
        private String name;

        public GraphQLQueryTypeStationsArgs(Map<String, Object> args) {
            if (args != null) {
                this.ids = (List)args.get("ids");
                this.name = (String)args.get("name");
            }
        }

        public List<String> getGraphQLIds() {
            return this.ids;
        }

        public String getGraphQLName() {
            return this.name;
        }

        public void setGraphQLIds(List<String> ids) {
            this.ids = ids;
        }

        public void setGraphQLName(String name) {
            this.name = name;
        }
    }

    public static class GraphQLQueryTypeStationArgs {
        private String id;

        public GraphQLQueryTypeStationArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeRoutesArgs {
        private List<String> feeds;
        private List<String> ids;
        private String name;
        private GraphQLLocalDateRangeInput serviceDates;
        private List<GraphQLMode> transportModes;

        public GraphQLQueryTypeRoutesArgs(Map<String, Object> args) {
            if (args != null) {
                this.feeds = (List)args.get("feeds");
                this.ids = (List)args.get("ids");
                this.name = (String)args.get("name");
                this.serviceDates = new GraphQLLocalDateRangeInput((Map)args.get("serviceDates"));
                if (args.get("transportModes") != null) {
                    this.transportModes = ((List)args.get("transportModes")).stream().map(item -> item instanceof GraphQLMode ? item : GraphQLMode.valueOf((String)item)).map(GraphQLMode.class::cast).collect(Collectors.toList());
                }
            }
        }

        public List<String> getGraphQLFeeds() {
            return this.feeds;
        }

        public List<String> getGraphQLIds() {
            return this.ids;
        }

        public String getGraphQLName() {
            return this.name;
        }

        public GraphQLLocalDateRangeInput getGraphQLServiceDates() {
            return this.serviceDates;
        }

        public List<GraphQLMode> getGraphQLTransportModes() {
            return this.transportModes;
        }

        public void setGraphQLFeeds(List<String> feeds) {
            this.feeds = feeds;
        }

        public void setGraphQLIds(List<String> ids) {
            this.ids = ids;
        }

        public void setGraphQLName(String name) {
            this.name = name;
        }

        public void setGraphQLServiceDates(GraphQLLocalDateRangeInput serviceDates) {
            this.serviceDates = serviceDates;
        }

        public void setGraphQLTransportModes(List<GraphQLMode> transportModes) {
            this.transportModes = transportModes;
        }
    }

    public static class GraphQLQueryTypeRouteArgs {
        private String id;

        public GraphQLQueryTypeRouteArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeRentalVehiclesArgs {
        private List<GraphQLFormFactor> formFactors;
        private List<String> ids;

        public GraphQLQueryTypeRentalVehiclesArgs(Map<String, Object> args) {
            if (args != null) {
                if (args.get("formFactors") != null) {
                    this.formFactors = ((List)args.get("formFactors")).stream().map(item -> item instanceof GraphQLFormFactor ? item : GraphQLFormFactor.valueOf((String)item)).map(GraphQLFormFactor.class::cast).collect(Collectors.toList());
                }
                this.ids = (List)args.get("ids");
            }
        }

        public List<GraphQLFormFactor> getGraphQLFormFactors() {
            return this.formFactors;
        }

        public List<String> getGraphQLIds() {
            return this.ids;
        }

        public void setGraphQLFormFactors(List<GraphQLFormFactor> formFactors) {
            this.formFactors = formFactors;
        }

        public void setGraphQLIds(List<String> ids) {
            this.ids = ids;
        }
    }

    public static class GraphQLQueryTypeRentalVehicleArgs {
        private String id;

        public GraphQLQueryTypeRentalVehicleArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypePlanConnectionArgs {
        private String after;
        private String before;
        private GraphQLPlanDateTimeInput dateTime;
        private GraphQLPlanLabeledLocationInput destination;
        private Integer first;
        private GraphQLPlanItineraryFilterInput itineraryFilter;
        private Integer last;
        private Locale locale;
        private GraphQLPlanModesInput modes;
        private GraphQLPlanLabeledLocationInput origin;
        private GraphQLPlanPreferencesInput preferences;
        private Duration searchWindow;
        private List<GraphQLPlanViaLocationInput> via;

        public GraphQLQueryTypePlanConnectionArgs(Map<String, Object> args) {
            if (args != null) {
                this.after = (String)args.get("after");
                this.before = (String)args.get("before");
                this.dateTime = new GraphQLPlanDateTimeInput((Map)args.get("dateTime"));
                this.destination = new GraphQLPlanLabeledLocationInput((Map)args.get("destination"));
                this.first = (Integer)args.get("first");
                this.itineraryFilter = new GraphQLPlanItineraryFilterInput((Map)args.get("itineraryFilter"));
                this.last = (Integer)args.get("last");
                this.locale = (Locale)args.get("locale");
                this.modes = new GraphQLPlanModesInput((Map)args.get("modes"));
                this.origin = new GraphQLPlanLabeledLocationInput((Map)args.get("origin"));
                this.preferences = new GraphQLPlanPreferencesInput((Map)args.get("preferences"));
                this.searchWindow = (Duration)args.get("searchWindow");
                if (args.get("via") != null) {
                    this.via = ((List)args.get("via")).stream().map(o -> o == null ? null : new GraphQLPlanViaLocationInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
            }
        }

        public String getGraphQLAfter() {
            return this.after;
        }

        public String getGraphQLBefore() {
            return this.before;
        }

        public GraphQLPlanDateTimeInput getGraphQLDateTime() {
            return this.dateTime;
        }

        public GraphQLPlanLabeledLocationInput getGraphQLDestination() {
            return this.destination;
        }

        public Integer getGraphQLFirst() {
            return this.first;
        }

        public GraphQLPlanItineraryFilterInput getGraphQLItineraryFilter() {
            return this.itineraryFilter;
        }

        public Integer getGraphQLLast() {
            return this.last;
        }

        public Locale getGraphQLLocale() {
            return this.locale;
        }

        public GraphQLPlanModesInput getGraphQLModes() {
            return this.modes;
        }

        public GraphQLPlanLabeledLocationInput getGraphQLOrigin() {
            return this.origin;
        }

        public GraphQLPlanPreferencesInput getGraphQLPreferences() {
            return this.preferences;
        }

        public Duration getGraphQLSearchWindow() {
            return this.searchWindow;
        }

        public List<GraphQLPlanViaLocationInput> getGraphQLVia() {
            return this.via;
        }

        public void setGraphQLAfter(String after) {
            this.after = after;
        }

        public void setGraphQLBefore(String before) {
            this.before = before;
        }

        public void setGraphQLDateTime(GraphQLPlanDateTimeInput dateTime) {
            this.dateTime = dateTime;
        }

        public void setGraphQLDestination(GraphQLPlanLabeledLocationInput destination) {
            this.destination = destination;
        }

        public void setGraphQLFirst(Integer first) {
            this.first = first;
        }

        public void setGraphQLItineraryFilter(GraphQLPlanItineraryFilterInput itineraryFilter) {
            this.itineraryFilter = itineraryFilter;
        }

        public void setGraphQLLast(Integer last) {
            this.last = last;
        }

        public void setGraphQLLocale(Locale locale) {
            this.locale = locale;
        }

        public void setGraphQLModes(GraphQLPlanModesInput modes) {
            this.modes = modes;
        }

        public void setGraphQLOrigin(GraphQLPlanLabeledLocationInput origin) {
            this.origin = origin;
        }

        public void setGraphQLPreferences(GraphQLPlanPreferencesInput preferences) {
            this.preferences = preferences;
        }

        public void setGraphQLSearchWindow(Duration searchWindow) {
            this.searchWindow = searchWindow;
        }

        public void setGraphQLVia(List<GraphQLPlanViaLocationInput> via) {
            this.via = via;
        }
    }

    public static class GraphQLQueryTypePlanArgs {
        private Integer alightSlack;
        private Boolean allowBikeRental;
        private Boolean allowKeepingRentedBicycleAtDestination;
        private List<String> allowedBikeRentalNetworks;
        private List<String> allowedTicketTypes;
        private List<String> allowedVehicleRentalNetworks;
        private Boolean arriveBy;
        private GraphQLInputBannedInput banned;
        private List<String> bannedVehicleRentalNetworks;
        private Boolean batch;
        private Integer bikeBoardCost;
        private Double bikeReluctance;
        private Double bikeSpeed;
        private Integer bikeSwitchCost;
        private Integer bikeSwitchTime;
        private Double bikeWalkingReluctance;
        private Integer boardSlack;
        private Double carParkCarLegWeight;
        private Double carReluctance;
        private Long claimInitialWait;
        private Boolean compactLegsByReversedSearch;
        private String date;
        private Boolean debugItineraryFilter;
        private Boolean disableRemainingWeightHeuristic;
        private GraphQLInputCoordinatesInput from;
        private String fromPlace;
        private Integer heuristicStepsPerMainStep;
        private Boolean ignoreRealtimeUpdates;
        private List<GraphQLInputCoordinatesInput> intermediatePlaces;
        private Double itineraryFiltering;
        private Integer keepingRentedBicycleAtDestinationCost;
        private String locale;
        private Integer maxPreTransitTime;
        private Integer maxTransfers;
        private Double maxWalkDistance;
        private Integer minTransferTime;
        private GraphQLInputModeWeightInput modeWeight;
        private Integer nonpreferredTransferPenalty;
        private Integer numItineraries;
        private Boolean omitCanceled;
        private GraphQLOptimizeType optimize;
        private String pageCursor;
        private GraphQLVehicleParkingInput parking;
        private GraphQLInputPreferredInput preferred;
        private Boolean reverseOptimizeOnTheFly;
        private Long searchWindow;
        private String startTransitStopId;
        private String startTransitTripId;
        private String time;
        private GraphQLInputCoordinatesInput to;
        private String toPlace;
        private Integer transferPenalty;
        private List<GraphQLTransportModeInput> transportModes;
        private GraphQLInputTriangleInput triangle;
        private GraphQLInputUnpreferredInput unpreferred;
        private List<GraphQLPlanViaLocationInput> via;
        private Double waitAtBeginningFactor;
        private Double waitReluctance;
        private Integer walkBoardCost;
        private Double walkOnStreetReluctance;
        private Double walkReluctance;
        private Double walkSafetyFactor;
        private Double walkSpeed;
        private Boolean wheelchair;

        public GraphQLQueryTypePlanArgs(Map<String, Object> args) {
            if (args != null) {
                this.alightSlack = (Integer)args.get("alightSlack");
                this.allowBikeRental = (Boolean)args.get("allowBikeRental");
                this.allowKeepingRentedBicycleAtDestination = (Boolean)args.get("allowKeepingRentedBicycleAtDestination");
                this.allowedBikeRentalNetworks = (List)args.get("allowedBikeRentalNetworks");
                this.allowedTicketTypes = (List)args.get("allowedTicketTypes");
                this.allowedVehicleRentalNetworks = (List)args.get("allowedVehicleRentalNetworks");
                this.arriveBy = (Boolean)args.get("arriveBy");
                this.banned = new GraphQLInputBannedInput((Map)args.get("banned"));
                this.bannedVehicleRentalNetworks = (List)args.get("bannedVehicleRentalNetworks");
                this.batch = (Boolean)args.get("batch");
                this.bikeBoardCost = (Integer)args.get("bikeBoardCost");
                this.bikeReluctance = (Double)args.get("bikeReluctance");
                this.bikeSpeed = (Double)args.get("bikeSpeed");
                this.bikeSwitchCost = (Integer)args.get("bikeSwitchCost");
                this.bikeSwitchTime = (Integer)args.get("bikeSwitchTime");
                this.bikeWalkingReluctance = (Double)args.get("bikeWalkingReluctance");
                this.boardSlack = (Integer)args.get("boardSlack");
                this.carParkCarLegWeight = (Double)args.get("carParkCarLegWeight");
                this.carReluctance = (Double)args.get("carReluctance");
                this.claimInitialWait = (Long)args.get("claimInitialWait");
                this.compactLegsByReversedSearch = (Boolean)args.get("compactLegsByReversedSearch");
                this.date = (String)args.get("date");
                this.debugItineraryFilter = (Boolean)args.get("debugItineraryFilter");
                this.disableRemainingWeightHeuristic = (Boolean)args.get("disableRemainingWeightHeuristic");
                this.from = new GraphQLInputCoordinatesInput((Map)args.get("from"));
                this.fromPlace = (String)args.get("fromPlace");
                this.heuristicStepsPerMainStep = (Integer)args.get("heuristicStepsPerMainStep");
                this.ignoreRealtimeUpdates = (Boolean)args.get("ignoreRealtimeUpdates");
                if (args.get("intermediatePlaces") != null) {
                    this.intermediatePlaces = ((List)args.get("intermediatePlaces")).stream().map(o -> o == null ? null : new GraphQLInputCoordinatesInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                this.itineraryFiltering = (Double)args.get("itineraryFiltering");
                this.keepingRentedBicycleAtDestinationCost = (Integer)args.get("keepingRentedBicycleAtDestinationCost");
                this.locale = (String)args.get("locale");
                this.maxPreTransitTime = (Integer)args.get("maxPreTransitTime");
                this.maxTransfers = (Integer)args.get("maxTransfers");
                this.maxWalkDistance = (Double)args.get("maxWalkDistance");
                this.minTransferTime = (Integer)args.get("minTransferTime");
                this.modeWeight = new GraphQLInputModeWeightInput((Map)args.get("modeWeight"));
                this.nonpreferredTransferPenalty = (Integer)args.get("nonpreferredTransferPenalty");
                this.numItineraries = (Integer)args.get("numItineraries");
                this.omitCanceled = (Boolean)args.get("omitCanceled");
                if (args.get("optimize") instanceof GraphQLOptimizeType) {
                    this.optimize = (GraphQLOptimizeType)((Object)args.get("optimize"));
                } else if (args.get("optimize") != null) {
                    this.optimize = GraphQLOptimizeType.valueOf((String)args.get("optimize"));
                }
                this.pageCursor = (String)args.get("pageCursor");
                this.parking = new GraphQLVehicleParkingInput((Map)args.get("parking"));
                this.preferred = new GraphQLInputPreferredInput((Map)args.get("preferred"));
                this.reverseOptimizeOnTheFly = (Boolean)args.get("reverseOptimizeOnTheFly");
                this.searchWindow = (Long)args.get("searchWindow");
                this.startTransitStopId = (String)args.get("startTransitStopId");
                this.startTransitTripId = (String)args.get("startTransitTripId");
                this.time = (String)args.get("time");
                this.to = new GraphQLInputCoordinatesInput((Map)args.get("to"));
                this.toPlace = (String)args.get("toPlace");
                this.transferPenalty = (Integer)args.get("transferPenalty");
                if (args.get("transportModes") != null) {
                    this.transportModes = ((List)args.get("transportModes")).stream().map(o -> o == null ? null : new GraphQLTransportModeInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                this.triangle = new GraphQLInputTriangleInput((Map)args.get("triangle"));
                this.unpreferred = new GraphQLInputUnpreferredInput((Map)args.get("unpreferred"));
                if (args.get("via") != null) {
                    this.via = ((List)args.get("via")).stream().map(o -> o == null ? null : new GraphQLPlanViaLocationInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                this.waitAtBeginningFactor = (Double)args.get("waitAtBeginningFactor");
                this.waitReluctance = (Double)args.get("waitReluctance");
                this.walkBoardCost = (Integer)args.get("walkBoardCost");
                this.walkOnStreetReluctance = (Double)args.get("walkOnStreetReluctance");
                this.walkReluctance = (Double)args.get("walkReluctance");
                this.walkSafetyFactor = (Double)args.get("walkSafetyFactor");
                this.walkSpeed = (Double)args.get("walkSpeed");
                this.wheelchair = (Boolean)args.get("wheelchair");
            }
        }

        public Integer getGraphQLAlightSlack() {
            return this.alightSlack;
        }

        public Boolean getGraphQLAllowBikeRental() {
            return this.allowBikeRental;
        }

        public Boolean getGraphQLAllowKeepingRentedBicycleAtDestination() {
            return this.allowKeepingRentedBicycleAtDestination;
        }

        public List<String> getGraphQLAllowedBikeRentalNetworks() {
            return this.allowedBikeRentalNetworks;
        }

        public List<String> getGraphQLAllowedTicketTypes() {
            return this.allowedTicketTypes;
        }

        public List<String> getGraphQLAllowedVehicleRentalNetworks() {
            return this.allowedVehicleRentalNetworks;
        }

        public Boolean getGraphQLArriveBy() {
            return this.arriveBy;
        }

        public GraphQLInputBannedInput getGraphQLBanned() {
            return this.banned;
        }

        public List<String> getGraphQLBannedVehicleRentalNetworks() {
            return this.bannedVehicleRentalNetworks;
        }

        public Boolean getGraphQLBatch() {
            return this.batch;
        }

        public Integer getGraphQLBikeBoardCost() {
            return this.bikeBoardCost;
        }

        public Double getGraphQLBikeReluctance() {
            return this.bikeReluctance;
        }

        public Double getGraphQLBikeSpeed() {
            return this.bikeSpeed;
        }

        public Integer getGraphQLBikeSwitchCost() {
            return this.bikeSwitchCost;
        }

        public Integer getGraphQLBikeSwitchTime() {
            return this.bikeSwitchTime;
        }

        public Double getGraphQLBikeWalkingReluctance() {
            return this.bikeWalkingReluctance;
        }

        public Integer getGraphQLBoardSlack() {
            return this.boardSlack;
        }

        public Double getGraphQLCarParkCarLegWeight() {
            return this.carParkCarLegWeight;
        }

        public Double getGraphQLCarReluctance() {
            return this.carReluctance;
        }

        public Long getGraphQLClaimInitialWait() {
            return this.claimInitialWait;
        }

        public Boolean getGraphQLCompactLegsByReversedSearch() {
            return this.compactLegsByReversedSearch;
        }

        public String getGraphQLDate() {
            return this.date;
        }

        public Boolean getGraphQLDebugItineraryFilter() {
            return this.debugItineraryFilter;
        }

        public Boolean getGraphQLDisableRemainingWeightHeuristic() {
            return this.disableRemainingWeightHeuristic;
        }

        public GraphQLInputCoordinatesInput getGraphQLFrom() {
            return this.from;
        }

        public String getGraphQLFromPlace() {
            return this.fromPlace;
        }

        public Integer getGraphQLHeuristicStepsPerMainStep() {
            return this.heuristicStepsPerMainStep;
        }

        public Boolean getGraphQLIgnoreRealtimeUpdates() {
            return this.ignoreRealtimeUpdates;
        }

        public List<GraphQLInputCoordinatesInput> getGraphQLIntermediatePlaces() {
            return this.intermediatePlaces;
        }

        public Double getGraphQLItineraryFiltering() {
            return this.itineraryFiltering;
        }

        public Integer getGraphQLKeepingRentedBicycleAtDestinationCost() {
            return this.keepingRentedBicycleAtDestinationCost;
        }

        public String getGraphQLLocale() {
            return this.locale;
        }

        public Integer getGraphQLMaxPreTransitTime() {
            return this.maxPreTransitTime;
        }

        public Integer getGraphQLMaxTransfers() {
            return this.maxTransfers;
        }

        public Double getGraphQLMaxWalkDistance() {
            return this.maxWalkDistance;
        }

        public Integer getGraphQLMinTransferTime() {
            return this.minTransferTime;
        }

        public GraphQLInputModeWeightInput getGraphQLModeWeight() {
            return this.modeWeight;
        }

        public Integer getGraphQLNonpreferredTransferPenalty() {
            return this.nonpreferredTransferPenalty;
        }

        public Integer getGraphQLNumItineraries() {
            return this.numItineraries;
        }

        public Boolean getGraphQLOmitCanceled() {
            return this.omitCanceled;
        }

        public GraphQLOptimizeType getGraphQLOptimize() {
            return this.optimize;
        }

        public String getGraphQLPageCursor() {
            return this.pageCursor;
        }

        public GraphQLVehicleParkingInput getGraphQLParking() {
            return this.parking;
        }

        public GraphQLInputPreferredInput getGraphQLPreferred() {
            return this.preferred;
        }

        public Boolean getGraphQLReverseOptimizeOnTheFly() {
            return this.reverseOptimizeOnTheFly;
        }

        public Long getGraphQLSearchWindow() {
            return this.searchWindow;
        }

        public String getGraphQLStartTransitStopId() {
            return this.startTransitStopId;
        }

        public String getGraphQLStartTransitTripId() {
            return this.startTransitTripId;
        }

        public String getGraphQLTime() {
            return this.time;
        }

        public GraphQLInputCoordinatesInput getGraphQLTo() {
            return this.to;
        }

        public String getGraphQLToPlace() {
            return this.toPlace;
        }

        public Integer getGraphQLTransferPenalty() {
            return this.transferPenalty;
        }

        public List<GraphQLTransportModeInput> getGraphQLTransportModes() {
            return this.transportModes;
        }

        public GraphQLInputTriangleInput getGraphQLTriangle() {
            return this.triangle;
        }

        public GraphQLInputUnpreferredInput getGraphQLUnpreferred() {
            return this.unpreferred;
        }

        public List<GraphQLPlanViaLocationInput> getGraphQLVia() {
            return this.via;
        }

        public Double getGraphQLWaitAtBeginningFactor() {
            return this.waitAtBeginningFactor;
        }

        public Double getGraphQLWaitReluctance() {
            return this.waitReluctance;
        }

        public Integer getGraphQLWalkBoardCost() {
            return this.walkBoardCost;
        }

        public Double getGraphQLWalkOnStreetReluctance() {
            return this.walkOnStreetReluctance;
        }

        public Double getGraphQLWalkReluctance() {
            return this.walkReluctance;
        }

        public Double getGraphQLWalkSafetyFactor() {
            return this.walkSafetyFactor;
        }

        public Double getGraphQLWalkSpeed() {
            return this.walkSpeed;
        }

        public Boolean getGraphQLWheelchair() {
            return this.wheelchair;
        }

        public void setGraphQLAlightSlack(Integer alightSlack) {
            this.alightSlack = alightSlack;
        }

        public void setGraphQLAllowBikeRental(Boolean allowBikeRental) {
            this.allowBikeRental = allowBikeRental;
        }

        public void setGraphQLAllowKeepingRentedBicycleAtDestination(Boolean allowKeepingRentedBicycleAtDestination) {
            this.allowKeepingRentedBicycleAtDestination = allowKeepingRentedBicycleAtDestination;
        }

        public void setGraphQLAllowedBikeRentalNetworks(List<String> allowedBikeRentalNetworks) {
            this.allowedBikeRentalNetworks = allowedBikeRentalNetworks;
        }

        public void setGraphQLAllowedTicketTypes(List<String> allowedTicketTypes) {
            this.allowedTicketTypes = allowedTicketTypes;
        }

        public void setGraphQLAllowedVehicleRentalNetworks(List<String> allowedVehicleRentalNetworks) {
            this.allowedVehicleRentalNetworks = allowedVehicleRentalNetworks;
        }

        public void setGraphQLArriveBy(Boolean arriveBy) {
            this.arriveBy = arriveBy;
        }

        public void setGraphQLBanned(GraphQLInputBannedInput banned) {
            this.banned = banned;
        }

        public void setGraphQLBannedVehicleRentalNetworks(List<String> bannedVehicleRentalNetworks) {
            this.bannedVehicleRentalNetworks = bannedVehicleRentalNetworks;
        }

        public void setGraphQLBatch(Boolean batch) {
            this.batch = batch;
        }

        public void setGraphQLBikeBoardCost(Integer bikeBoardCost) {
            this.bikeBoardCost = bikeBoardCost;
        }

        public void setGraphQLBikeReluctance(Double bikeReluctance) {
            this.bikeReluctance = bikeReluctance;
        }

        public void setGraphQLBikeSpeed(Double bikeSpeed) {
            this.bikeSpeed = bikeSpeed;
        }

        public void setGraphQLBikeSwitchCost(Integer bikeSwitchCost) {
            this.bikeSwitchCost = bikeSwitchCost;
        }

        public void setGraphQLBikeSwitchTime(Integer bikeSwitchTime) {
            this.bikeSwitchTime = bikeSwitchTime;
        }

        public void setGraphQLBikeWalkingReluctance(Double bikeWalkingReluctance) {
            this.bikeWalkingReluctance = bikeWalkingReluctance;
        }

        public void setGraphQLBoardSlack(Integer boardSlack) {
            this.boardSlack = boardSlack;
        }

        public void setGraphQLCarParkCarLegWeight(Double carParkCarLegWeight) {
            this.carParkCarLegWeight = carParkCarLegWeight;
        }

        public void setGraphQLCarReluctance(Double carReluctance) {
            this.carReluctance = carReluctance;
        }

        public void setGraphQLClaimInitialWait(Long claimInitialWait) {
            this.claimInitialWait = claimInitialWait;
        }

        public void setGraphQLCompactLegsByReversedSearch(Boolean compactLegsByReversedSearch) {
            this.compactLegsByReversedSearch = compactLegsByReversedSearch;
        }

        public void setGraphQLDate(String date) {
            this.date = date;
        }

        public void setGraphQLDebugItineraryFilter(Boolean debugItineraryFilter) {
            this.debugItineraryFilter = debugItineraryFilter;
        }

        public void setGraphQLDisableRemainingWeightHeuristic(Boolean disableRemainingWeightHeuristic) {
            this.disableRemainingWeightHeuristic = disableRemainingWeightHeuristic;
        }

        public void setGraphQLFrom(GraphQLInputCoordinatesInput from) {
            this.from = from;
        }

        public void setGraphQLFromPlace(String fromPlace) {
            this.fromPlace = fromPlace;
        }

        public void setGraphQLHeuristicStepsPerMainStep(Integer heuristicStepsPerMainStep) {
            this.heuristicStepsPerMainStep = heuristicStepsPerMainStep;
        }

        public void setGraphQLIgnoreRealtimeUpdates(Boolean ignoreRealtimeUpdates) {
            this.ignoreRealtimeUpdates = ignoreRealtimeUpdates;
        }

        public void setGraphQLIntermediatePlaces(List<GraphQLInputCoordinatesInput> intermediatePlaces) {
            this.intermediatePlaces = intermediatePlaces;
        }

        public void setGraphQLItineraryFiltering(Double itineraryFiltering) {
            this.itineraryFiltering = itineraryFiltering;
        }

        public void setGraphQLKeepingRentedBicycleAtDestinationCost(Integer keepingRentedBicycleAtDestinationCost) {
            this.keepingRentedBicycleAtDestinationCost = keepingRentedBicycleAtDestinationCost;
        }

        public void setGraphQLLocale(String locale) {
            this.locale = locale;
        }

        public void setGraphQLMaxPreTransitTime(Integer maxPreTransitTime) {
            this.maxPreTransitTime = maxPreTransitTime;
        }

        public void setGraphQLMaxTransfers(Integer maxTransfers) {
            this.maxTransfers = maxTransfers;
        }

        public void setGraphQLMaxWalkDistance(Double maxWalkDistance) {
            this.maxWalkDistance = maxWalkDistance;
        }

        public void setGraphQLMinTransferTime(Integer minTransferTime) {
            this.minTransferTime = minTransferTime;
        }

        public void setGraphQLModeWeight(GraphQLInputModeWeightInput modeWeight) {
            this.modeWeight = modeWeight;
        }

        public void setGraphQLNonpreferredTransferPenalty(Integer nonpreferredTransferPenalty) {
            this.nonpreferredTransferPenalty = nonpreferredTransferPenalty;
        }

        public void setGraphQLNumItineraries(Integer numItineraries) {
            this.numItineraries = numItineraries;
        }

        public void setGraphQLOmitCanceled(Boolean omitCanceled) {
            this.omitCanceled = omitCanceled;
        }

        public void setGraphQLOptimize(GraphQLOptimizeType optimize) {
            this.optimize = optimize;
        }

        public void setGraphQLPageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
        }

        public void setGraphQLParking(GraphQLVehicleParkingInput parking) {
            this.parking = parking;
        }

        public void setGraphQLPreferred(GraphQLInputPreferredInput preferred) {
            this.preferred = preferred;
        }

        public void setGraphQLReverseOptimizeOnTheFly(Boolean reverseOptimizeOnTheFly) {
            this.reverseOptimizeOnTheFly = reverseOptimizeOnTheFly;
        }

        public void setGraphQLSearchWindow(Long searchWindow) {
            this.searchWindow = searchWindow;
        }

        public void setGraphQLStartTransitStopId(String startTransitStopId) {
            this.startTransitStopId = startTransitStopId;
        }

        public void setGraphQLStartTransitTripId(String startTransitTripId) {
            this.startTransitTripId = startTransitTripId;
        }

        public void setGraphQLTime(String time) {
            this.time = time;
        }

        public void setGraphQLTo(GraphQLInputCoordinatesInput to) {
            this.to = to;
        }

        public void setGraphQLToPlace(String toPlace) {
            this.toPlace = toPlace;
        }

        public void setGraphQLTransferPenalty(Integer transferPenalty) {
            this.transferPenalty = transferPenalty;
        }

        public void setGraphQLTransportModes(List<GraphQLTransportModeInput> transportModes) {
            this.transportModes = transportModes;
        }

        public void setGraphQLTriangle(GraphQLInputTriangleInput triangle) {
            this.triangle = triangle;
        }

        public void setGraphQLUnpreferred(GraphQLInputUnpreferredInput unpreferred) {
            this.unpreferred = unpreferred;
        }

        public void setGraphQLVia(List<GraphQLPlanViaLocationInput> via) {
            this.via = via;
        }

        public void setGraphQLWaitAtBeginningFactor(Double waitAtBeginningFactor) {
            this.waitAtBeginningFactor = waitAtBeginningFactor;
        }

        public void setGraphQLWaitReluctance(Double waitReluctance) {
            this.waitReluctance = waitReluctance;
        }

        public void setGraphQLWalkBoardCost(Integer walkBoardCost) {
            this.walkBoardCost = walkBoardCost;
        }

        public void setGraphQLWalkOnStreetReluctance(Double walkOnStreetReluctance) {
            this.walkOnStreetReluctance = walkOnStreetReluctance;
        }

        public void setGraphQLWalkReluctance(Double walkReluctance) {
            this.walkReluctance = walkReluctance;
        }

        public void setGraphQLWalkSafetyFactor(Double walkSafetyFactor) {
            this.walkSafetyFactor = walkSafetyFactor;
        }

        public void setGraphQLWalkSpeed(Double walkSpeed) {
            this.walkSpeed = walkSpeed;
        }

        public void setGraphQLWheelchair(Boolean wheelchair) {
            this.wheelchair = wheelchair;
        }
    }

    public static class GraphQLQueryTypePatternArgs {
        private String id;

        public GraphQLQueryTypePatternArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeNodeArgs {
        private Relay.ResolvedGlobalId id;

        public GraphQLQueryTypeNodeArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (Relay.ResolvedGlobalId)args.get("id");
            }
        }

        public Relay.ResolvedGlobalId getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(Relay.ResolvedGlobalId id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeNearestArgs {
        private String after;
        private String before;
        private GraphQLInputFiltersInput filterByIds;
        private List<GraphQLMode> filterByModes;
        private List<String> filterByNetwork;
        private List<GraphQLFilterPlaceType> filterByPlaceTypes;
        private Integer first;
        private Integer last;
        private Double lat;
        private Double lon;
        private Integer maxDistance;
        private Integer maxResults;

        public GraphQLQueryTypeNearestArgs(Map<String, Object> args) {
            if (args != null) {
                this.after = (String)args.get("after");
                this.before = (String)args.get("before");
                this.filterByIds = new GraphQLInputFiltersInput((Map)args.get("filterByIds"));
                if (args.get("filterByModes") != null) {
                    this.filterByModes = ((List)args.get("filterByModes")).stream().map(item -> item instanceof GraphQLMode ? item : GraphQLMode.valueOf((String)item)).map(GraphQLMode.class::cast).collect(Collectors.toList());
                }
                this.filterByNetwork = (List)args.get("filterByNetwork");
                if (args.get("filterByPlaceTypes") != null) {
                    this.filterByPlaceTypes = ((List)args.get("filterByPlaceTypes")).stream().map(item -> item instanceof GraphQLFilterPlaceType ? item : GraphQLFilterPlaceType.valueOf((String)item)).map(GraphQLFilterPlaceType.class::cast).collect(Collectors.toList());
                }
                this.first = (Integer)args.get("first");
                this.last = (Integer)args.get("last");
                this.lat = (Double)args.get("lat");
                this.lon = (Double)args.get("lon");
                this.maxDistance = (Integer)args.get("maxDistance");
                this.maxResults = (Integer)args.get("maxResults");
            }
        }

        public String getGraphQLAfter() {
            return this.after;
        }

        public String getGraphQLBefore() {
            return this.before;
        }

        public GraphQLInputFiltersInput getGraphQLFilterByIds() {
            return this.filterByIds;
        }

        public List<GraphQLMode> getGraphQLFilterByModes() {
            return this.filterByModes;
        }

        public List<String> getGraphQLFilterByNetwork() {
            return this.filterByNetwork;
        }

        public List<GraphQLFilterPlaceType> getGraphQLFilterByPlaceTypes() {
            return this.filterByPlaceTypes;
        }

        public Integer getGraphQLFirst() {
            return this.first;
        }

        public Integer getGraphQLLast() {
            return this.last;
        }

        public Double getGraphQLLat() {
            return this.lat;
        }

        public Double getGraphQLLon() {
            return this.lon;
        }

        public Integer getGraphQLMaxDistance() {
            return this.maxDistance;
        }

        public Integer getGraphQLMaxResults() {
            return this.maxResults;
        }

        public void setGraphQLAfter(String after) {
            this.after = after;
        }

        public void setGraphQLBefore(String before) {
            this.before = before;
        }

        public void setGraphQLFilterByIds(GraphQLInputFiltersInput filterByIds) {
            this.filterByIds = filterByIds;
        }

        public void setGraphQLFilterByModes(List<GraphQLMode> filterByModes) {
            this.filterByModes = filterByModes;
        }

        public void setGraphQLFilterByNetwork(List<String> filterByNetwork) {
            this.filterByNetwork = filterByNetwork;
        }

        public void setGraphQLFilterByPlaceTypes(List<GraphQLFilterPlaceType> filterByPlaceTypes) {
            this.filterByPlaceTypes = filterByPlaceTypes;
        }

        public void setGraphQLFirst(Integer first) {
            this.first = first;
        }

        public void setGraphQLLast(Integer last) {
            this.last = last;
        }

        public void setGraphQLLat(Double lat) {
            this.lat = lat;
        }

        public void setGraphQLLon(Double lon) {
            this.lon = lon;
        }

        public void setGraphQLMaxDistance(Integer maxDistance) {
            this.maxDistance = maxDistance;
        }

        public void setGraphQLMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }
    }

    public static class GraphQLQueryTypeLegArgs {
        private String id;

        public GraphQLQueryTypeLegArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeFuzzyTripArgs {
        private String date;
        private Integer direction;
        private String route;
        private Integer time;

        public GraphQLQueryTypeFuzzyTripArgs(Map<String, Object> args) {
            if (args != null) {
                this.date = (String)args.get("date");
                this.direction = (Integer)args.get("direction");
                this.route = (String)args.get("route");
                this.time = (Integer)args.get("time");
            }
        }

        public String getGraphQLDate() {
            return this.date;
        }

        public Integer getGraphQLDirection() {
            return this.direction;
        }

        public String getGraphQLRoute() {
            return this.route;
        }

        public Integer getGraphQLTime() {
            return this.time;
        }

        public void setGraphQLDate(String date) {
            this.date = date;
        }

        public void setGraphQLDirection(Integer direction) {
            this.direction = direction;
        }

        public void setGraphQLRoute(String route) {
            this.route = route;
        }

        public void setGraphQLTime(Integer time) {
            this.time = time;
        }
    }

    public static class GraphQLQueryTypeDepartureRowArgs {
        private String id;

        public GraphQLQueryTypeDepartureRowArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeClusterArgs {
        private String id;

        public GraphQLQueryTypeClusterArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeCarParksArgs {
        private List<String> ids;

        public GraphQLQueryTypeCarParksArgs(Map<String, Object> args) {
            if (args != null) {
                this.ids = (List)args.get("ids");
            }
        }

        public List<String> getGraphQLIds() {
            return this.ids;
        }

        public void setGraphQLIds(List<String> ids) {
            this.ids = ids;
        }
    }

    public static class GraphQLQueryTypeCarParkArgs {
        private String id;

        public GraphQLQueryTypeCarParkArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeCancelledTripTimesArgs {
        private List<String> feeds;
        private Integer maxArrivalTime;
        private String maxDate;
        private Integer maxDepartureTime;
        private Integer minArrivalTime;
        private String minDate;
        private Integer minDepartureTime;
        private List<String> patterns;
        private List<String> routes;
        private List<String> trips;

        public GraphQLQueryTypeCancelledTripTimesArgs(Map<String, Object> args) {
            if (args != null) {
                this.feeds = (List)args.get("feeds");
                this.maxArrivalTime = (Integer)args.get("maxArrivalTime");
                this.maxDate = (String)args.get("maxDate");
                this.maxDepartureTime = (Integer)args.get("maxDepartureTime");
                this.minArrivalTime = (Integer)args.get("minArrivalTime");
                this.minDate = (String)args.get("minDate");
                this.minDepartureTime = (Integer)args.get("minDepartureTime");
                this.patterns = (List)args.get("patterns");
                this.routes = (List)args.get("routes");
                this.trips = (List)args.get("trips");
            }
        }

        public List<String> getGraphQLFeeds() {
            return this.feeds;
        }

        public Integer getGraphQLMaxArrivalTime() {
            return this.maxArrivalTime;
        }

        public String getGraphQLMaxDate() {
            return this.maxDate;
        }

        public Integer getGraphQLMaxDepartureTime() {
            return this.maxDepartureTime;
        }

        public Integer getGraphQLMinArrivalTime() {
            return this.minArrivalTime;
        }

        public String getGraphQLMinDate() {
            return this.minDate;
        }

        public Integer getGraphQLMinDepartureTime() {
            return this.minDepartureTime;
        }

        public List<String> getGraphQLPatterns() {
            return this.patterns;
        }

        public List<String> getGraphQLRoutes() {
            return this.routes;
        }

        public List<String> getGraphQLTrips() {
            return this.trips;
        }

        public void setGraphQLFeeds(List<String> feeds) {
            this.feeds = feeds;
        }

        public void setGraphQLMaxArrivalTime(Integer maxArrivalTime) {
            this.maxArrivalTime = maxArrivalTime;
        }

        public void setGraphQLMaxDate(String maxDate) {
            this.maxDate = maxDate;
        }

        public void setGraphQLMaxDepartureTime(Integer maxDepartureTime) {
            this.maxDepartureTime = maxDepartureTime;
        }

        public void setGraphQLMinArrivalTime(Integer minArrivalTime) {
            this.minArrivalTime = minArrivalTime;
        }

        public void setGraphQLMinDate(String minDate) {
            this.minDate = minDate;
        }

        public void setGraphQLMinDepartureTime(Integer minDepartureTime) {
            this.minDepartureTime = minDepartureTime;
        }

        public void setGraphQLPatterns(List<String> patterns) {
            this.patterns = patterns;
        }

        public void setGraphQLRoutes(List<String> routes) {
            this.routes = routes;
        }

        public void setGraphQLTrips(List<String> trips) {
            this.trips = trips;
        }
    }

    public static class GraphQLQueryTypeCanceledTripsArgs {
        private String after;
        private String before;
        private Integer first;
        private Integer last;

        public GraphQLQueryTypeCanceledTripsArgs(Map<String, Object> args) {
            if (args != null) {
                this.after = (String)args.get("after");
                this.before = (String)args.get("before");
                this.first = (Integer)args.get("first");
                this.last = (Integer)args.get("last");
            }
        }

        public String getGraphQLAfter() {
            return this.after;
        }

        public String getGraphQLBefore() {
            return this.before;
        }

        public Integer getGraphQLFirst() {
            return this.first;
        }

        public Integer getGraphQLLast() {
            return this.last;
        }

        public void setGraphQLAfter(String after) {
            this.after = after;
        }

        public void setGraphQLBefore(String before) {
            this.before = before;
        }

        public void setGraphQLFirst(Integer first) {
            this.first = first;
        }

        public void setGraphQLLast(Integer last) {
            this.last = last;
        }
    }

    public static class GraphQLQueryTypeBikeRentalStationsArgs {
        private List<String> ids;

        public GraphQLQueryTypeBikeRentalStationsArgs(Map<String, Object> args) {
            if (args != null) {
                this.ids = (List)args.get("ids");
            }
        }

        public List<String> getGraphQLIds() {
            return this.ids;
        }

        public void setGraphQLIds(List<String> ids) {
            this.ids = ids;
        }
    }

    public static class GraphQLQueryTypeBikeRentalStationArgs {
        private String id;

        public GraphQLQueryTypeBikeRentalStationArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeBikeParkArgs {
        private String id;

        public GraphQLQueryTypeBikeParkArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static class GraphQLQueryTypeAlertsArgs {
        private List<GraphQLAlertCauseType> cause;
        private List<GraphQLAlertEffectType> effect;
        private List<String> feeds;
        private List<String> route;
        private List<GraphQLAlertSeverityLevelType> severityLevel;
        private List<String> stop;

        public GraphQLQueryTypeAlertsArgs(Map<String, Object> args) {
            if (args != null) {
                if (args.get("cause") != null) {
                    this.cause = ((List)args.get("cause")).stream().map(item -> item instanceof GraphQLAlertCauseType ? item : GraphQLAlertCauseType.valueOf((String)item)).map(GraphQLAlertCauseType.class::cast).collect(Collectors.toList());
                }
                if (args.get("effect") != null) {
                    this.effect = ((List)args.get("effect")).stream().map(item -> item instanceof GraphQLAlertEffectType ? item : GraphQLAlertEffectType.valueOf((String)item)).map(GraphQLAlertEffectType.class::cast).collect(Collectors.toList());
                }
                this.feeds = (List)args.get("feeds");
                this.route = (List)args.get("route");
                if (args.get("severityLevel") != null) {
                    this.severityLevel = ((List)args.get("severityLevel")).stream().map(item -> item instanceof GraphQLAlertSeverityLevelType ? item : GraphQLAlertSeverityLevelType.valueOf((String)item)).map(GraphQLAlertSeverityLevelType.class::cast).collect(Collectors.toList());
                }
                this.stop = (List)args.get("stop");
            }
        }

        public List<GraphQLAlertCauseType> getGraphQLCause() {
            return this.cause;
        }

        public List<GraphQLAlertEffectType> getGraphQLEffect() {
            return this.effect;
        }

        public List<String> getGraphQLFeeds() {
            return this.feeds;
        }

        public List<String> getGraphQLRoute() {
            return this.route;
        }

        public List<GraphQLAlertSeverityLevelType> getGraphQLSeverityLevel() {
            return this.severityLevel;
        }

        public List<String> getGraphQLStop() {
            return this.stop;
        }

        public void setGraphQLCause(List<GraphQLAlertCauseType> cause) {
            this.cause = cause;
        }

        public void setGraphQLEffect(List<GraphQLAlertEffectType> effect) {
            this.effect = effect;
        }

        public void setGraphQLFeeds(List<String> feeds) {
            this.feeds = feeds;
        }

        public void setGraphQLRoute(List<String> route) {
            this.route = route;
        }

        public void setGraphQLSeverityLevel(List<GraphQLAlertSeverityLevelType> severityLevel) {
            this.severityLevel = severityLevel;
        }

        public void setGraphQLStop(List<String> stop) {
            this.stop = stop;
        }
    }

    public static class GraphQLQueryTypeAgencyArgs {
        private String id;

        public GraphQLQueryTypeAgencyArgs(Map<String, Object> args) {
            if (args != null) {
                this.id = (String)args.get("id");
            }
        }

        public String getGraphQLId() {
            return this.id;
        }

        public void setGraphQLId(String id) {
            this.id = id;
        }
    }

    public static enum GraphQLQualifier {
        ACCESS,
        DIRECT,
        DROPOFF,
        EGRESS,
        HAIL,
        HAVE,
        KEEP,
        PARK,
        PICKUP,
        RENT;

    }

    public static enum GraphQLPropulsionType {
        COMBUSTION,
        COMBUSTION_DIESEL,
        ELECTRIC,
        ELECTRIC_ASSIST,
        HUMAN,
        HYBRID,
        HYDROGEN_FUEL_CELL,
        PLUG_IN_HYBRID;

    }

    public static class GraphQLPlanVisitViaLocationInput {
        private GraphQLPlanCoordinateInput coordinate;
        private String label;
        private Duration minimumWaitTime;
        private List<String> stopLocationIds;

        public GraphQLPlanVisitViaLocationInput(Map<String, Object> args) {
            if (args != null) {
                this.coordinate = new GraphQLPlanCoordinateInput((Map)args.get("coordinate"));
                this.label = (String)args.get("label");
                this.minimumWaitTime = (Duration)args.get("minimumWaitTime");
                this.stopLocationIds = (List)args.get("stopLocationIds");
            }
        }

        public GraphQLPlanCoordinateInput getGraphQLCoordinate() {
            return this.coordinate;
        }

        public String getGraphQLLabel() {
            return this.label;
        }

        public Duration getGraphQLMinimumWaitTime() {
            return this.minimumWaitTime;
        }

        public List<String> getGraphQLStopLocationIds() {
            return this.stopLocationIds;
        }

        public void setGraphQLCoordinate(GraphQLPlanCoordinateInput coordinate) {
            this.coordinate = coordinate;
        }

        public void setGraphQLLabel(String label) {
            this.label = label;
        }

        public void setGraphQLMinimumWaitTime(Duration minimumWaitTime) {
            this.minimumWaitTime = minimumWaitTime;
        }

        public void setGraphQLStopLocationIds(List<String> stopLocationIds) {
            this.stopLocationIds = stopLocationIds;
        }
    }

    public static class GraphQLPlanViaLocationInput {
        private GraphQLPlanPassThroughViaLocationInput passThrough;
        private GraphQLPlanVisitViaLocationInput visit;

        public GraphQLPlanViaLocationInput(Map<String, Object> args) {
            if (args != null) {
                this.passThrough = new GraphQLPlanPassThroughViaLocationInput((Map)args.get("passThrough"));
                this.visit = new GraphQLPlanVisitViaLocationInput((Map)args.get("visit"));
            }
        }

        public GraphQLPlanPassThroughViaLocationInput getGraphQLPassThrough() {
            return this.passThrough;
        }

        public GraphQLPlanVisitViaLocationInput getGraphQLVisit() {
            return this.visit;
        }

        public void setGraphQLPassThrough(GraphQLPlanPassThroughViaLocationInput passThrough) {
            this.passThrough = passThrough;
        }

        public void setGraphQLVisit(GraphQLPlanVisitViaLocationInput visit) {
            this.visit = visit;
        }
    }

    public static class GraphQLPlanTransitModesInput {
        private List<GraphQLPlanAccessMode> access;
        private List<GraphQLPlanEgressMode> egress;
        private List<GraphQLPlanTransferMode> transfer;
        private List<GraphQLPlanTransitModePreferenceInput> transit;

        public GraphQLPlanTransitModesInput(Map<String, Object> args) {
            if (args != null) {
                if (args.get("access") != null) {
                    this.access = ((List)args.get("access")).stream().map(item -> item instanceof GraphQLPlanAccessMode ? item : GraphQLPlanAccessMode.valueOf((String)item)).map(GraphQLPlanAccessMode.class::cast).collect(Collectors.toList());
                }
                if (args.get("egress") != null) {
                    this.egress = ((List)args.get("egress")).stream().map(item -> item instanceof GraphQLPlanEgressMode ? item : GraphQLPlanEgressMode.valueOf((String)item)).map(GraphQLPlanEgressMode.class::cast).collect(Collectors.toList());
                }
                if (args.get("transfer") != null) {
                    this.transfer = ((List)args.get("transfer")).stream().map(item -> item instanceof GraphQLPlanTransferMode ? item : GraphQLPlanTransferMode.valueOf((String)item)).map(GraphQLPlanTransferMode.class::cast).collect(Collectors.toList());
                }
                if (args.get("transit") != null) {
                    this.transit = ((List)args.get("transit")).stream().map(o -> o == null ? null : new GraphQLPlanTransitModePreferenceInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
            }
        }

        public List<GraphQLPlanAccessMode> getGraphQLAccess() {
            return this.access;
        }

        public List<GraphQLPlanEgressMode> getGraphQLEgress() {
            return this.egress;
        }

        public List<GraphQLPlanTransferMode> getGraphQLTransfer() {
            return this.transfer;
        }

        public List<GraphQLPlanTransitModePreferenceInput> getGraphQLTransit() {
            return this.transit;
        }

        public void setGraphQLAccess(List<GraphQLPlanAccessMode> access) {
            this.access = access;
        }

        public void setGraphQLEgress(List<GraphQLPlanEgressMode> egress) {
            this.egress = egress;
        }

        public void setGraphQLTransfer(List<GraphQLPlanTransferMode> transfer) {
            this.transfer = transfer;
        }

        public void setGraphQLTransit(List<GraphQLPlanTransitModePreferenceInput> transit) {
            this.transit = transit;
        }
    }

    public static class GraphQLPlanTransitModePreferenceInput {
        private GraphQLTransitModePreferenceCostInput cost;
        private GraphQLTransitMode mode;

        public GraphQLPlanTransitModePreferenceInput(Map<String, Object> args) {
            if (args != null) {
                this.cost = new GraphQLTransitModePreferenceCostInput((Map)args.get("cost"));
                if (args.get("mode") instanceof GraphQLTransitMode) {
                    this.mode = (GraphQLTransitMode)((Object)args.get("mode"));
                } else if (args.get("mode") != null) {
                    this.mode = GraphQLTransitMode.valueOf((String)args.get("mode"));
                }
            }
        }

        public GraphQLTransitModePreferenceCostInput getGraphQLCost() {
            return this.cost;
        }

        public GraphQLTransitMode getGraphQLMode() {
            return this.mode;
        }

        public void setGraphQLCost(GraphQLTransitModePreferenceCostInput cost) {
            this.cost = cost;
        }

        public void setGraphQLMode(GraphQLTransitMode mode) {
            this.mode = mode;
        }
    }

    public static enum GraphQLPlanTransferMode {
        BICYCLE,
        CAR,
        WALK;

    }

    public static class GraphQLPlanStreetPreferencesInput {
        private GraphQLBicyclePreferencesInput bicycle;
        private GraphQLCarPreferencesInput car;
        private GraphQLScooterPreferencesInput scooter;
        private GraphQLWalkPreferencesInput walk;

        public GraphQLPlanStreetPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.bicycle = new GraphQLBicyclePreferencesInput((Map)args.get("bicycle"));
                this.car = new GraphQLCarPreferencesInput((Map)args.get("car"));
                this.scooter = new GraphQLScooterPreferencesInput((Map)args.get("scooter"));
                this.walk = new GraphQLWalkPreferencesInput((Map)args.get("walk"));
            }
        }

        public GraphQLBicyclePreferencesInput getGraphQLBicycle() {
            return this.bicycle;
        }

        public GraphQLCarPreferencesInput getGraphQLCar() {
            return this.car;
        }

        public GraphQLScooterPreferencesInput getGraphQLScooter() {
            return this.scooter;
        }

        public GraphQLWalkPreferencesInput getGraphQLWalk() {
            return this.walk;
        }

        public void setGraphQLBicycle(GraphQLBicyclePreferencesInput bicycle) {
            this.bicycle = bicycle;
        }

        public void setGraphQLCar(GraphQLCarPreferencesInput car) {
            this.car = car;
        }

        public void setGraphQLScooter(GraphQLScooterPreferencesInput scooter) {
            this.scooter = scooter;
        }

        public void setGraphQLWalk(GraphQLWalkPreferencesInput walk) {
            this.walk = walk;
        }
    }

    public static class GraphQLPlanStopLocationInput {
        private String stopLocationId;

        public GraphQLPlanStopLocationInput(Map<String, Object> args) {
            if (args != null) {
                this.stopLocationId = (String)args.get("stopLocationId");
            }
        }

        public String getGraphQLStopLocationId() {
            return this.stopLocationId;
        }

        public void setGraphQLStopLocationId(String stopLocationId) {
            this.stopLocationId = stopLocationId;
        }
    }

    public static class GraphQLPlanPreferencesInput {
        private GraphQLAccessibilityPreferencesInput accessibility;
        private GraphQLPlanStreetPreferencesInput street;
        private GraphQLTransitPreferencesInput transit;

        public GraphQLPlanPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.accessibility = new GraphQLAccessibilityPreferencesInput((Map)args.get("accessibility"));
                this.street = new GraphQLPlanStreetPreferencesInput((Map)args.get("street"));
                this.transit = new GraphQLTransitPreferencesInput((Map)args.get("transit"));
            }
        }

        public GraphQLAccessibilityPreferencesInput getGraphQLAccessibility() {
            return this.accessibility;
        }

        public GraphQLPlanStreetPreferencesInput getGraphQLStreet() {
            return this.street;
        }

        public GraphQLTransitPreferencesInput getGraphQLTransit() {
            return this.transit;
        }

        public void setGraphQLAccessibility(GraphQLAccessibilityPreferencesInput accessibility) {
            this.accessibility = accessibility;
        }

        public void setGraphQLStreet(GraphQLPlanStreetPreferencesInput street) {
            this.street = street;
        }

        public void setGraphQLTransit(GraphQLTransitPreferencesInput transit) {
            this.transit = transit;
        }
    }

    public static class GraphQLPlanPassThroughViaLocationInput {
        private String label;
        private List<String> stopLocationIds;

        public GraphQLPlanPassThroughViaLocationInput(Map<String, Object> args) {
            if (args != null) {
                this.label = (String)args.get("label");
                this.stopLocationIds = (List)args.get("stopLocationIds");
            }
        }

        public String getGraphQLLabel() {
            return this.label;
        }

        public List<String> getGraphQLStopLocationIds() {
            return this.stopLocationIds;
        }

        public void setGraphQLLabel(String label) {
            this.label = label;
        }

        public void setGraphQLStopLocationIds(List<String> stopLocationIds) {
            this.stopLocationIds = stopLocationIds;
        }
    }

    public static class GraphQLPlanModesInput {
        private List<GraphQLPlanDirectMode> direct;
        private Boolean directOnly;
        private GraphQLPlanTransitModesInput transit;
        private Boolean transitOnly;

        public GraphQLPlanModesInput(Map<String, Object> args) {
            if (args != null) {
                if (args.get("direct") != null) {
                    this.direct = ((List)args.get("direct")).stream().map(item -> item instanceof GraphQLPlanDirectMode ? item : GraphQLPlanDirectMode.valueOf((String)item)).map(GraphQLPlanDirectMode.class::cast).collect(Collectors.toList());
                }
                this.directOnly = (Boolean)args.get("directOnly");
                this.transit = new GraphQLPlanTransitModesInput((Map)args.get("transit"));
                this.transitOnly = (Boolean)args.get("transitOnly");
            }
        }

        public List<GraphQLPlanDirectMode> getGraphQLDirect() {
            return this.direct;
        }

        public Boolean getGraphQLDirectOnly() {
            return this.directOnly;
        }

        public GraphQLPlanTransitModesInput getGraphQLTransit() {
            return this.transit;
        }

        public Boolean getGraphQLTransitOnly() {
            return this.transitOnly;
        }

        public void setGraphQLDirect(List<GraphQLPlanDirectMode> direct) {
            this.direct = direct;
        }

        public void setGraphQLDirectOnly(Boolean directOnly) {
            this.directOnly = directOnly;
        }

        public void setGraphQLTransit(GraphQLPlanTransitModesInput transit) {
            this.transit = transit;
        }

        public void setGraphQLTransitOnly(Boolean transitOnly) {
            this.transitOnly = transitOnly;
        }
    }

    public static class GraphQLPlanLocationInput {
        private GraphQLPlanCoordinateInput coordinate;
        private GraphQLPlanStopLocationInput stopLocation;

        public GraphQLPlanLocationInput(Map<String, Object> args) {
            if (args != null) {
                this.coordinate = new GraphQLPlanCoordinateInput((Map)args.get("coordinate"));
                this.stopLocation = new GraphQLPlanStopLocationInput((Map)args.get("stopLocation"));
            }
        }

        public GraphQLPlanCoordinateInput getGraphQLCoordinate() {
            return this.coordinate;
        }

        public GraphQLPlanStopLocationInput getGraphQLStopLocation() {
            return this.stopLocation;
        }

        public void setGraphQLCoordinate(GraphQLPlanCoordinateInput coordinate) {
            this.coordinate = coordinate;
        }

        public void setGraphQLStopLocation(GraphQLPlanStopLocationInput stopLocation) {
            this.stopLocation = stopLocation;
        }
    }

    public static class GraphQLPlanLabeledLocationInput {
        private String label;
        private GraphQLPlanLocationInput location;

        public GraphQLPlanLabeledLocationInput(Map<String, Object> args) {
            if (args != null) {
                this.label = (String)args.get("label");
                this.location = new GraphQLPlanLocationInput((Map)args.get("location"));
            }
        }

        public String getGraphQLLabel() {
            return this.label;
        }

        public GraphQLPlanLocationInput getGraphQLLocation() {
            return this.location;
        }

        public void setGraphQLLabel(String label) {
            this.label = label;
        }

        public void setGraphQLLocation(GraphQLPlanLocationInput location) {
            this.location = location;
        }
    }

    public static class GraphQLPlanItineraryFilterInput {
        private Double groupSimilarityKeepOne;
        private Double groupSimilarityKeepThree;
        private Double groupedOtherThanSameLegsMaxCostMultiplier;
        private GraphQLItineraryFilterDebugProfile itineraryFilterDebugProfile;

        public GraphQLPlanItineraryFilterInput(Map<String, Object> args) {
            if (args != null) {
                this.groupSimilarityKeepOne = (Double)args.get("groupSimilarityKeepOne");
                this.groupSimilarityKeepThree = (Double)args.get("groupSimilarityKeepThree");
                this.groupedOtherThanSameLegsMaxCostMultiplier = (Double)args.get("groupedOtherThanSameLegsMaxCostMultiplier");
                if (args.get("itineraryFilterDebugProfile") instanceof GraphQLItineraryFilterDebugProfile) {
                    this.itineraryFilterDebugProfile = (GraphQLItineraryFilterDebugProfile)((Object)args.get("itineraryFilterDebugProfile"));
                } else if (args.get("itineraryFilterDebugProfile") != null) {
                    this.itineraryFilterDebugProfile = GraphQLItineraryFilterDebugProfile.valueOf((String)args.get("itineraryFilterDebugProfile"));
                }
            }
        }

        public Double getGraphQLGroupSimilarityKeepOne() {
            return this.groupSimilarityKeepOne;
        }

        public Double getGraphQLGroupSimilarityKeepThree() {
            return this.groupSimilarityKeepThree;
        }

        public Double getGraphQLGroupedOtherThanSameLegsMaxCostMultiplier() {
            return this.groupedOtherThanSameLegsMaxCostMultiplier;
        }

        public GraphQLItineraryFilterDebugProfile getGraphQLItineraryFilterDebugProfile() {
            return this.itineraryFilterDebugProfile;
        }

        public void setGraphQLGroupSimilarityKeepOne(Double groupSimilarityKeepOne) {
            this.groupSimilarityKeepOne = groupSimilarityKeepOne;
        }

        public void setGraphQLGroupSimilarityKeepThree(Double groupSimilarityKeepThree) {
            this.groupSimilarityKeepThree = groupSimilarityKeepThree;
        }

        public void setGraphQLGroupedOtherThanSameLegsMaxCostMultiplier(Double groupedOtherThanSameLegsMaxCostMultiplier) {
            this.groupedOtherThanSameLegsMaxCostMultiplier = groupedOtherThanSameLegsMaxCostMultiplier;
        }

        public void setGraphQLItineraryFilterDebugProfile(GraphQLItineraryFilterDebugProfile itineraryFilterDebugProfile) {
            this.itineraryFilterDebugProfile = itineraryFilterDebugProfile;
        }
    }

    public static enum GraphQLPlanEgressMode {
        BICYCLE,
        BICYCLE_RENTAL,
        CAR,
        CAR_PICKUP,
        CAR_RENTAL,
        FLEX,
        SCOOTER_RENTAL,
        WALK;

    }

    public static enum GraphQLPlanDirectMode {
        BICYCLE,
        BICYCLE_PARKING,
        BICYCLE_RENTAL,
        CAR,
        CAR_PARKING,
        CAR_RENTAL,
        FLEX,
        SCOOTER_RENTAL,
        WALK;

    }

    public static class GraphQLPlanDateTimeInput {
        private OffsetDateTime earliestDeparture;
        private OffsetDateTime latestArrival;

        public GraphQLPlanDateTimeInput(Map<String, Object> args) {
            if (args != null) {
                this.earliestDeparture = (OffsetDateTime)args.get("earliestDeparture");
                this.latestArrival = (OffsetDateTime)args.get("latestArrival");
            }
        }

        public OffsetDateTime getGraphQLEarliestDeparture() {
            return this.earliestDeparture;
        }

        public OffsetDateTime getGraphQLLatestArrival() {
            return this.latestArrival;
        }

        public void setGraphQLEarliestDeparture(OffsetDateTime earliestDeparture) {
            this.earliestDeparture = earliestDeparture;
        }

        public void setGraphQLLatestArrival(OffsetDateTime latestArrival) {
            this.latestArrival = latestArrival;
        }
    }

    public static class GraphQLPlanCoordinateInput {
        private Double latitude;
        private Double longitude;

        public GraphQLPlanCoordinateInput(Map<String, Object> args) {
            if (args != null) {
                this.latitude = (Double)args.get("latitude");
                this.longitude = (Double)args.get("longitude");
            }
        }

        public Double getGraphQLLatitude() {
            return this.latitude;
        }

        public Double getGraphQLLongitude() {
            return this.longitude;
        }

        public void setGraphQLLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public void setGraphQLLongitude(Double longitude) {
            this.longitude = longitude;
        }
    }

    public static enum GraphQLPlanAccessMode {
        BICYCLE,
        BICYCLE_PARKING,
        BICYCLE_RENTAL,
        CAR,
        CAR_DROP_OFF,
        CAR_PARKING,
        CAR_RENTAL,
        FLEX,
        SCOOTER_RENTAL,
        WALK;

    }

    public static enum GraphQLPickupDropoffType {
        CALL_AGENCY,
        COORDINATE_WITH_DRIVER,
        NONE,
        SCHEDULED;

    }

    public static enum GraphQLPatternAlertType {
        AGENCY,
        PATTERN,
        ROUTE,
        ROUTE_TYPE,
        STOPS_ON_PATTERN,
        STOPS_ON_TRIPS,
        TRIPS;

    }

    public static class GraphQLPatternTripsForDateArgs {
        private String serviceDate;

        public GraphQLPatternTripsForDateArgs(Map<String, Object> args) {
            if (args != null) {
                this.serviceDate = (String)args.get("serviceDate");
            }
        }

        public String getGraphQLServiceDate() {
            return this.serviceDate;
        }

        public void setGraphQLServiceDate(String serviceDate) {
            this.serviceDate = serviceDate;
        }
    }

    public static class GraphQLPatternAlertsArgs {
        private List<GraphQLPatternAlertType> types;

        public GraphQLPatternAlertsArgs(Map<String, Object> args) {
            if (args != null && args.get("types") != null) {
                this.types = ((List)args.get("types")).stream().map(item -> item instanceof GraphQLPatternAlertType ? item : GraphQLPatternAlertType.valueOf((String)item)).map(GraphQLPatternAlertType.class::cast).collect(Collectors.toList());
            }
        }

        public List<GraphQLPatternAlertType> getGraphQLTypes() {
            return this.types;
        }

        public void setGraphQLTypes(List<GraphQLPatternAlertType> types) {
            this.types = types;
        }
    }

    public static class GraphQLParkingFilterOperationInput {
        private List<String> tags;

        public GraphQLParkingFilterOperationInput(Map<String, Object> args) {
            if (args != null) {
                this.tags = (List)args.get("tags");
            }
        }

        public List<String> getGraphQLTags() {
            return this.tags;
        }

        public void setGraphQLTags(List<String> tags) {
            this.tags = tags;
        }
    }

    public static class GraphQLParkingFilterInput {
        private List<GraphQLParkingFilterOperationInput> not;
        private List<GraphQLParkingFilterOperationInput> select;

        public GraphQLParkingFilterInput(Map<String, Object> args) {
            if (args != null) {
                if (args.get("not") != null) {
                    this.not = ((List)args.get("not")).stream().map(o -> o == null ? null : new GraphQLParkingFilterOperationInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                if (args.get("select") != null) {
                    this.select = ((List)args.get("select")).stream().map(o -> o == null ? null : new GraphQLParkingFilterOperationInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
            }
        }

        public List<GraphQLParkingFilterOperationInput> getGraphQLNot() {
            return this.not;
        }

        public List<GraphQLParkingFilterOperationInput> getGraphQLSelect() {
            return this.select;
        }

        public void setGraphQLNot(List<GraphQLParkingFilterOperationInput> not) {
            this.not = not;
        }

        public void setGraphQLSelect(List<GraphQLParkingFilterOperationInput> select) {
            this.select = select;
        }
    }

    public static enum GraphQLOptimizeType {
        FLAT,
        GREENWAYS,
        QUICK,
        SAFE,
        TRIANGLE;

    }

    public static class GraphQLOpeningHoursDatesArgs {
        private List<String> dates;

        public GraphQLOpeningHoursDatesArgs(Map<String, Object> args) {
            if (args != null) {
                this.dates = (List)args.get("dates");
            }
        }

        public List<String> getGraphQLDates() {
            return this.dates;
        }

        public void setGraphQLDates(List<String> dates) {
            this.dates = dates;
        }
    }

    public static enum GraphQLOccupancyStatus {
        CRUSHED_STANDING_ROOM_ONLY,
        EMPTY,
        FEW_SEATS_AVAILABLE,
        FULL,
        MANY_SEATS_AVAILABLE,
        NOT_ACCEPTING_PASSENGERS,
        NO_DATA_AVAILABLE,
        STANDING_ROOM_ONLY;

    }

    public static enum GraphQLMode {
        AIRPLANE,
        BICYCLE,
        BUS,
        CABLE_CAR,
        CAR,
        CARPOOL,
        COACH,
        FERRY,
        FLEX,
        FLEXIBLE,
        FUNICULAR,
        GONDOLA,
        LEG_SWITCH,
        MONORAIL,
        RAIL,
        SCOOTER,
        SUBWAY,
        TAXI,
        TRAM,
        TRANSIT,
        TROLLEYBUS,
        WALK;

    }

    public static enum GraphQLLocationType {
        ENTRANCE,
        STATION,
        STOP;

    }

    public static class GraphQLLocalDateRangeInput {
        private LocalDate end;
        private LocalDate start;

        public GraphQLLocalDateRangeInput(Map<String, Object> args) {
            if (args != null) {
                this.end = (LocalDate)args.get("end");
                this.start = (LocalDate)args.get("start");
            }
        }

        public LocalDate getGraphQLEnd() {
            return this.end;
        }

        public LocalDate getGraphQLStart() {
            return this.start;
        }

        public void setGraphQLEnd(LocalDate end) {
            this.end = end;
        }

        public void setGraphQLStart(LocalDate start) {
            this.start = start;
        }
    }

    public static class GraphQLLegPreviousLegsArgs {
        private List<GraphQLTransitMode> destinationModesWithParentStation;
        private Integer numberOfLegs;
        private List<GraphQLTransitMode> originModesWithParentStation;

        public GraphQLLegPreviousLegsArgs(Map<String, Object> args) {
            if (args != null) {
                if (args.get("destinationModesWithParentStation") != null) {
                    this.destinationModesWithParentStation = ((List)args.get("destinationModesWithParentStation")).stream().map(item -> item instanceof GraphQLTransitMode ? item : GraphQLTransitMode.valueOf((String)item)).map(GraphQLTransitMode.class::cast).collect(Collectors.toList());
                }
                this.numberOfLegs = (Integer)args.get("numberOfLegs");
                if (args.get("originModesWithParentStation") != null) {
                    this.originModesWithParentStation = ((List)args.get("originModesWithParentStation")).stream().map(item -> item instanceof GraphQLTransitMode ? item : GraphQLTransitMode.valueOf((String)item)).map(GraphQLTransitMode.class::cast).collect(Collectors.toList());
                }
            }
        }

        public List<GraphQLTransitMode> getGraphQLDestinationModesWithParentStation() {
            return this.destinationModesWithParentStation;
        }

        public Integer getGraphQLNumberOfLegs() {
            return this.numberOfLegs;
        }

        public List<GraphQLTransitMode> getGraphQLOriginModesWithParentStation() {
            return this.originModesWithParentStation;
        }

        public void setGraphQLDestinationModesWithParentStation(List<GraphQLTransitMode> destinationModesWithParentStation) {
            this.destinationModesWithParentStation = destinationModesWithParentStation;
        }

        public void setGraphQLNumberOfLegs(Integer numberOfLegs) {
            this.numberOfLegs = numberOfLegs;
        }

        public void setGraphQLOriginModesWithParentStation(List<GraphQLTransitMode> originModesWithParentStation) {
            this.originModesWithParentStation = originModesWithParentStation;
        }
    }

    public static class GraphQLLegNextLegsArgs {
        private List<GraphQLTransitMode> destinationModesWithParentStation;
        private Integer numberOfLegs;
        private List<GraphQLTransitMode> originModesWithParentStation;

        public GraphQLLegNextLegsArgs(Map<String, Object> args) {
            if (args != null) {
                if (args.get("destinationModesWithParentStation") != null) {
                    this.destinationModesWithParentStation = ((List)args.get("destinationModesWithParentStation")).stream().map(item -> item instanceof GraphQLTransitMode ? item : GraphQLTransitMode.valueOf((String)item)).map(GraphQLTransitMode.class::cast).collect(Collectors.toList());
                }
                this.numberOfLegs = (Integer)args.get("numberOfLegs");
                if (args.get("originModesWithParentStation") != null) {
                    this.originModesWithParentStation = ((List)args.get("originModesWithParentStation")).stream().map(item -> item instanceof GraphQLTransitMode ? item : GraphQLTransitMode.valueOf((String)item)).map(GraphQLTransitMode.class::cast).collect(Collectors.toList());
                }
            }
        }

        public List<GraphQLTransitMode> getGraphQLDestinationModesWithParentStation() {
            return this.destinationModesWithParentStation;
        }

        public Integer getGraphQLNumberOfLegs() {
            return this.numberOfLegs;
        }

        public List<GraphQLTransitMode> getGraphQLOriginModesWithParentStation() {
            return this.originModesWithParentStation;
        }

        public void setGraphQLDestinationModesWithParentStation(List<GraphQLTransitMode> destinationModesWithParentStation) {
            this.destinationModesWithParentStation = destinationModesWithParentStation;
        }

        public void setGraphQLNumberOfLegs(Integer numberOfLegs) {
            this.numberOfLegs = numberOfLegs;
        }

        public void setGraphQLOriginModesWithParentStation(List<GraphQLTransitMode> originModesWithParentStation) {
            this.originModesWithParentStation = originModesWithParentStation;
        }
    }

    public static class GraphQLLegIntermediateStopsArgs {
        private List<GraphQLStopType> include;

        public GraphQLLegIntermediateStopsArgs(Map<String, Object> args) {
            if (args != null && args.get("include") != null) {
                this.include = ((List)args.get("include")).stream().map(item -> item instanceof GraphQLStopType ? item : GraphQLStopType.valueOf((String)item)).map(GraphQLStopType.class::cast).collect(Collectors.toList());
            }
        }

        public List<GraphQLStopType> getGraphQLInclude() {
            return this.include;
        }

        public void setGraphQLInclude(List<GraphQLStopType> include) {
            this.include = include;
        }
    }

    public static enum GraphQLItineraryFilterDebugProfile {
        LIMIT_TO_NUMBER_OF_ITINERARIES,
        LIMIT_TO_SEARCH_WINDOW,
        LIST_ALL,
        OFF;

    }

    public static class GraphQLInputUnpreferredInput {
        private String agencies;
        private String routes;
        private String unpreferredCost;
        private Integer useUnpreferredRoutesPenalty;

        public GraphQLInputUnpreferredInput(Map<String, Object> args) {
            if (args != null) {
                this.agencies = (String)args.get("agencies");
                this.routes = (String)args.get("routes");
                this.unpreferredCost = (String)args.get("unpreferredCost");
                this.useUnpreferredRoutesPenalty = (Integer)args.get("useUnpreferredRoutesPenalty");
            }
        }

        public String getGraphQLAgencies() {
            return this.agencies;
        }

        public String getGraphQLRoutes() {
            return this.routes;
        }

        public String getGraphQLUnpreferredCost() {
            return this.unpreferredCost;
        }

        public Integer getGraphQLUseUnpreferredRoutesPenalty() {
            return this.useUnpreferredRoutesPenalty;
        }

        public void setGraphQLAgencies(String agencies) {
            this.agencies = agencies;
        }

        public void setGraphQLRoutes(String routes) {
            this.routes = routes;
        }

        public void setGraphQLUnpreferredCost(String unpreferredCost) {
            this.unpreferredCost = unpreferredCost;
        }

        public void setGraphQLUseUnpreferredRoutesPenalty(Integer useUnpreferredRoutesPenalty) {
            this.useUnpreferredRoutesPenalty = useUnpreferredRoutesPenalty;
        }
    }

    public static class GraphQLInputTriangleInput {
        private Double safetyFactor;
        private Double slopeFactor;
        private Double timeFactor;

        public GraphQLInputTriangleInput(Map<String, Object> args) {
            if (args != null) {
                this.safetyFactor = (Double)args.get("safetyFactor");
                this.slopeFactor = (Double)args.get("slopeFactor");
                this.timeFactor = (Double)args.get("timeFactor");
            }
        }

        public Double getGraphQLSafetyFactor() {
            return this.safetyFactor;
        }

        public Double getGraphQLSlopeFactor() {
            return this.slopeFactor;
        }

        public Double getGraphQLTimeFactor() {
            return this.timeFactor;
        }

        public void setGraphQLSafetyFactor(Double safetyFactor) {
            this.safetyFactor = safetyFactor;
        }

        public void setGraphQLSlopeFactor(Double slopeFactor) {
            this.slopeFactor = slopeFactor;
        }

        public void setGraphQLTimeFactor(Double timeFactor) {
            this.timeFactor = timeFactor;
        }
    }

    public static class GraphQLInputPreferredInput {
        private String agencies;
        private Integer otherThanPreferredRoutesPenalty;
        private String routes;

        public GraphQLInputPreferredInput(Map<String, Object> args) {
            if (args != null) {
                this.agencies = (String)args.get("agencies");
                this.otherThanPreferredRoutesPenalty = (Integer)args.get("otherThanPreferredRoutesPenalty");
                this.routes = (String)args.get("routes");
            }
        }

        public String getGraphQLAgencies() {
            return this.agencies;
        }

        public Integer getGraphQLOtherThanPreferredRoutesPenalty() {
            return this.otherThanPreferredRoutesPenalty;
        }

        public String getGraphQLRoutes() {
            return this.routes;
        }

        public void setGraphQLAgencies(String agencies) {
            this.agencies = agencies;
        }

        public void setGraphQLOtherThanPreferredRoutesPenalty(Integer otherThanPreferredRoutesPenalty) {
            this.otherThanPreferredRoutesPenalty = otherThanPreferredRoutesPenalty;
        }

        public void setGraphQLRoutes(String routes) {
            this.routes = routes;
        }
    }

    public static class GraphQLInputModeWeightInput {
        private Double AIRPLANE;
        private Double BUS;
        private Double CABLE_CAR;
        private Double CARPOOL;
        private Double COACH;
        private Double FERRY;
        private Double FUNICULAR;
        private Double GONDOLA;
        private Double MONORAIL;
        private Double RAIL;
        private Double SUBWAY;
        private Double TAXI;
        private Double TRAM;
        private Double TROLLEYBUS;

        public GraphQLInputModeWeightInput(Map<String, Object> args) {
            if (args != null) {
                this.AIRPLANE = (Double)args.get("AIRPLANE");
                this.BUS = (Double)args.get("BUS");
                this.CABLE_CAR = (Double)args.get("CABLE_CAR");
                this.CARPOOL = (Double)args.get("CARPOOL");
                this.COACH = (Double)args.get("COACH");
                this.FERRY = (Double)args.get("FERRY");
                this.FUNICULAR = (Double)args.get("FUNICULAR");
                this.GONDOLA = (Double)args.get("GONDOLA");
                this.MONORAIL = (Double)args.get("MONORAIL");
                this.RAIL = (Double)args.get("RAIL");
                this.SUBWAY = (Double)args.get("SUBWAY");
                this.TAXI = (Double)args.get("TAXI");
                this.TRAM = (Double)args.get("TRAM");
                this.TROLLEYBUS = (Double)args.get("TROLLEYBUS");
            }
        }

        public Double getGraphQLAirplane() {
            return this.AIRPLANE;
        }

        public Double getGraphQLBus() {
            return this.BUS;
        }

        public Double getGraphQLCable_Car() {
            return this.CABLE_CAR;
        }

        public Double getGraphQLCarpool() {
            return this.CARPOOL;
        }

        public Double getGraphQLCoach() {
            return this.COACH;
        }

        public Double getGraphQLFerry() {
            return this.FERRY;
        }

        public Double getGraphQLFunicular() {
            return this.FUNICULAR;
        }

        public Double getGraphQLGondola() {
            return this.GONDOLA;
        }

        public Double getGraphQLMonorail() {
            return this.MONORAIL;
        }

        public Double getGraphQLRail() {
            return this.RAIL;
        }

        public Double getGraphQLSubway() {
            return this.SUBWAY;
        }

        public Double getGraphQLTaxi() {
            return this.TAXI;
        }

        public Double getGraphQLTram() {
            return this.TRAM;
        }

        public Double getGraphQLTrolleybus() {
            return this.TROLLEYBUS;
        }

        public void setGraphQLAirplane(Double AIRPLANE) {
            this.AIRPLANE = AIRPLANE;
        }

        public void setGraphQLBus(Double BUS) {
            this.BUS = BUS;
        }

        public void setGraphQLCable_Car(Double CABLE_CAR) {
            this.CABLE_CAR = CABLE_CAR;
        }

        public void setGraphQLCarpool(Double CARPOOL) {
            this.CARPOOL = CARPOOL;
        }

        public void setGraphQLCoach(Double COACH) {
            this.COACH = COACH;
        }

        public void setGraphQLFerry(Double FERRY) {
            this.FERRY = FERRY;
        }

        public void setGraphQLFunicular(Double FUNICULAR) {
            this.FUNICULAR = FUNICULAR;
        }

        public void setGraphQLGondola(Double GONDOLA) {
            this.GONDOLA = GONDOLA;
        }

        public void setGraphQLMonorail(Double MONORAIL) {
            this.MONORAIL = MONORAIL;
        }

        public void setGraphQLRail(Double RAIL) {
            this.RAIL = RAIL;
        }

        public void setGraphQLSubway(Double SUBWAY) {
            this.SUBWAY = SUBWAY;
        }

        public void setGraphQLTaxi(Double TAXI) {
            this.TAXI = TAXI;
        }

        public void setGraphQLTram(Double TRAM) {
            this.TRAM = TRAM;
        }

        public void setGraphQLTrolleybus(Double TROLLEYBUS) {
            this.TROLLEYBUS = TROLLEYBUS;
        }
    }

    public static class GraphQLInputFiltersInput {
        private List<String> bikeParks;
        private List<String> bikeRentalStations;
        private List<String> carParks;
        private List<String> routes;
        private List<String> stations;
        private List<String> stops;

        public GraphQLInputFiltersInput(Map<String, Object> args) {
            if (args != null) {
                this.bikeParks = (List)args.get("bikeParks");
                this.bikeRentalStations = (List)args.get("bikeRentalStations");
                this.carParks = (List)args.get("carParks");
                this.routes = (List)args.get("routes");
                this.stations = (List)args.get("stations");
                this.stops = (List)args.get("stops");
            }
        }

        public List<String> getGraphQLBikeParks() {
            return this.bikeParks;
        }

        public List<String> getGraphQLBikeRentalStations() {
            return this.bikeRentalStations;
        }

        public List<String> getGraphQLCarParks() {
            return this.carParks;
        }

        public List<String> getGraphQLRoutes() {
            return this.routes;
        }

        public List<String> getGraphQLStations() {
            return this.stations;
        }

        public List<String> getGraphQLStops() {
            return this.stops;
        }

        public void setGraphQLBikeParks(List<String> bikeParks) {
            this.bikeParks = bikeParks;
        }

        public void setGraphQLBikeRentalStations(List<String> bikeRentalStations) {
            this.bikeRentalStations = bikeRentalStations;
        }

        public void setGraphQLCarParks(List<String> carParks) {
            this.carParks = carParks;
        }

        public void setGraphQLRoutes(List<String> routes) {
            this.routes = routes;
        }

        public void setGraphQLStations(List<String> stations) {
            this.stations = stations;
        }

        public void setGraphQLStops(List<String> stops) {
            this.stops = stops;
        }
    }

    public static enum GraphQLInputField {
        DATE_TIME,
        FROM,
        TO;

    }

    public static class GraphQLInputCoordinatesInput {
        private String address;
        private Double lat;
        private Integer locationSlack;
        private Double lon;

        public GraphQLInputCoordinatesInput(Map<String, Object> args) {
            if (args != null) {
                this.address = (String)args.get("address");
                this.lat = (Double)args.get("lat");
                this.locationSlack = (Integer)args.get("locationSlack");
                this.lon = (Double)args.get("lon");
            }
        }

        public String getGraphQLAddress() {
            return this.address;
        }

        public Double getGraphQLLat() {
            return this.lat;
        }

        public Integer getGraphQLLocationSlack() {
            return this.locationSlack;
        }

        public Double getGraphQLLon() {
            return this.lon;
        }

        public void setGraphQLAddress(String address) {
            this.address = address;
        }

        public void setGraphQLLat(Double lat) {
            this.lat = lat;
        }

        public void setGraphQLLocationSlack(Integer locationSlack) {
            this.locationSlack = locationSlack;
        }

        public void setGraphQLLon(Double lon) {
            this.lon = lon;
        }
    }

    public static class GraphQLInputBannedInput {
        private String agencies;
        private String routes;
        private String stops;
        private String stopsHard;
        private String trips;

        public GraphQLInputBannedInput(Map<String, Object> args) {
            if (args != null) {
                this.agencies = (String)args.get("agencies");
                this.routes = (String)args.get("routes");
                this.stops = (String)args.get("stops");
                this.stopsHard = (String)args.get("stopsHard");
                this.trips = (String)args.get("trips");
            }
        }

        public String getGraphQLAgencies() {
            return this.agencies;
        }

        public String getGraphQLRoutes() {
            return this.routes;
        }

        public String getGraphQLStops() {
            return this.stops;
        }

        public String getGraphQLStopsHard() {
            return this.stopsHard;
        }

        public String getGraphQLTrips() {
            return this.trips;
        }

        public void setGraphQLAgencies(String agencies) {
            this.agencies = agencies;
        }

        public void setGraphQLRoutes(String routes) {
            this.routes = routes;
        }

        public void setGraphQLStops(String stops) {
            this.stops = stops;
        }

        public void setGraphQLStopsHard(String stopsHard) {
            this.stopsHard = stopsHard;
        }

        public void setGraphQLTrips(String trips) {
            this.trips = trips;
        }
    }

    public static enum GraphQLFormFactor {
        BICYCLE,
        CAR,
        CARGO_BICYCLE,
        MOPED,
        OTHER,
        SCOOTER,
        SCOOTER_SEATED,
        SCOOTER_STANDING;

    }

    public static enum GraphQLFilterPlaceType {
        BICYCLE_RENT,
        BIKE_PARK,
        CAR_PARK,
        DEPARTURE_ROW,
        STATION,
        STOP,
        VEHICLE_RENT;

    }

    public static enum GraphQLFeedAlertType {
        AGENCIES,
        ROUTE_TYPES;

    }

    public static class GraphQLFeedAlertsArgs {
        private List<GraphQLFeedAlertType> types;

        public GraphQLFeedAlertsArgs(Map<String, Object> args) {
            if (args != null && args.get("types") != null) {
                this.types = ((List)args.get("types")).stream().map(item -> item instanceof GraphQLFeedAlertType ? item : GraphQLFeedAlertType.valueOf((String)item)).map(GraphQLFeedAlertType.class::cast).collect(Collectors.toList());
            }
        }

        public List<GraphQLFeedAlertType> getGraphQLTypes() {
            return this.types;
        }

        public void setGraphQLTypes(List<GraphQLFeedAlertType> types) {
            this.types = types;
        }
    }

    public static class GraphQLDestinationScooterPolicyInput {
        private Boolean allowKeeping;
        private Cost keepingCost;

        public GraphQLDestinationScooterPolicyInput(Map<String, Object> args) {
            if (args != null) {
                this.allowKeeping = (Boolean)args.get("allowKeeping");
                this.keepingCost = (Cost)args.get("keepingCost");
            }
        }

        public Boolean getGraphQLAllowKeeping() {
            return this.allowKeeping;
        }

        public Cost getGraphQLKeepingCost() {
            return this.keepingCost;
        }

        public void setGraphQLAllowKeeping(Boolean allowKeeping) {
            this.allowKeeping = allowKeeping;
        }

        public void setGraphQLKeepingCost(Cost keepingCost) {
            this.keepingCost = keepingCost;
        }
    }

    public static class GraphQLDestinationBicyclePolicyInput {
        private Boolean allowKeeping;
        private Cost keepingCost;

        public GraphQLDestinationBicyclePolicyInput(Map<String, Object> args) {
            if (args != null) {
                this.allowKeeping = (Boolean)args.get("allowKeeping");
                this.keepingCost = (Cost)args.get("keepingCost");
            }
        }

        public Boolean getGraphQLAllowKeeping() {
            return this.allowKeeping;
        }

        public Cost getGraphQLKeepingCost() {
            return this.keepingCost;
        }

        public void setGraphQLAllowKeeping(Boolean allowKeeping) {
            this.allowKeeping = allowKeeping;
        }

        public void setGraphQLKeepingCost(Cost keepingCost) {
            this.keepingCost = keepingCost;
        }
    }

    public static enum GraphQLDependentFareProductFilter {
        ALL,
        MATCH_CATEGORY_AND_MEDIUM;

    }

    public static class GraphQLDependentFareProductDependenciesArgs {
        private GraphQLDependentFareProductFilter filter;

        public GraphQLDependentFareProductDependenciesArgs(Map<String, Object> args) {
            if (args != null) {
                if (args.get("filter") instanceof GraphQLDependentFareProductFilter) {
                    this.filter = (GraphQLDependentFareProductFilter)((Object)args.get("filter"));
                } else if (args.get("filter") != null) {
                    this.filter = GraphQLDependentFareProductFilter.valueOf((String)args.get("filter"));
                }
            }
        }

        public GraphQLDependentFareProductFilter getGraphQLFilter() {
            return this.filter;
        }

        public void setGraphQLFilter(GraphQLDependentFareProductFilter filter) {
            this.filter = filter;
        }
    }

    public static class GraphQLDepartureRowStoptimesArgs {
        private Integer numberOfDepartures;
        private Boolean omitCanceled;
        private Boolean omitNonPickups;
        private Long startTime;
        private Integer timeRange;

        public GraphQLDepartureRowStoptimesArgs(Map<String, Object> args) {
            if (args != null) {
                this.numberOfDepartures = (Integer)args.get("numberOfDepartures");
                this.omitCanceled = (Boolean)args.get("omitCanceled");
                this.omitNonPickups = (Boolean)args.get("omitNonPickups");
                this.startTime = (Long)args.get("startTime");
                this.timeRange = (Integer)args.get("timeRange");
            }
        }

        public Integer getGraphQLNumberOfDepartures() {
            return this.numberOfDepartures;
        }

        public Boolean getGraphQLOmitCanceled() {
            return this.omitCanceled;
        }

        public Boolean getGraphQLOmitNonPickups() {
            return this.omitNonPickups;
        }

        public Long getGraphQLStartTime() {
            return this.startTime;
        }

        public Integer getGraphQLTimeRange() {
            return this.timeRange;
        }

        public void setGraphQLNumberOfDepartures(Integer numberOfDepartures) {
            this.numberOfDepartures = numberOfDepartures;
        }

        public void setGraphQLOmitCanceled(Boolean omitCanceled) {
            this.omitCanceled = omitCanceled;
        }

        public void setGraphQLOmitNonPickups(Boolean omitNonPickups) {
            this.omitNonPickups = omitNonPickups;
        }

        public void setGraphQLStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public void setGraphQLTimeRange(Integer timeRange) {
            this.timeRange = timeRange;
        }
    }

    public static enum GraphQLCyclingOptimizationType {
        FLAT_STREETS,
        SAFEST_STREETS,
        SAFE_STREETS,
        SHORTEST_DURATION;

    }

    public static class GraphQLCyclingOptimizationInput {
        private GraphQLTriangleCyclingFactorsInput triangle;
        private GraphQLCyclingOptimizationType type;

        public GraphQLCyclingOptimizationInput(Map<String, Object> args) {
            if (args != null) {
                this.triangle = new GraphQLTriangleCyclingFactorsInput((Map)args.get("triangle"));
                if (args.get("type") instanceof GraphQLCyclingOptimizationType) {
                    this.type = (GraphQLCyclingOptimizationType)((Object)args.get("type"));
                } else if (args.get("type") != null) {
                    this.type = GraphQLCyclingOptimizationType.valueOf((String)args.get("type"));
                }
            }
        }

        public GraphQLTriangleCyclingFactorsInput getGraphQLTriangle() {
            return this.triangle;
        }

        public GraphQLCyclingOptimizationType getGraphQLType() {
            return this.type;
        }

        public void setGraphQLTriangle(GraphQLTriangleCyclingFactorsInput triangle) {
            this.triangle = triangle;
        }

        public void setGraphQLType(GraphQLCyclingOptimizationType type) {
            this.type = type;
        }
    }

    public static class GraphQLCarRentalPreferencesInput {
        private List<String> allowedNetworks;
        private List<String> bannedNetworks;

        public GraphQLCarRentalPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.allowedNetworks = (List)args.get("allowedNetworks");
                this.bannedNetworks = (List)args.get("bannedNetworks");
            }
        }

        public List<String> getGraphQLAllowedNetworks() {
            return this.allowedNetworks;
        }

        public List<String> getGraphQLBannedNetworks() {
            return this.bannedNetworks;
        }

        public void setGraphQLAllowedNetworks(List<String> allowedNetworks) {
            this.allowedNetworks = allowedNetworks;
        }

        public void setGraphQLBannedNetworks(List<String> bannedNetworks) {
            this.bannedNetworks = bannedNetworks;
        }
    }

    public static class GraphQLCarPreferencesInput {
        private Cost boardCost;
        private GraphQLCarParkingPreferencesInput parking;
        private Double reluctance;
        private GraphQLCarRentalPreferencesInput rental;

        public GraphQLCarPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.boardCost = (Cost)args.get("boardCost");
                this.parking = new GraphQLCarParkingPreferencesInput((Map)args.get("parking"));
                this.reluctance = (Double)args.get("reluctance");
                this.rental = new GraphQLCarRentalPreferencesInput((Map)args.get("rental"));
            }
        }

        public Cost getGraphQLBoardCost() {
            return this.boardCost;
        }

        public GraphQLCarParkingPreferencesInput getGraphQLParking() {
            return this.parking;
        }

        public Double getGraphQLReluctance() {
            return this.reluctance;
        }

        public GraphQLCarRentalPreferencesInput getGraphQLRental() {
            return this.rental;
        }

        public void setGraphQLBoardCost(Cost boardCost) {
            this.boardCost = boardCost;
        }

        public void setGraphQLParking(GraphQLCarParkingPreferencesInput parking) {
            this.parking = parking;
        }

        public void setGraphQLReluctance(Double reluctance) {
            this.reluctance = reluctance;
        }

        public void setGraphQLRental(GraphQLCarRentalPreferencesInput rental) {
            this.rental = rental;
        }
    }

    public static class GraphQLCarParkingPreferencesInput {
        private List<GraphQLParkingFilterInput> filters;
        private List<GraphQLParkingFilterInput> preferred;
        private Cost unpreferredCost;

        public GraphQLCarParkingPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                if (args.get("filters") != null) {
                    this.filters = ((List)args.get("filters")).stream().map(o -> o == null ? null : new GraphQLParkingFilterInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                if (args.get("preferred") != null) {
                    this.preferred = ((List)args.get("preferred")).stream().map(o -> o == null ? null : new GraphQLParkingFilterInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                this.unpreferredCost = (Cost)args.get("unpreferredCost");
            }
        }

        public List<GraphQLParkingFilterInput> getGraphQLFilters() {
            return this.filters;
        }

        public List<GraphQLParkingFilterInput> getGraphQLPreferred() {
            return this.preferred;
        }

        public Cost getGraphQLUnpreferredCost() {
            return this.unpreferredCost;
        }

        public void setGraphQLFilters(List<GraphQLParkingFilterInput> filters) {
            this.filters = filters;
        }

        public void setGraphQLPreferred(List<GraphQLParkingFilterInput> preferred) {
            this.preferred = preferred;
        }

        public void setGraphQLUnpreferredCost(Cost unpreferredCost) {
            this.unpreferredCost = unpreferredCost;
        }
    }

    public static class GraphQLCarParkNameArgs {
        private String language;

        public GraphQLCarParkNameArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLBoardPreferencesInput {
        private Duration slack;
        private Double waitReluctance;

        public GraphQLBoardPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.slack = (Duration)args.get("slack");
                this.waitReluctance = (Double)args.get("waitReluctance");
            }
        }

        public Duration getGraphQLSlack() {
            return this.slack;
        }

        public Double getGraphQLWaitReluctance() {
            return this.waitReluctance;
        }

        public void setGraphQLSlack(Duration slack) {
            this.slack = slack;
        }

        public void setGraphQLWaitReluctance(Double waitReluctance) {
            this.waitReluctance = waitReluctance;
        }
    }

    public static enum GraphQLBikesAllowed {
        ALLOWED,
        NOT_ALLOWED,
        NO_INFORMATION;

    }

    public static class GraphQLBikeParkNameArgs {
        private String language;

        public GraphQLBikeParkNameArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLBicycleWalkPreferencesInput {
        private GraphQLBicycleWalkPreferencesCostInput cost;
        private Duration mountDismountTime;
        private Double speed;

        public GraphQLBicycleWalkPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.cost = new GraphQLBicycleWalkPreferencesCostInput((Map)args.get("cost"));
                this.mountDismountTime = (Duration)args.get("mountDismountTime");
                this.speed = (Double)args.get("speed");
            }
        }

        public GraphQLBicycleWalkPreferencesCostInput getGraphQLCost() {
            return this.cost;
        }

        public Duration getGraphQLMountDismountTime() {
            return this.mountDismountTime;
        }

        public Double getGraphQLSpeed() {
            return this.speed;
        }

        public void setGraphQLCost(GraphQLBicycleWalkPreferencesCostInput cost) {
            this.cost = cost;
        }

        public void setGraphQLMountDismountTime(Duration mountDismountTime) {
            this.mountDismountTime = mountDismountTime;
        }

        public void setGraphQLSpeed(Double speed) {
            this.speed = speed;
        }
    }

    public static class GraphQLBicycleWalkPreferencesCostInput {
        private Cost mountDismountCost;
        private Double reluctance;

        public GraphQLBicycleWalkPreferencesCostInput(Map<String, Object> args) {
            if (args != null) {
                this.mountDismountCost = (Cost)args.get("mountDismountCost");
                this.reluctance = (Double)args.get("reluctance");
            }
        }

        public Cost getGraphQLMountDismountCost() {
            return this.mountDismountCost;
        }

        public Double getGraphQLReluctance() {
            return this.reluctance;
        }

        public void setGraphQLMountDismountCost(Cost mountDismountCost) {
            this.mountDismountCost = mountDismountCost;
        }

        public void setGraphQLReluctance(Double reluctance) {
            this.reluctance = reluctance;
        }
    }

    public static class GraphQLBicycleRentalPreferencesInput {
        private List<String> allowedNetworks;
        private List<String> bannedNetworks;
        private GraphQLDestinationBicyclePolicyInput destinationBicyclePolicy;

        public GraphQLBicycleRentalPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.allowedNetworks = (List)args.get("allowedNetworks");
                this.bannedNetworks = (List)args.get("bannedNetworks");
                this.destinationBicyclePolicy = new GraphQLDestinationBicyclePolicyInput((Map)args.get("destinationBicyclePolicy"));
            }
        }

        public List<String> getGraphQLAllowedNetworks() {
            return this.allowedNetworks;
        }

        public List<String> getGraphQLBannedNetworks() {
            return this.bannedNetworks;
        }

        public GraphQLDestinationBicyclePolicyInput getGraphQLDestinationBicyclePolicy() {
            return this.destinationBicyclePolicy;
        }

        public void setGraphQLAllowedNetworks(List<String> allowedNetworks) {
            this.allowedNetworks = allowedNetworks;
        }

        public void setGraphQLBannedNetworks(List<String> bannedNetworks) {
            this.bannedNetworks = bannedNetworks;
        }

        public void setGraphQLDestinationBicyclePolicy(GraphQLDestinationBicyclePolicyInput destinationBicyclePolicy) {
            this.destinationBicyclePolicy = destinationBicyclePolicy;
        }
    }

    public static class GraphQLBicyclePreferencesInput {
        private Cost boardCost;
        private GraphQLCyclingOptimizationInput optimization;
        private GraphQLBicycleParkingPreferencesInput parking;
        private Double reluctance;
        private GraphQLBicycleRentalPreferencesInput rental;
        private Double speed;
        private GraphQLBicycleWalkPreferencesInput walk;

        public GraphQLBicyclePreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.boardCost = (Cost)args.get("boardCost");
                this.optimization = new GraphQLCyclingOptimizationInput((Map)args.get("optimization"));
                this.parking = new GraphQLBicycleParkingPreferencesInput((Map)args.get("parking"));
                this.reluctance = (Double)args.get("reluctance");
                this.rental = new GraphQLBicycleRentalPreferencesInput((Map)args.get("rental"));
                this.speed = (Double)args.get("speed");
                this.walk = new GraphQLBicycleWalkPreferencesInput((Map)args.get("walk"));
            }
        }

        public Cost getGraphQLBoardCost() {
            return this.boardCost;
        }

        public GraphQLCyclingOptimizationInput getGraphQLOptimization() {
            return this.optimization;
        }

        public GraphQLBicycleParkingPreferencesInput getGraphQLParking() {
            return this.parking;
        }

        public Double getGraphQLReluctance() {
            return this.reluctance;
        }

        public GraphQLBicycleRentalPreferencesInput getGraphQLRental() {
            return this.rental;
        }

        public Double getGraphQLSpeed() {
            return this.speed;
        }

        public GraphQLBicycleWalkPreferencesInput getGraphQLWalk() {
            return this.walk;
        }

        public void setGraphQLBoardCost(Cost boardCost) {
            this.boardCost = boardCost;
        }

        public void setGraphQLOptimization(GraphQLCyclingOptimizationInput optimization) {
            this.optimization = optimization;
        }

        public void setGraphQLParking(GraphQLBicycleParkingPreferencesInput parking) {
            this.parking = parking;
        }

        public void setGraphQLReluctance(Double reluctance) {
            this.reluctance = reluctance;
        }

        public void setGraphQLRental(GraphQLBicycleRentalPreferencesInput rental) {
            this.rental = rental;
        }

        public void setGraphQLSpeed(Double speed) {
            this.speed = speed;
        }

        public void setGraphQLWalk(GraphQLBicycleWalkPreferencesInput walk) {
            this.walk = walk;
        }
    }

    public static class GraphQLBicycleParkingPreferencesInput {
        private List<GraphQLParkingFilterInput> filters;
        private List<GraphQLParkingFilterInput> preferred;
        private Cost unpreferredCost;

        public GraphQLBicycleParkingPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                if (args.get("filters") != null) {
                    this.filters = ((List)args.get("filters")).stream().map(o -> o == null ? null : new GraphQLParkingFilterInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                if (args.get("preferred") != null) {
                    this.preferred = ((List)args.get("preferred")).stream().map(o -> o == null ? null : new GraphQLParkingFilterInput((Map<String, Object>)o)).collect(Collectors.toList());
                }
                this.unpreferredCost = (Cost)args.get("unpreferredCost");
            }
        }

        public List<GraphQLParkingFilterInput> getGraphQLFilters() {
            return this.filters;
        }

        public List<GraphQLParkingFilterInput> getGraphQLPreferred() {
            return this.preferred;
        }

        public Cost getGraphQLUnpreferredCost() {
            return this.unpreferredCost;
        }

        public void setGraphQLFilters(List<GraphQLParkingFilterInput> filters) {
            this.filters = filters;
        }

        public void setGraphQLPreferred(List<GraphQLParkingFilterInput> preferred) {
            this.preferred = preferred;
        }

        public void setGraphQLUnpreferredCost(Cost unpreferredCost) {
            this.unpreferredCost = unpreferredCost;
        }
    }

    public static class GraphQLAlightPreferencesInput {
        private Duration slack;

        public GraphQLAlightPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.slack = (Duration)args.get("slack");
            }
        }

        public Duration getGraphQLSlack() {
            return this.slack;
        }

        public void setGraphQLSlack(Duration slack) {
            this.slack = slack;
        }
    }

    public static enum GraphQLAlertSeverityLevelType {
        INFO,
        SEVERE,
        UNKNOWN_SEVERITY,
        WARNING;

    }

    public static enum GraphQLAlertEffectType {
        ACCESSIBILITY_ISSUE,
        ADDITIONAL_SERVICE,
        DETOUR,
        MODIFIED_SERVICE,
        NO_EFFECT,
        NO_SERVICE,
        OTHER_EFFECT,
        REDUCED_SERVICE,
        SIGNIFICANT_DELAYS,
        STOP_MOVED,
        UNKNOWN_EFFECT;

    }

    public static enum GraphQLAlertCauseType {
        ACCIDENT,
        CONSTRUCTION,
        DEMONSTRATION,
        HOLIDAY,
        MAINTENANCE,
        MEDICAL_EMERGENCY,
        OTHER_CAUSE,
        POLICE_ACTIVITY,
        STRIKE,
        TECHNICAL_PROBLEM,
        UNKNOWN_CAUSE,
        WEATHER;

    }

    public static class GraphQLAlertAlertUrlArgs {
        private String language;

        public GraphQLAlertAlertUrlArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLAlertAlertHeaderTextArgs {
        private String language;

        public GraphQLAlertAlertHeaderTextArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static class GraphQLAlertAlertDescriptionTextArgs {
        private String language;

        public GraphQLAlertAlertDescriptionTextArgs(Map<String, Object> args) {
            if (args != null) {
                this.language = (String)args.get("language");
            }
        }

        public String getGraphQLLanguage() {
            return this.language;
        }

        public void setGraphQLLanguage(String language) {
            this.language = language;
        }
    }

    public static enum GraphQLAgencyAlertType {
        AGENCY,
        ROUTES,
        ROUTE_TYPES;

    }

    public static class GraphQLAgencyAlertsArgs {
        private List<GraphQLAgencyAlertType> types;

        public GraphQLAgencyAlertsArgs(Map<String, Object> args) {
            if (args != null && args.get("types") != null) {
                this.types = ((List)args.get("types")).stream().map(item -> item instanceof GraphQLAgencyAlertType ? item : GraphQLAgencyAlertType.valueOf((String)item)).map(GraphQLAgencyAlertType.class::cast).collect(Collectors.toList());
            }
        }

        public List<GraphQLAgencyAlertType> getGraphQLTypes() {
            return this.types;
        }

        public void setGraphQLTypes(List<GraphQLAgencyAlertType> types) {
            this.types = types;
        }
    }

    public static class GraphQLAccessibilityPreferencesInput {
        private GraphQLWheelchairPreferencesInput wheelchair;

        public GraphQLAccessibilityPreferencesInput(Map<String, Object> args) {
            if (args != null) {
                this.wheelchair = new GraphQLWheelchairPreferencesInput((Map)args.get("wheelchair"));
            }
        }

        public GraphQLWheelchairPreferencesInput getGraphQLWheelchair() {
            return this.wheelchair;
        }

        public void setGraphQLWheelchair(GraphQLWheelchairPreferencesInput wheelchair) {
            this.wheelchair = wheelchair;
        }
    }

    public static enum GraphQLAbsoluteDirection {
        EAST,
        NORTH,
        NORTHEAST,
        NORTHWEST,
        SOUTH,
        SOUTHEAST,
        SOUTHWEST,
        WEST;

    }
}

