/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.DirectionMapper;
import org.opentripplanner.apis.gtfs.mapping.StreetNoteMapper;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.model.plan.leg.ElevationProfile;
import org.opentripplanner.model.plan.walkstep.WalkStep;
import org.opentripplanner.routing.alertpatch.TransitAlert;

public class stepImpl
implements GraphQLDataFetchers.GraphQLStep {
    @Override
    public DataFetcher<GraphQLTypes.GraphQLAbsoluteDirection> absoluteDirection() {
        return environment -> this.getSource(environment).getAbsoluteDirection().map(DirectionMapper::map).orElse(null);
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> this.getSource(environment).getStreetNotes().stream().map(StreetNoteMapper::mapStreetNoteToAlert).toList();
    }

    @Override
    public DataFetcher<Boolean> area() {
        return environment -> this.getSource(environment).getArea();
    }

    @Override
    public DataFetcher<Boolean> bogusName() {
        return environment -> this.getSource(environment).nameIsDerived();
    }

    @Override
    public DataFetcher<Double> distance() {
        return environment -> this.getSource(environment).getDistance();
    }

    @Override
    public DataFetcher<Iterable<ElevationProfile.Step>> elevationProfile() {
        return environment -> this.getSource(environment).getElevationProfile().steps();
    }

    @Override
    public DataFetcher<String> exit() {
        return environment -> this.getSource(environment).highwayExit().orElse(null);
    }

    @Override
    public DataFetcher<Object> feature() {
        return environment -> this.getSource(environment).entrance().orElse(null);
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).getStartLocation().latitude();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).getStartLocation().longitude();
    }

    @Override
    public DataFetcher<GraphQLTypes.GraphQLRelativeDirection> relativeDirection() {
        return environment -> DirectionMapper.map(this.getSource(environment).getRelativeDirection());
    }

    @Override
    public DataFetcher<Boolean> stayOn() {
        return environment -> this.getSource(environment).isStayOn();
    }

    @Override
    public DataFetcher<String> streetName() {
        return environment -> this.getSource(environment).getDirectionText().toString(GraphQLUtils.getLocale(environment));
    }

    @Override
    public DataFetcher<Boolean> walkingBike() {
        return environment -> this.getSource(environment).isWalkingBike();
    }

    private WalkStep getSource(DataFetchingEnvironment environment) {
        return (WalkStep)environment.getSource();
    }
}

