/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.service.realtimevehicles.model.RealtimeVehicle;
import org.opentripplanner.transit.model.timetable.Trip;

public class VehiclePositionImpl
implements GraphQLDataFetchers.GraphQLVehiclePosition {
    @Override
    public DataFetcher<Double> heading() {
        return env -> this.getSource(env).heading().orElse(null);
    }

    @Override
    public DataFetcher<String> label() {
        return env -> this.getSource(env).label().orElse(null);
    }

    @Override
    public DataFetcher<OffsetDateTime> lastUpdate() {
        return env -> {
            ZoneId zoneId = ((GraphQLRequestContext)env.getContext()).transitService().getTimeZone();
            return this.getSource(env).time().map(time -> OffsetDateTime.ofInstant(time, zoneId)).orElse(null);
        };
    }

    @Override
    public DataFetcher<Long> lastUpdated() {
        return env -> this.getSource(env).time().map(time -> time.getEpochSecond()).orElse(null);
    }

    @Override
    public DataFetcher<Double> lat() {
        return env -> this.getSource(env).coordinates().map(coordinates -> coordinates.latitude()).orElse(null);
    }

    @Override
    public DataFetcher<Double> lon() {
        return env -> this.getSource(env).coordinates().map(coordinates -> coordinates.longitude()).orElse(null);
    }

    @Override
    public DataFetcher<Double> speed() {
        return env -> this.getSource(env).speed().orElse(null);
    }

    @Override
    public DataFetcher<RealtimeVehicle.StopRelationship> stopRelationship() {
        return env -> this.getSource(env).stop().orElse(null);
    }

    @Override
    public DataFetcher<Trip> trip() {
        return env -> this.getSource(env).trip();
    }

    @Override
    public DataFetcher<String> vehicleId() {
        return env -> this.getSource(env).vehicleId().map(vehicleId -> vehicleId.toString()).orElse(null);
    }

    private RealtimeVehicle getSource(DataFetchingEnvironment environment) {
        return (RealtimeVehicle)environment.getSource();
    }
}

