/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.apis.gtfs.GraphQLUtils;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.PickDropMapper;
import org.opentripplanner.apis.gtfs.mapping.RealtimeStateMapper;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.transit.model.timetable.Trip;

public class StoptimeImpl
implements GraphQLDataFetchers.GraphQLStoptime {
    @Override
    public DataFetcher<Integer> arrivalDelay() {
        return environment -> GraphQLUtils.stopTimeToInt(this.getSource(environment).getArrivalDelay());
    }

    @Override
    public DataFetcher<Integer> departureDelay() {
        return environment -> this.getSource(environment).getDepartureDelay();
    }

    @Override
    public DataFetcher<GraphQLTypes.GraphQLPickupDropoffType> dropoffType() {
        return environment -> PickDropMapper.map(this.getSource(environment).getDropoffType());
    }

    @Override
    public DataFetcher<String> headsign() {
        return environment -> org.opentripplanner.framework.graphql.GraphQLUtils.getTranslation(this.getSource(environment).getHeadsign(), environment);
    }

    @Override
    public DataFetcher<GraphQLTypes.GraphQLPickupDropoffType> pickupType() {
        return environment -> PickDropMapper.map(this.getSource(environment).getPickupType());
    }

    @Override
    public DataFetcher<Boolean> realtime() {
        return environment -> this.getSource(environment).isRealtime();
    }

    @Override
    public DataFetcher<Integer> realtimeArrival() {
        return environment -> GraphQLUtils.stopTimeToInt(this.getSource(environment).getRealtimeArrival());
    }

    @Override
    public DataFetcher<Integer> realtimeDeparture() {
        return environment -> GraphQLUtils.stopTimeToInt(this.getSource(environment).getRealtimeDeparture());
    }

    @Override
    public DataFetcher<GraphQLTypes.GraphQLRealtimeState> realtimeState() {
        return environment -> this.getSource(environment).isCanceledEffectively() ? GraphQLTypes.GraphQLRealtimeState.CANCELED : RealtimeStateMapper.map(this.getSource(environment).getRealTimeState());
    }

    @Override
    public DataFetcher<Integer> scheduledArrival() {
        return environment -> GraphQLUtils.stopTimeToInt(this.getSource(environment).getScheduledArrival());
    }

    @Override
    public DataFetcher<Integer> scheduledDeparture() {
        return environment -> GraphQLUtils.stopTimeToInt(this.getSource(environment).getScheduledDeparture());
    }

    @Override
    public DataFetcher<Integer> stopPosition() {
        return environment -> this.getSource(environment).getGtfsSequence();
    }

    @Override
    public DataFetcher<Integer> stopPositionInPattern() {
        return environment -> this.getSource(environment).getStopIndex();
    }

    @Override
    public DataFetcher<Long> serviceDay() {
        return environment -> this.getSource(environment).getServiceDayMidnight();
    }

    @Override
    public DataFetcher<Object> stop() {
        return environment -> this.getSource(environment).getStop();
    }

    @Override
    public DataFetcher<Boolean> timepoint() {
        return environment -> this.getSource(environment).isTimepoint();
    }

    @Override
    public DataFetcher<Trip> trip() {
        return environment -> this.getSource(environment).getTrip();
    }

    private TripTimeOnDate getSource(DataFetchingEnvironment environment) {
        return (TripTimeOnDate)environment.getSource();
    }
}

