/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.GraphQLUtils;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.service.ApiTransitService;
import org.opentripplanner.apis.gtfs.support.filter.PatternByDateFilterUtil;
import org.opentripplanner.apis.gtfs.support.time.LocalDateRangeUtil;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.service.ArrivalDeparture;
import org.opentripplanner.transit.service.PatternByServiceDatesFilter;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.collection.CollectionUtils;
import org.opentripplanner.utils.time.ServiceDateUtils;

public class StopImpl
implements GraphQLDataFetchers.GraphQLStop {
    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getTransitService(environment).getTransitAlertService();
            GraphQLTypes.GraphQLStopAlertsArgs args = new GraphQLTypes.GraphQLStopAlertsArgs(environment.getArguments());
            List<GraphQLTypes.GraphQLStopAlertType> types = args.getGraphQLTypes();
            FeedScopedId id = StopImpl.getValue(environment, StopLocation::getId, AbstractTransitEntity::getId);
            if (types != null) {
                Collection<Route> routes;
                Collection<TripPattern> patterns;
                ArrayList<TransitAlert> alerts = new ArrayList<TransitAlert>();
                if (types.contains((Object)GraphQLTypes.GraphQLStopAlertType.STOP)) {
                    alerts.addAll(alertService.getStopAlerts(id));
                }
                if (types.contains((Object)GraphQLTypes.GraphQLStopAlertType.STOP_ON_ROUTES) || types.contains((Object)GraphQLTypes.GraphQLStopAlertType.STOP_ON_TRIPS)) {
                    alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.entities().stream().anyMatch(entity -> {
                        EntitySelector.StopAndTrip stopAndTrip;
                        EntitySelector.StopAndRoute stopAndRoute;
                        return types.contains((Object)GraphQLTypes.GraphQLStopAlertType.STOP_ON_ROUTES) && entity instanceof EntitySelector.StopAndRoute && (stopAndRoute = (EntitySelector.StopAndRoute)entity).stopId().equals(id) || types.contains((Object)GraphQLTypes.GraphQLStopAlertType.STOP_ON_TRIPS) && entity instanceof EntitySelector.StopAndTrip && (stopAndTrip = (EntitySelector.StopAndTrip)entity).stopId().equals(id);
                    })).toList());
                }
                if ((types.contains((Object)GraphQLTypes.GraphQLStopAlertType.PATTERNS) || types.contains((Object)GraphQLTypes.GraphQLStopAlertType.TRIPS)) && (patterns = this.getPatterns(environment)) != null) {
                    patterns.forEach(pattern -> {
                        if (types.contains((Object)GraphQLTypes.GraphQLStopAlertType.PATTERNS)) {
                            alerts.addAll(alertService.getDirectionAndRouteAlerts(pattern.getDirection(), pattern.getRoute().getId()));
                        }
                        if (types.contains((Object)GraphQLTypes.GraphQLStopAlertType.TRIPS)) {
                            pattern.scheduledTripsAsStream().forEach(trip -> alerts.addAll(alertService.getTripAlerts(trip.getId())));
                        }
                    });
                }
                if ((types.contains((Object)GraphQLTypes.GraphQLStopAlertType.ROUTES) || types.contains((Object)GraphQLTypes.GraphQLStopAlertType.AGENCIES_OF_ROUTES)) && (routes = this.getRoutes(environment)) != null) {
                    routes.forEach(route -> {
                        if (types.contains((Object)GraphQLTypes.GraphQLStopAlertType.ROUTES)) {
                            alerts.addAll(alertService.getRouteAlerts(route.getId()));
                        }
                        if (types.contains((Object)GraphQLTypes.GraphQLStopAlertType.AGENCIES_OF_ROUTES)) {
                            alerts.addAll(alertService.getAgencyAlerts(route.getAgency().getId()));
                        }
                    });
                }
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return alertService.getStopAlerts(id);
        };
    }

    @Override
    @Deprecated
    public DataFetcher<Object> cluster() {
        return environment -> null;
    }

    @Override
    public DataFetcher<String> code() {
        return environment -> StopImpl.getValue(environment, StopLocation::getCode, Station::getCode);
    }

    @Override
    public DataFetcher<String> desc() {
        return environment -> StopImpl.getValue(environment, stop -> org.opentripplanner.framework.graphql.GraphQLUtils.getTranslation(stop.getDescription(), environment), station -> org.opentripplanner.framework.graphql.GraphQLUtils.getTranslation(station.getDescription(), environment));
    }

    @Override
    public DataFetcher<String> url() {
        return environment -> StopImpl.getValue(environment, stop -> org.opentripplanner.framework.graphql.GraphQLUtils.getTranslation(stop.getUrl(), environment), station -> org.opentripplanner.framework.graphql.GraphQLUtils.getTranslation(station.getUrl(), environment));
    }

    @Override
    public DataFetcher<Object> locationType() {
        return environment -> StopImpl.getValue(environment, stop -> "STOP", station -> "STATION");
    }

    @Override
    public DataFetcher<Object> parentStation() {
        return environment -> StopImpl.getValue(environment, StopLocation::getParentStation, station -> null);
    }

    @Override
    public DataFetcher<String> direction() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Object> geometries() {
        return environment -> StopImpl.getValue(environment, StopLocation::getGeometry, Station::getGeometry);
    }

    @Override
    public DataFetcher<String> gtfsId() {
        return environment -> StopImpl.getValue(environment, stop -> stop.getId().toString(), station -> station.getId().toString());
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> StopImpl.getValue(environment, stop -> new Relay.ResolvedGlobalId("Stop", stop.getId().toString()), station -> new Relay.ResolvedGlobalId("Stop", station.getId().toString()));
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> StopImpl.getValue(environment, StopLocation::getLat, Station::getLat);
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> StopImpl.getValue(environment, StopLocation::getLon, Station::getLon);
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> StopImpl.getValue(environment, stop -> org.opentripplanner.framework.graphql.GraphQLUtils.getTranslation(stop.getName(), environment), station -> org.opentripplanner.framework.graphql.GraphQLUtils.getTranslation(station.getName(), environment));
    }

    @Override
    public DataFetcher<Iterable<TripPattern>> patterns() {
        return this::getPatterns;
    }

    @Override
    public DataFetcher<String> platformCode() {
        return environment -> StopImpl.getValue(environment, StopLocation::getPlatformCode, station -> null);
    }

    @Override
    public DataFetcher<Iterable<Route>> routes() {
        return env -> {
            GraphQLTypes.GraphQLStopRoutesArgs args = new GraphQLTypes.GraphQLStopRoutesArgs(env.getArguments());
            Collection<Route> routes = this.getRoutes(env);
            if (LocalDateRangeUtil.hasServiceDateFilter(args.getGraphQLServiceDates()) && !CollectionUtils.isEmpty(routes)) {
                PatternByServiceDatesFilter filter = PatternByDateFilterUtil.ofGraphQL(args.getGraphQLServiceDates(), this.getTransitService(env));
                return filter.filterRoutes(routes);
            }
            return routes;
        };
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> stopTimesForPattern() {
        return environment -> StopImpl.getValue(environment, stop -> {
            GraphQLTypes.GraphQLStopStopTimesForPatternArgs args;
            TransitService transitService = this.getTransitService(environment);
            TripPattern pattern = transitService.getTripPattern(FeedScopedId.parse((args = new GraphQLTypes.GraphQLStopStopTimesForPatternArgs(environment.getArguments())).getGraphQLId()));
            if (pattern == null) {
                return null;
            }
            ArrivalDeparture arrivalDeparture = args.getGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH;
            Instant time = GraphQLUtils.getTimeOrNow(args.getGraphQLStartTime());
            Duration timeRange = Duration.ofSeconds(args.getGraphQLTimeRange().intValue());
            if (transitService.hasNewTripPatternsForModifiedTrips()) {
                ApiTransitService service = new ApiTransitService(transitService);
                return service.getTripTimeOnDatesForPatternAtStopIncludingTripsWithSkippedStops((StopLocation)stop, pattern, time, timeRange, args.getGraphQLNumberOfDepartures(), arrivalDeparture);
            }
            return transitService.findTripTimesOnDate((StopLocation)stop, pattern, time, timeRange, args.getGraphQLNumberOfDepartures(), arrivalDeparture, args.getGraphQLOmitCanceled() == false);
        }, station -> null);
    }

    @Override
    public DataFetcher<Iterable<Object>> stops() {
        return environment -> StopImpl.getValue(environment, stop -> null, station -> new ArrayList<StopLocation>(station.getChildStops()));
    }

    @Override
    public DataFetcher<Iterable<StopTimesInPattern>> stoptimesForPatterns() {
        return environment -> {
            TransitService transitService = this.getTransitService(environment);
            GraphQLTypes.GraphQLStopStoptimesForPatternsArgs args = new GraphQLTypes.GraphQLStopStoptimesForPatternsArgs(environment.getArguments());
            Function<StopLocation, List> stopTFunction = stop -> transitService.findStopTimesInPattern((StopLocation)stop, GraphQLUtils.getTimeOrNow(args.getGraphQLStartTime()), Duration.ofSeconds(args.getGraphQLTimeRange().intValue()), args.getGraphQLNumberOfDepartures(), args.getGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, args.getGraphQLOmitCanceled() == false);
            return StopImpl.getValue(environment, stopTFunction, station -> station.getChildStops().stream().map(stopTFunction).flatMap(Collection::stream).collect(Collectors.toList()));
        };
    }

    @Override
    public DataFetcher<Iterable<StopTimesInPattern>> stoptimesForServiceDate() {
        return environment -> {
            LocalDate date;
            TransitService transitService = this.getTransitService(environment);
            GraphQLTypes.GraphQLStopStoptimesForServiceDateArgs args = new GraphQLTypes.GraphQLStopStoptimesForServiceDateArgs(environment.getArguments());
            try {
                date = ServiceDateUtils.parseString((String)args.getGraphQLDate());
            }
            catch (ParseException e) {
                return null;
            }
            Function<StopLocation, List> stopTFunction = stop -> transitService.findStopTimesInPattern((StopLocation)stop, date, args.getGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, args.getGraphQLOmitCanceled() == false);
            return StopImpl.getValue(environment, stopTFunction, station -> station.getChildStops().stream().map(stopTFunction).flatMap(Collection::stream).collect(Collectors.toList()));
        };
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> stoptimesWithoutPatterns() {
        return environment -> {
            TransitService transitService = this.getTransitService(environment);
            GraphQLTypes.GraphQLStopStoptimesForPatternsArgs args = new GraphQLTypes.GraphQLStopStoptimesForPatternsArgs(environment.getArguments());
            Function<StopLocation, Stream> stopTFunction = stop -> transitService.findStopTimesInPattern((StopLocation)stop, GraphQLUtils.getTimeOrNow(args.getGraphQLStartTime()), Duration.ofSeconds(args.getGraphQLTimeRange().intValue()), args.getGraphQLNumberOfDepartures(), args.getGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, args.getGraphQLOmitCanceled() == false).stream();
            Stream stream = StopImpl.getValue(environment, stopTFunction, station -> station.getChildStops().stream().flatMap(stopTFunction));
            return stream.flatMap(stoptimesWithPattern -> stoptimesWithPattern.times.stream()).sorted(Comparator.comparing(t -> t.getServiceDayMidnight() + (long)t.getRealtimeDeparture())).limit(args.getGraphQLNumberOfDepartures().intValue()).collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<String> timezone() {
        return environment -> StopImpl.getValue(environment, stop -> stop.getTimeZone().toString(), station -> station.getTimezone().toString());
    }

    @Override
    public DataFetcher<Iterable<NearbyStop>> transfers() {
        return environment -> StopImpl.getValue(environment, stop -> {
            Integer maxDistance = new GraphQLTypes.GraphQLStopTransfersArgs(environment.getArguments()).getGraphQLMaxDistance();
            return this.getTransitService(environment).findPathTransfers((StopLocation)stop).stream().filter(transfer -> maxDistance == null || transfer.getDistanceMeters() < (double)maxDistance.intValue()).filter(transfer -> transfer.to instanceof RegularStop).map(transfer -> new NearbyStop(transfer.to, transfer.getDistanceMeters(), transfer.getEdges(), null)).collect(Collectors.toList());
        }, station -> null);
    }

    @Override
    public DataFetcher<String> vehicleMode() {
        return environment -> {
            TransitService transitService = this.getTransitService(environment);
            return StopImpl.getValue(environment, stop -> transitService.findTransitModes((StopLocation)stop).stream().findFirst().map(Enum::toString).orElse(null), station -> transitService.findTransitModes((StopLocationsGroup)station).stream().findFirst().map(Enum::toString).orElse(null));
        };
    }

    @Override
    @Deprecated
    public DataFetcher<Integer> vehicleType() {
        return environment -> null;
    }

    @Override
    public DataFetcher<GraphQLTypes.GraphQLWheelchairBoarding> wheelchairBoarding() {
        return environment -> {
            Accessibility boarding = StopImpl.getValue(environment, StopLocation::getWheelchairAccessibility, station -> null);
            return GraphQLUtils.toGraphQL(boarding);
        };
    }

    @Override
    public DataFetcher<String> zoneId() {
        return environment -> StopImpl.getValue(environment, StopLocation::getFirstZoneAsString, station -> null);
    }

    @Nullable
    private Collection<TripPattern> getPatterns(DataFetchingEnvironment environment) {
        return StopImpl.getValue(environment, stop -> this.getTransitService(environment).findPatterns((StopLocation)stop, true), station -> null);
    }

    @Nullable
    private Collection<Route> getRoutes(DataFetchingEnvironment environment) {
        return StopImpl.getValue(environment, stop -> this.getTransitService(environment).findRoutes((StopLocation)stop), station -> null);
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((GraphQLRequestContext)environment.getContext()).transitService();
    }

    private static <T> T getValue(DataFetchingEnvironment environment, Function<StopLocation, T> stopTFunction, Function<Station, T> stationTFunction) {
        Object source = environment.getSource();
        if (source instanceof StopLocation) {
            return stopTFunction.apply((StopLocation)source);
        }
        if (source instanceof Station) {
            return stationTFunction.apply((Station)source);
        }
        return null;
    }
}

