/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.GraphQLUtils;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.model.CallRealTime;
import org.opentripplanner.apis.gtfs.model.CallSchedule;
import org.opentripplanner.apis.gtfs.model.CallScheduledTime;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.transit.model.timetable.EstimatedTime;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.time.ServiceDateUtils;

public class StopCallImpl
implements GraphQLDataFetchers.GraphQLStopCall {
    @Override
    public DataFetcher<CallRealTime> realTime() {
        return environment -> {
            TripTimeOnDate tripTime = this.getSource(environment);
            if (!tripTime.isRealtime()) {
                return null;
            }
            ZonedDateTime scheduledArrival = this.getZonedDateTime(environment, tripTime.getScheduledArrival());
            EstimatedTime estimatedArrival = scheduledArrival == null ? null : EstimatedTime.of(scheduledArrival, tripTime.getArrivalDelay());
            ZonedDateTime scheduledDeparture = this.getZonedDateTime(environment, tripTime.getScheduledDeparture());
            EstimatedTime estimatedDeparture = scheduledDeparture == null ? null : EstimatedTime.of(scheduledDeparture, tripTime.getDepartureDelay());
            return new CallRealTime(estimatedArrival, estimatedDeparture);
        };
    }

    @Override
    public DataFetcher<CallSchedule> schedule() {
        return environment -> {
            TripTimeOnDate tripTime = this.getSource(environment);
            if (tripTime.hasScheduledTimes()) {
                ZonedDateTime scheduledArrival = this.getZonedDateTime(environment, tripTime.getScheduledArrival());
                ZonedDateTime scheduledDeparture = this.getZonedDateTime(environment, tripTime.getScheduledDeparture());
                return new CallSchedule(new CallScheduledTime.ArrivalDepartureTime(scheduledArrival, scheduledDeparture));
            }
            TransitService transitService = this.getTransitService(environment);
            FlexTrip<?, ?> flexTrip = transitService.getFlexIndex().getTripById(tripTime.getTrip().getId());
            if (flexTrip == null) {
                return null;
            }
            int startSecs = flexTrip.earliestDepartureTime(tripTime.getStopIndex());
            int endSecs = flexTrip.latestArrivalTime(tripTime.getStopIndex());
            LocalDate serviceDay = tripTime.getServiceDay();
            ZoneId timeZone = transitService.getTimeZone();
            OffsetDateTime start = ServiceDateUtils.toOffsetDateTime((LocalDate)serviceDay, (ZoneId)timeZone, (int)startSecs);
            OffsetDateTime end = ServiceDateUtils.toOffsetDateTime((LocalDate)serviceDay, (ZoneId)timeZone, (int)endSecs);
            return new CallSchedule(new CallScheduledTime.TimeWindow(start, end));
        };
    }

    @Override
    public DataFetcher<Object> stopLocation() {
        return environment -> this.getSource(environment).getStop();
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((GraphQLRequestContext)environment.getContext()).transitService();
    }

    private ZonedDateTime getZonedDateTime(DataFetchingEnvironment environment, int time) {
        Integer fixedTime = GraphQLUtils.stopTimeToInt(time);
        if (fixedTime == null) {
            return null;
        }
        LocalDate serviceDate = this.getSource(environment).getServiceDay();
        TransitService transitService = this.getTransitService(environment);
        return ServiceDateUtils.toZonedDateTime((LocalDate)serviceDate, (ZoneId)transitService.getTimeZone(), (int)fixedTime);
    }

    private TripTimeOnDate getSource(DataFetchingEnvironment environment) {
        return (TripTimeOnDate)environment.getSource();
    }
}

