/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.stream.Collectors;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.model.RouteTypeModel;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.service.TransitService;

public class RouteTypeImpl
implements GraphQLDataFetchers.GraphQLRouteType {
    @Override
    public DataFetcher<Agency> agency() {
        return environment -> this.getSource(environment).getAgency();
    }

    @Override
    public DataFetcher<Integer> routeType() {
        return environment -> this.getSource(environment).getRouteType();
    }

    @Override
    public DataFetcher<Iterable<Route>> routes() {
        return environment -> {
            Agency agency = this.getSource(environment).getAgency();
            return this.getTransitService(environment).listRoutes().stream().filter(route -> route.getId().getFeedId().equals(this.getSource(environment).getFeedId()) && route.getGtfsType().intValue() == this.getSource(environment).getRouteType() && (agency == null || route.getAgency().equals(agency))).collect(Collectors.toList());
        };
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((GraphQLRequestContext)environment.getContext()).transitService();
    }

    private RouteTypeModel getSource(DataFetchingEnvironment environment) {
        return (RouteTypeModel)environment.getSource();
    }
}

