/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.BikesAllowedMapper;
import org.opentripplanner.apis.gtfs.mapping.TransitModeMapper;
import org.opentripplanner.apis.gtfs.support.filter.PatternByDateFilterUtil;
import org.opentripplanner.apis.gtfs.support.time.LocalDateRangeUtil;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.PatternByServiceDatesFilter;
import org.opentripplanner.transit.service.TransitService;

public class RouteImpl
implements GraphQLDataFetchers.GraphQLRoute {
    @Override
    public DataFetcher<Agency> agency() {
        return environment -> this.getSource(environment).getAgency();
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getAlertService(environment);
            GraphQLTypes.GraphQLRouteAlertsArgs args = new GraphQLTypes.GraphQLRouteAlertsArgs(environment.getArguments());
            List<GraphQLTypes.GraphQLRouteAlertType> types = args.getGraphQLTypes();
            if (types != null) {
                ArrayList alerts = new ArrayList();
                types.forEach(type -> {
                    switch (type) {
                        case ROUTE: {
                            alerts.addAll(alertService.getRouteAlerts(this.getSource(environment).getId()));
                            break;
                        }
                        case ROUTE_TYPE: {
                            alerts.addAll(alertService.getRouteTypeAlerts(this.getSource(environment).getGtfsType(), this.getSource(environment).getId().getFeedId()));
                            alerts.addAll(alertService.getRouteTypeAndAgencyAlerts(this.getSource(environment).getGtfsType(), this.getSource(environment).getAgency().getId()));
                            break;
                        }
                        case AGENCY: {
                            alerts.addAll(alertService.getAgencyAlerts(this.getSource(environment).getAgency().getId()));
                            break;
                        }
                        case TRIPS: {
                            this.getTrips(environment).forEach(trip -> alerts.addAll(alertService.getTripAlerts(trip.getId())));
                            break;
                        }
                        case STOPS_ON_ROUTE: {
                            alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.entities().stream().anyMatch(entity -> {
                                EntitySelector.StopAndRoute stopAndRoute;
                                return entity instanceof EntitySelector.StopAndRoute && (stopAndRoute = (EntitySelector.StopAndRoute)entity).routeId().equals(this.getSource(environment).getId());
                            })).toList());
                            this.getStops(environment).forEach(stop -> alerts.addAll(alertService.getStopAlerts(((StopLocation)stop).getId())));
                            break;
                        }
                        case STOPS_ON_TRIPS: {
                            Iterable<Trip> trips = this.getTrips(environment);
                            trips.forEach(trip -> alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.entities().stream().anyMatch(entity -> {
                                EntitySelector.StopAndTrip stopAndTrip;
                                return entity instanceof EntitySelector.StopAndTrip && (stopAndTrip = (EntitySelector.StopAndTrip)entity).tripId().equals(trip.getId());
                            })).toList()));
                            break;
                        }
                        case PATTERNS: {
                            alerts.addAll(alertService.getDirectionAndRouteAlerts(Direction.INBOUND, this.getSource(environment).getId()));
                            alerts.addAll(alertService.getDirectionAndRouteAlerts(Direction.OUTBOUND, this.getSource(environment).getId()));
                        }
                    }
                });
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return this.getAlertService(environment).getRouteAlerts(this.getSource(environment).getId());
        };
    }

    @Override
    public DataFetcher<GraphQLTypes.GraphQLBikesAllowed> bikesAllowed() {
        return environment -> BikesAllowedMapper.map(this.getSource(environment).getBikesAllowed());
    }

    @Override
    public DataFetcher<String> color() {
        return environment -> this.getSource(environment).getColor();
    }

    @Override
    public DataFetcher<String> desc() {
        return environment -> this.getSource(environment).getDescription();
    }

    @Override
    public DataFetcher<String> gtfsId() {
        return environment -> this.getSource(environment).getId().toString();
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("Route", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<String> longName() {
        return environment -> GraphQLUtils.getTranslation(this.getSource(environment).getLongName(), environment);
    }

    @Override
    public DataFetcher<GraphQLTypes.GraphQLTransitMode> mode() {
        return environment -> TransitModeMapper.map(this.getSource(environment).getMode());
    }

    @Override
    public DataFetcher<Iterable<TripPattern>> patterns() {
        return environment -> {
            TransitService transitService = this.getTransitService(environment);
            Collection<TripPattern> patterns = transitService.findPatterns(this.getSource(environment));
            GraphQLTypes.GraphQLRoutePatternsArgs args = new GraphQLTypes.GraphQLRoutePatternsArgs(environment.getArguments());
            if (LocalDateRangeUtil.hasServiceDateFilter(args.getGraphQLServiceDates())) {
                PatternByServiceDatesFilter filter = PatternByDateFilterUtil.ofGraphQL(args.getGraphQLServiceDates(), transitService);
                return filter.filterPatterns(patterns);
            }
            return patterns;
        };
    }

    @Override
    public DataFetcher<String> shortName() {
        return environment -> this.getSource(environment).getShortName();
    }

    @Override
    public DataFetcher<Integer> sortOrder() {
        return env -> this.getSource(env).getGtfsSortOrder();
    }

    @Override
    public DataFetcher<Iterable<Object>> stops() {
        return this::getStops;
    }

    @Override
    public DataFetcher<String> textColor() {
        return environment -> this.getSource(environment).getTextColor();
    }

    @Override
    public DataFetcher<Iterable<Trip>> trips() {
        return this::getTrips;
    }

    @Override
    public DataFetcher<Integer> type() {
        return environment -> this.getSource(environment).getGtfsType();
    }

    @Override
    public DataFetcher<String> url() {
        return environment -> this.getSource(environment).getUrl();
    }

    private Iterable<Object> getStops(DataFetchingEnvironment environment) {
        return this.getTransitService(environment).findPatterns(this.getSource(environment)).stream().map(TripPattern::getStops).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Iterable<Trip> getTrips(DataFetchingEnvironment environment) {
        return this.getTransitService(environment).findPatterns(this.getSource(environment)).stream().flatMap(TripPattern::scheduledTripsAsStream).collect(Collectors.toSet());
    }

    private TransitAlertService getAlertService(DataFetchingEnvironment environment) {
        return this.getTransitService(environment).getTransitAlertService();
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((GraphQLRequestContext)environment.getContext()).transitService();
    }

    private Route getSource(DataFetchingEnvironment environment) {
        return (Route)environment.getSource();
    }
}

