/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.time.OffsetDateTime;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleFuel;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalSystem;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalVehicle;

public class RentalVehicleImpl
implements GraphQLDataFetchers.GraphQLRentalVehicle {
    @Override
    public DataFetcher<Boolean> allowPickupNow() {
        return environment -> this.getSource(environment).allowPickupNow();
    }

    @Override
    public DataFetcher<RentalVehicleFuel> fuel() {
        return environment -> this.getSource(environment).fuel();
    }

    @Override
    public DataFetcher<OffsetDateTime> availableUntil() {
        return environment -> this.getSource(environment).availableUntil();
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("RentalVehicle", this.getSource(environment).id().toString());
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).latitude();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).longitude();
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getSource(environment).name().toString(GraphQLUtils.getLocale(environment));
    }

    @Override
    public DataFetcher<String> network() {
        return environment -> this.getSource(environment).network();
    }

    @Override
    public DataFetcher<Boolean> operative() {
        return environment -> this.getSource(environment).isAllowPickup();
    }

    @Override
    public DataFetcher<VehicleRentalStationUris> rentalUris() {
        return environment -> this.getSource(environment).rentalUris();
    }

    @Override
    public DataFetcher<String> vehicleId() {
        return environment -> this.getSource(environment).id().toString();
    }

    @Override
    public DataFetcher<RentalVehicleType> vehicleType() {
        return environment -> this.getSource(environment).vehicleType();
    }

    @Override
    public DataFetcher<VehicleRentalSystem> rentalNetwork() {
        return environment -> this.getSource(environment).vehicleRentalSystem();
    }

    private VehicleRentalVehicle getSource(DataFetchingEnvironment environment) {
        return (VehicleRentalVehicle)environment.getSource();
    }
}

