/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.model.PlanPageInfo;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.api.response.TripSearchMetadata;
import org.opentripplanner.transit.service.TransitService;

public class PlanConnectionImpl
implements GraphQLDataFetchers.GraphQLPlanConnection {
    @Override
    public DataFetcher<OffsetDateTime> searchDateTime() {
        return environment -> {
            TransitService transitService = this.getTransitService(environment);
            Instant instant = this.getSource((DataFetchingEnvironment)environment).getTripPlan().date;
            return instant.atOffset(transitService.getTimeZone().getRules().getOffset(instant));
        };
    }

    @Override
    public DataFetcher<Iterable<DefaultEdge<Itinerary>>> edges() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).getTripPlan().itineraries.stream().map(itinerary -> new DefaultEdge(itinerary, (ConnectionCursor)new DefaultConnectionCursor("NoCursor"))).toList();
    }

    @Override
    public DataFetcher<Iterable<RoutingError>> routingErrors() {
        return environment -> this.getSource(environment).getRoutingErrors();
    }

    @Override
    public DataFetcher<PlanPageInfo> pageInfo() {
        return environment -> {
            String startCursor = this.getSource(environment).getNextPageCursor() != null ? this.getSource(environment).getPreviousPageCursor().encode() : null;
            DefaultConnectionCursor startConnectionCursor = null;
            if (startCursor != null) {
                startConnectionCursor = new DefaultConnectionCursor(startCursor);
            }
            String endCursor = this.getSource(environment).getPreviousPageCursor() != null ? this.getSource(environment).getNextPageCursor().encode() : null;
            DefaultConnectionCursor endConnectionCursor = null;
            if (endCursor != null) {
                endConnectionCursor = new DefaultConnectionCursor(endCursor);
            }
            Duration searchWindowUsed = null;
            TripSearchMetadata metadata = this.getSource(environment).getMetadata();
            if (metadata != null) {
                searchWindowUsed = metadata.searchWindowUsed;
            }
            return new PlanPageInfo((ConnectionCursor)startConnectionCursor, (ConnectionCursor)endConnectionCursor, startCursor != null, endCursor != null, searchWindowUsed);
        };
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((GraphQLRequestContext)environment.getContext()).transitService();
    }

    private RoutingResponse getSource(DataFetchingEnvironment environment) {
        return (RoutingResponse)environment.getSource();
    }
}

