/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.model.FeedPublisher;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.service.TransitService;

public class FeedImpl
implements GraphQLDataFetchers.GraphQLFeed {
    @Override
    public DataFetcher<Iterable<Agency>> agencies() {
        return environment -> this.getAgencies(environment);
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getTransitService(environment).getTransitAlertService();
            GraphQLTypes.GraphQLFeedAlertsArgs args = new GraphQLTypes.GraphQLFeedAlertsArgs(environment.getArguments());
            List<GraphQLTypes.GraphQLFeedAlertType> types = args.getGraphQLTypes();
            if (types != null) {
                ArrayList alerts = new ArrayList();
                types.forEach(type -> {
                    switch (type) {
                        case AGENCIES: {
                            List<Agency> agencies = this.getAgencies(environment);
                            agencies.forEach(agency -> alerts.addAll(alertService.getAgencyAlerts(agency.getId())));
                            break;
                        }
                        case ROUTE_TYPES: {
                            alertService.getAllAlerts().stream().filter(alert -> alert.entities().stream().filter(EntitySelector.RouteType.class::isInstance).map(EntitySelector.RouteType.class::cast).anyMatch(entity -> entity.feedId().equals(this.getSource(environment)))).forEach(alerts::add);
                        }
                    }
                });
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return null;
        };
    }

    @Override
    public DataFetcher<String> feedId() {
        return this::getSource;
    }

    @Override
    public DataFetcher<FeedPublisher> publisher() {
        return environment -> {
            String id = this.getSource(environment);
            return new FeedPublisher(this.getTransitService(environment).getFeedInfo(id).getPublisherName(), this.getTransitService(environment).getFeedInfo(id).getPublisherUrl());
        };
    }

    private List<Agency> getAgencies(DataFetchingEnvironment environment) {
        String id = this.getSource(environment);
        return this.getTransitService(environment).listAgencies().stream().filter(agency -> agency.getId().getFeedId().equals(id)).collect(Collectors.toList());
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((GraphQLRequestContext)environment.getContext()).transitService();
    }

    private String getSource(DataFetchingEnvironment environment) {
        return (String)environment.getSource();
    }
}

