/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.GraphQLUtils;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.graphfinder.PatternAtStop;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.service.ArrivalDeparture;
import org.opentripplanner.transit.service.TransitService;

public class DepartureRowImpl
implements GraphQLDataFetchers.GraphQLDepartureRow {
    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("DepartureRow", this.getSource((DataFetchingEnvironment)environment).id);
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).stop.getLat();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).stop.getLon();
    }

    @Override
    public DataFetcher<TripPattern> pattern() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).pattern;
    }

    @Override
    public DataFetcher<Object> stop() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).stop;
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> stoptimes() {
        return environment -> {
            GraphQLTypes.GraphQLDepartureRowStoptimesArgs args = new GraphQLTypes.GraphQLDepartureRowStoptimesArgs(environment.getArguments());
            return this.getSource(environment).getStoptimes(this.getTransitService(environment), GraphQLUtils.getTimeOrNow(args.getGraphQLStartTime()), Duration.ofSeconds(args.getGraphQLTimeRange().intValue()), args.getGraphQLNumberOfDepartures(), args.getGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH);
        };
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((GraphQLRequestContext)environment.getContext()).transitService();
    }

    private PatternAtStop getSource(DataFetchingEnvironment environment) {
        return (PatternAtStop)environment.getSource();
    }
}

