/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingSpaces;

public class CarParkImpl
implements GraphQLDataFetchers.GraphQLCarPark {
    @Override
    public DataFetcher<String> carParkId() {
        return environment -> this.getSource(environment).getId().getId();
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("CarPark", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).getCoordinate().latitude();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).getCoordinate().longitude();
    }

    @Override
    public DataFetcher<Integer> maxCapacity() {
        return environment -> {
            VehicleParkingSpaces availability = this.getSource(environment).getCapacity();
            if (availability == null) {
                return null;
            }
            return availability.getCarSpaces();
        };
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> GraphQLUtils.getTranslation(this.getSource(environment).getName(), environment);
    }

    @Override
    public DataFetcher<OHCalendar> openingHours() {
        return environment -> this.getSource(environment).getOpeningHours();
    }

    @Override
    public DataFetcher<Boolean> realtime() {
        return environment -> this.getSource(environment).hasRealTimeData();
    }

    @Override
    public DataFetcher<Integer> spacesAvailable() {
        return environment -> {
            VehicleParkingSpaces availability = this.getSource(environment).getAvailability();
            if (availability == null) {
                return null;
            }
            return availability.getCarSpaces();
        };
    }

    @Override
    public DataFetcher<Iterable<String>> tags() {
        return environment -> this.getSource(environment).getTags();
    }

    private VehicleParking getSource(DataFetchingEnvironment environment) {
        return (VehicleParking)environment.getSource();
    }
}

