/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.transit.model.organization.ContactInfo;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.transit.model.timetable.booking.BookingTime;

public class BookingInfoImpl
implements GraphQLDataFetchers.GraphQLBookingInfo {
    @Override
    public DataFetcher<ContactInfo> contactInfo() {
        return environment -> this.getSource(environment).getContactInfo();
    }

    @Override
    public DataFetcher<String> dropOffMessage() {
        return environment -> this.getSource(environment).getDropOffMessage();
    }

    @Override
    public DataFetcher<BookingTime> earliestBookingTime() {
        return environment -> this.getSource(environment).getEarliestBookingTime();
    }

    @Override
    public DataFetcher<BookingTime> latestBookingTime() {
        return environment -> this.getSource(environment).getLatestBookingTime();
    }

    @Override
    public DataFetcher<Duration> maximumBookingNotice() {
        return env -> this.getSource(env).getMaximumBookingNotice().orElse(null);
    }

    @Override
    public DataFetcher<Long> maximumBookingNoticeSeconds() {
        return environment -> this.getSource(environment).getMaximumBookingNotice().map(Duration::toSeconds).orElse(null);
    }

    @Override
    public DataFetcher<String> message() {
        return environment -> this.getSource(environment).getMessage();
    }

    @Override
    public DataFetcher<Duration> minimumBookingNotice() {
        return env -> this.getSource(env).getMinimumBookingNotice().orElse(null);
    }

    @Override
    public DataFetcher<Long> minimumBookingNoticeSeconds() {
        return environment -> this.getSource(environment).getMinimumBookingNotice().map(Duration::toSeconds).orElse(null);
    }

    @Override
    public DataFetcher<String> pickupMessage() {
        return environment -> this.getSource(environment).getPickupMessage();
    }

    private BookingInfo getSource(DataFetchingEnvironment environment) {
        return (BookingInfo)environment.getSource();
    }
}

