/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;

public class BikeRentalStationImpl
implements GraphQLDataFetchers.GraphQLBikeRentalStation {
    final String STATE_ON = "Station on";
    final String STATE_OFF = "Station off";

    @Override
    public DataFetcher<Boolean> allowDropoff() {
        return environment -> this.getSource(environment).isAllowDropoff();
    }

    @Override
    public DataFetcher<Boolean> allowDropoffNow() {
        return environment -> this.getSource(environment).allowDropoffNow();
    }

    @Override
    public DataFetcher<Boolean> allowOverloading() {
        return environment -> this.getSource(environment).overloadingAllowed();
    }

    @Override
    public DataFetcher<Boolean> allowPickup() {
        return environment -> this.getSource(environment).isAllowPickup();
    }

    @Override
    public DataFetcher<Boolean> allowPickupNow() {
        return environment -> this.getSource(environment).allowPickupNow();
    }

    @Override
    public DataFetcher<Integer> bikesAvailable() {
        return environment -> this.getSource(environment).vehiclesAvailable();
    }

    @Override
    public DataFetcher<Integer> capacity() {
        return environment -> this.getSource(environment).capacity();
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("BikeRentalStation", this.getSource(environment).id().toString());
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).latitude();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).longitude();
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getSource(environment).name().toString(GraphQLUtils.getLocale(environment));
    }

    @Override
    public DataFetcher<Iterable<String>> networks() {
        return environment -> List.of(this.getSource(environment).network());
    }

    @Override
    public DataFetcher<Boolean> operative() {
        return environment -> this.getSource(environment).isAllowPickup() && this.getSource(environment).isAllowDropoff();
    }

    @Override
    public DataFetcher<Boolean> realtime() {
        return environment -> this.getSource(environment).isRealTimeData();
    }

    @Override
    public DataFetcher<VehicleRentalStationUris> rentalUris() {
        return environment -> this.getSource(environment).rentalUris();
    }

    @Override
    public DataFetcher<Integer> spacesAvailable() {
        return environment -> this.getSource(environment).spacesAvailable();
    }

    @Override
    public DataFetcher<String> state() {
        return environment -> {
            VehicleRentalPlace rentalPlace = this.getSource(environment);
            if (rentalPlace.isFloatingVehicle() && rentalPlace.isAllowPickup()) {
                return "Station on";
            }
            if (rentalPlace.isAllowDropoff() && rentalPlace.isAllowPickup()) {
                return "Station on";
            }
            return "Station off";
        };
    }

    @Override
    public DataFetcher<String> stationId() {
        return environment -> this.getSource(environment).stationId();
    }

    private VehicleRentalPlace getSource(DataFetchingEnvironment environment) {
        return (VehicleRentalPlace)environment.getSource();
    }
}

