/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.generated.GraphQLDataFetchers;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.service.TransitService;

public class AgencyImpl
implements GraphQLDataFetchers.GraphQLAgency {
    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getTransitService(environment).getTransitAlertService();
            GraphQLTypes.GraphQLAgencyAlertsArgs args = new GraphQLTypes.GraphQLAgencyAlertsArgs(environment.getArguments());
            List<GraphQLTypes.GraphQLAgencyAlertType> types = args.getGraphQLTypes();
            if (types != null) {
                ArrayList alerts = new ArrayList();
                types.forEach(type -> {
                    switch (type) {
                        case AGENCY: {
                            alerts.addAll(alertService.getAgencyAlerts(this.getSource(environment).getId()));
                            break;
                        }
                        case ROUTE_TYPES: {
                            alertService.getAllAlerts().stream().filter(alert -> alert.entities().stream().filter(EntitySelector.RouteTypeAndAgency.class::isInstance).map(EntitySelector.RouteTypeAndAgency.class::cast).anyMatch(entity -> entity.agencyId().equals(this.getSource(environment).getId()))).forEach(alerts::add);
                            break;
                        }
                        case ROUTES: {
                            this.getRoutes(environment).forEach(route -> alerts.addAll(alertService.getRouteAlerts(route.getId())));
                        }
                    }
                });
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return alertService.getAgencyAlerts(this.getSource(environment).getId());
        };
    }

    @Override
    public DataFetcher<String> fareUrl() {
        return environment -> this.getSource(environment).getFareUrl();
    }

    @Override
    public DataFetcher<String> gtfsId() {
        return environment -> this.getSource(environment).getId().toString();
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("Agency", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<String> lang() {
        return environment -> this.getSource(environment).getLang();
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getSource(environment).getName();
    }

    @Override
    public DataFetcher<String> phone() {
        return environment -> this.getSource(environment).getPhone();
    }

    @Override
    public DataFetcher<Iterable<Route>> routes() {
        return environment -> this.getRoutes(environment);
    }

    @Override
    public DataFetcher<String> timezone() {
        return environment -> this.getSource(environment).getTimezone().getId();
    }

    @Override
    public DataFetcher<String> url() {
        return environment -> this.getSource(environment).getUrl();
    }

    private List<Route> getRoutes(DataFetchingEnvironment environment) {
        return this.getTransitService(environment).listRoutes().stream().filter(route -> route.getAgency().equals(this.getSource(environment))).collect(Collectors.toList());
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((GraphQLRequestContext)environment.getContext()).transitService();
    }

    private Agency getSource(DataFetchingEnvironment environment) {
        return (Agency)environment.getSource();
    }
}

