/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opentripplanner.apis.gtfs.GraphQLRequestContext;
import org.opentripplanner.apis.gtfs.GtfsGraphQLIndex;
import org.opentripplanner.apis.support.TracingUtils;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/gtfs/v1/")
@Produces(value={"application/json"})
public class GtfsGraphQLAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsGraphQLAPI.class);
    private final OtpServerRequestContext serverContext;
    private final ObjectMapper deserializer = new ObjectMapper();

    public GtfsGraphQLAPI(@Context OtpServerRequestContext serverContext) {
        this.serverContext = serverContext;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response getGraphQL(HashMap<String, Object> jsonParameters, @HeaderParam(value="OTPTimeout") @DefaultValue(value="30000") int timeout, @HeaderParam(value="OTPMaxResolves") @DefaultValue(value="1000000") int maxResolves, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Map<String, Object> variables;
        if (jsonParameters == null || !jsonParameters.containsKey("query")) {
            LOG.debug("No query found in body");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"No query found in body").build();
        }
        Locale locale = headers.getAcceptableLanguages().size() > 0 ? (Locale)headers.getAcceptableLanguages().get(0) : this.serverContext.defaultRouteRequest().preferences().locale();
        String query = (String)jsonParameters.get("query");
        Object queryVariables = jsonParameters.getOrDefault("variables", null);
        String operationName = jsonParameters.getOrDefault("operationName", null);
        if (queryVariables instanceof Map) {
            variables = queryVariables;
        } else if (queryVariables instanceof String && !((String)queryVariables).isEmpty()) {
            try {
                variables = (Map)this.deserializer.readValue((String)queryVariables, Map.class);
            }
            catch (IOException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"Variables must be a valid json object").build();
            }
        } else {
            variables = new HashMap<String, Object>();
        }
        return GtfsGraphQLIndex.getGraphQLResponse(query, variables, operationName, maxResolves, timeout, locale, GraphQLRequestContext.ofServerContext(this.serverContext), TracingUtils.findTagsInHeadersOrQueryParameters(this.serverContext.gtfsApiParameters().tracingTags(), headers, (MultivaluedMap<String, String>)uriInfo.getQueryParameters()));
    }

    @POST
    @Consumes(value={"application/graphql"})
    public Response getGraphQL(String query, @HeaderParam(value="OTPTimeout") @DefaultValue(value="30000") int timeout, @HeaderParam(value="OTPMaxResolves") @DefaultValue(value="1000000") int maxResolves, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Locale locale = headers.getAcceptableLanguages().size() > 0 ? (Locale)headers.getAcceptableLanguages().get(0) : this.serverContext.defaultRouteRequest().preferences().locale();
        return GtfsGraphQLIndex.getGraphQLResponse(query, null, null, maxResolves, timeout, locale, GraphQLRequestContext.ofServerContext(this.serverContext), TracingUtils.findTagsInHeadersOrQueryParameters(this.serverContext.gtfsApiParameters().tracingTags(), headers, (MultivaluedMap<String, String>)uriInfo.getQueryParameters()));
    }

    @Path(value="/routers/{ignoreRouterId}/index/graphql")
    public static class GtfsGraphQLAPIOldPath
    extends GtfsGraphQLAPI {
        public GtfsGraphQLAPIOldPath(@Context OtpServerRequestContext serverContext, @PathParam(value="ignoreRouterId") String ignore) {
            super(serverContext);
        }
    }
}

