/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs;

import java.time.Instant;
import java.util.Locale;
import javax.annotation.Nullable;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.basic.Accessibility;

public class GraphQLUtils {
    public static GraphQLTypes.GraphQLWheelchairBoarding toGraphQL(Accessibility boarding) {
        if (boarding == null) {
            return null;
        }
        return switch (boarding) {
            default -> throw new MatchException(null, null);
            case Accessibility.NO_INFORMATION -> GraphQLTypes.GraphQLWheelchairBoarding.NO_INFORMATION;
            case Accessibility.POSSIBLE -> GraphQLTypes.GraphQLWheelchairBoarding.POSSIBLE;
            case Accessibility.NOT_POSSIBLE -> GraphQLTypes.GraphQLWheelchairBoarding.NOT_POSSIBLE;
        };
    }

    public static GraphQLTypes.GraphQLRoutingErrorCode toGraphQL(RoutingErrorCode code) {
        if (code == null) {
            return null;
        }
        return switch (code) {
            default -> throw new MatchException(null, null);
            case RoutingErrorCode.LOCATION_NOT_FOUND -> GraphQLTypes.GraphQLRoutingErrorCode.LOCATION_NOT_FOUND;
            case RoutingErrorCode.NO_STOPS_IN_RANGE -> GraphQLTypes.GraphQLRoutingErrorCode.NO_STOPS_IN_RANGE;
            case RoutingErrorCode.NO_TRANSIT_CONNECTION -> GraphQLTypes.GraphQLRoutingErrorCode.NO_TRANSIT_CONNECTION;
            case RoutingErrorCode.NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW -> GraphQLTypes.GraphQLRoutingErrorCode.NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW;
            case RoutingErrorCode.OUTSIDE_BOUNDS -> GraphQLTypes.GraphQLRoutingErrorCode.OUTSIDE_BOUNDS;
            case RoutingErrorCode.OUTSIDE_SERVICE_PERIOD -> GraphQLTypes.GraphQLRoutingErrorCode.OUTSIDE_SERVICE_PERIOD;
            case RoutingErrorCode.WALKING_BETTER_THAN_TRANSIT -> GraphQLTypes.GraphQLRoutingErrorCode.WALKING_BETTER_THAN_TRANSIT;
        };
    }

    public static GraphQLTypes.GraphQLInputField toGraphQL(InputField inputField) {
        if (inputField == null) {
            return null;
        }
        return switch (inputField) {
            default -> throw new MatchException(null, null);
            case InputField.DATE_TIME -> GraphQLTypes.GraphQLInputField.DATE_TIME;
            case InputField.FROM_PLACE -> GraphQLTypes.GraphQLInputField.FROM;
            case InputField.TO_PLACE, InputField.INTERMEDIATE_PLACE -> GraphQLTypes.GraphQLInputField.TO;
        };
    }

    public static RentalFormFactor toModel(GraphQLTypes.GraphQLFormFactor formFactor) {
        if (formFactor == null) {
            return null;
        }
        return switch (formFactor) {
            default -> throw new MatchException(null, null);
            case GraphQLTypes.GraphQLFormFactor.BICYCLE -> RentalFormFactor.BICYCLE;
            case GraphQLTypes.GraphQLFormFactor.SCOOTER -> RentalFormFactor.SCOOTER;
            case GraphQLTypes.GraphQLFormFactor.CAR -> RentalFormFactor.CAR;
            case GraphQLTypes.GraphQLFormFactor.CARGO_BICYCLE -> RentalFormFactor.CARGO_BICYCLE;
            case GraphQLTypes.GraphQLFormFactor.MOPED -> RentalFormFactor.MOPED;
            case GraphQLTypes.GraphQLFormFactor.OTHER -> RentalFormFactor.OTHER;
            case GraphQLTypes.GraphQLFormFactor.SCOOTER_SEATED -> RentalFormFactor.SCOOTER_SEATED;
            case GraphQLTypes.GraphQLFormFactor.SCOOTER_STANDING -> RentalFormFactor.SCOOTER_STANDING;
        };
    }

    public static PlaceType toModel(GraphQLTypes.GraphQLFilterPlaceType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case GraphQLTypes.GraphQLFilterPlaceType.BICYCLE_RENT, GraphQLTypes.GraphQLFilterPlaceType.VEHICLE_RENT -> PlaceType.VEHICLE_RENT;
            case GraphQLTypes.GraphQLFilterPlaceType.BIKE_PARK -> PlaceType.BIKE_PARK;
            case GraphQLTypes.GraphQLFilterPlaceType.CAR_PARK -> PlaceType.CAR_PARK;
            case GraphQLTypes.GraphQLFilterPlaceType.DEPARTURE_ROW -> PlaceType.PATTERN_AT_STOP;
            case GraphQLTypes.GraphQLFilterPlaceType.STOP -> PlaceType.STOP;
            case GraphQLTypes.GraphQLFilterPlaceType.STATION -> PlaceType.STATION;
        };
    }

    public static Instant getTimeOrNow(long epochSeconds) {
        return epochSeconds != 0L ? Instant.ofEpochSecond(epochSeconds) : Instant.now();
    }

    public static boolean startsWith(String str, String name, Locale locale) {
        return str != null && str.toLowerCase(locale).startsWith(name);
    }

    public static boolean startsWith(I18NString str, String name, Locale locale) {
        return str != null && str.toString(locale).toLowerCase(locale).startsWith(name);
    }

    @Nullable
    public static Integer stopTimeToInt(int value) {
        if (value == -999) {
            return null;
        }
        return value;
    }

    public static String typeName(Object type) {
        return type.getClass().getSimpleName().replaceAll("^GraphQL", "");
    }
}

