/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.relay.Relay;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.framework.graphql.scalar.DateScalarFactory;
import org.opentripplanner.framework.graphql.scalar.DurationScalarFactory;
import org.opentripplanner.framework.json.ObjectMappers;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.framework.model.Gram;
import org.opentripplanner.utils.time.OffsetDateTimeParser;

public class GraphQLScalars {
    private static final ObjectMapper GEOJSON_MAPPER = ObjectMappers.geoJson();
    public static final GraphQLScalarType DURATION_SCALAR = DurationScalarFactory.createDurationScalar();
    public static final GraphQLScalarType POLYLINE_SCALAR = GraphQLScalarType.newScalar().name("Polyline").description("List of coordinates in an encoded polyline format (see https://developers.google.com/maps/documentation/utilities/polylinealgorithm). The value appears in JSON as a string.").coercing((Coercing)new Coercing<String, String>(){

        public String serialize(Object input) {
            return input == null ? null : input.toString();
        }

        public String parseValue(Object input) {
            return this.serialize(input);
        }

        public String parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            return ((StringValue)input).getValue();
        }
    }).build();
    public static final GraphQLScalarType OFFSET_DATETIME_SCALAR = GraphQLScalarType.newScalar().name("OffsetDateTime").coercing((Coercing)new Coercing<OffsetDateTime, String>(){

        public String serialize(Object dataFetcherResult) throws CoercingSerializeException {
            if (dataFetcherResult instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)dataFetcherResult;
                return zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            if (dataFetcherResult instanceof OffsetDateTime) {
                OffsetDateTime odt = (OffsetDateTime)dataFetcherResult;
                return odt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            throw new CoercingSerializeException("Cannot serialize object of class %s".formatted(dataFetcherResult.getClass().getSimpleName()));
        }

        public OffsetDateTime parseValue(Object input) throws CoercingParseValueException {
            if (input instanceof CharSequence) {
                CharSequence cs = (CharSequence)input;
                try {
                    return OffsetDateTimeParser.parseLeniently((CharSequence)cs);
                }
                catch (ParseException e) {
                    int errorOffset = e.getErrorOffset();
                    throw new CoercingParseValueException("Cannot parse %s into an OffsetDateTime. Error at character index %s".formatted(input, errorOffset));
                }
            }
            throw new CoercingParseValueException("Cannot parse %s into an OffsetDateTime. Must be a string.");
        }

        public OffsetDateTime parseLiteral(Object input) throws CoercingParseLiteralException {
            if (input instanceof StringValue) {
                StringValue sv = (StringValue)input;
                try {
                    return OffsetDateTimeParser.parseLeniently((CharSequence)sv.getValue());
                }
                catch (ParseException e) {
                    throw new CoercingSerializeException();
                }
            }
            throw new CoercingParseLiteralException();
        }
    }).build();
    public static final GraphQLScalarType COORDINATE_VALUE_SCALAR = GraphQLScalarType.newScalar().name("CoordinateValue").coercing((Coercing)new Coercing<Double, Double>(){
        private static final String VALIDATION_ERROR_MESSAGE = "Not a valid WGS84 coordinate value";

        public Double serialize(Object dataFetcherResult) throws CoercingSerializeException {
            if (dataFetcherResult instanceof Double) {
                Double doubleValue = (Double)dataFetcherResult;
                return doubleValue;
            }
            if (dataFetcherResult instanceof Float) {
                Float floatValue = (Float)dataFetcherResult;
                return floatValue.doubleValue();
            }
            throw new CoercingSerializeException("Cannot serialize object of class %s as a coordinate number".formatted(dataFetcherResult.getClass().getSimpleName()));
        }

        public Double parseValue(Object input) throws CoercingParseValueException {
            if (input instanceof Double) {
                Double doubleValue = (Double)input;
                return 3.validateCoordinate(doubleValue).orElseThrow(() -> new CoercingParseValueException(VALIDATION_ERROR_MESSAGE));
            }
            if (input instanceof Integer) {
                Integer intValue = (Integer)input;
                return 3.validateCoordinate(intValue.intValue()).orElseThrow(() -> new CoercingParseValueException(VALIDATION_ERROR_MESSAGE));
            }
            throw new CoercingParseValueException("Expected a number, got %s %s".formatted(input.getClass().getSimpleName(), input));
        }

        public Double parseLiteral(Object input) throws CoercingParseLiteralException {
            if (input instanceof FloatValue) {
                FloatValue coordinate = (FloatValue)input;
                return 3.validateCoordinate(coordinate.getValue().doubleValue()).orElseThrow(() -> new CoercingParseLiteralException(VALIDATION_ERROR_MESSAGE));
            }
            if (input instanceof IntValue) {
                IntValue coordinate = (IntValue)input;
                return 3.validateCoordinate(coordinate.getValue().doubleValue()).orElseThrow(() -> new CoercingParseLiteralException(VALIDATION_ERROR_MESSAGE));
            }
            throw new CoercingParseLiteralException("Expected a number, got: " + input.getClass().getSimpleName());
        }

        private static Optional<Double> validateCoordinate(double coordinate) {
            if (coordinate >= -180.001 && coordinate <= 180.001) {
                return Optional.of(coordinate);
            }
            return Optional.empty();
        }
    }).build();
    public static final GraphQLScalarType COST_SCALAR = GraphQLScalarType.newScalar().name("Cost").coercing((Coercing)new Coercing<Cost, Integer>(){
        private static final int MAX_COST = 1000000;
        private static final String VALIDATION_ERROR_MESSAGE = "Cost cannot be negative or greater than %d".formatted(1000000);

        public Integer serialize(Object dataFetcherResult) throws CoercingSerializeException {
            if (dataFetcherResult instanceof Integer) {
                Integer intValue = (Integer)dataFetcherResult;
                return intValue;
            }
            if (dataFetcherResult instanceof Cost) {
                Cost costValue = (Cost)dataFetcherResult;
                return costValue.toSeconds();
            }
            throw new CoercingSerializeException("Cannot serialize object of class %s as a cost".formatted(dataFetcherResult.getClass().getSimpleName()));
        }

        public Cost parseValue(Object input) throws CoercingParseValueException {
            if (input instanceof Integer) {
                Integer intValue = (Integer)input;
                return 4.validateCost(intValue).orElseThrow(() -> new CoercingParseValueException(VALIDATION_ERROR_MESSAGE));
            }
            throw new CoercingParseValueException("Expected an integer, got %s %s".formatted(input.getClass().getSimpleName(), input));
        }

        public Cost parseLiteral(Object input) throws CoercingParseLiteralException {
            if (input instanceof IntValue) {
                IntValue intValue = (IntValue)input;
                int value = intValue.getValue().intValue();
                return 4.validateCost(value).orElseThrow(() -> new CoercingParseLiteralException(VALIDATION_ERROR_MESSAGE));
            }
            throw new CoercingParseLiteralException("Expected an integer, got: " + input.getClass().getSimpleName());
        }

        private static Optional<Cost> validateCost(int cost) {
            if (cost >= 0 && cost <= 1000000) {
                return Optional.of(Cost.costOfSeconds(cost));
            }
            return Optional.empty();
        }
    }).build();
    public static final GraphQLScalarType LOCAL_DATE_SCALAR = DateScalarFactory.createGtfsDateScalar();
    public static final GraphQLScalarType GEOJSON_SCALAR = GraphQLScalarType.newScalar().name("GeoJson").description("Geographic data structures in JSON format. See: https://geojson.org/").coercing((Coercing)new Coercing<Geometry, JsonNode>(){

        public JsonNode serialize(Object dataFetcherResult) throws CoercingSerializeException {
            if (dataFetcherResult instanceof Geometry) {
                Geometry geom = (Geometry)dataFetcherResult;
                return GEOJSON_MAPPER.valueToTree((Object)geom);
            }
            return null;
        }

        public Geometry parseValue(Object input) throws CoercingParseValueException {
            return null;
        }

        public Geometry parseLiteral(Object input) throws CoercingParseLiteralException {
            return null;
        }
    }).build();
    public static final GraphQLScalarType GRAPHQL_ID_SCALAR = GraphQLScalarType.newScalar().name("ID").coercing((Coercing)new Coercing<Relay.ResolvedGlobalId, String>(){

        public String serialize(Object dataFetcherResult) throws CoercingSerializeException {
            if (dataFetcherResult instanceof Relay.ResolvedGlobalId) {
                Relay.ResolvedGlobalId globalId = (Relay.ResolvedGlobalId)dataFetcherResult;
                return new Relay().toGlobalId(globalId.getType(), globalId.getId());
            }
            throw new CoercingSerializeException("Unknown type " + dataFetcherResult.getClass().getSimpleName());
        }

        public Relay.ResolvedGlobalId parseValue(Object input) throws CoercingParseValueException {
            if (input instanceof String) {
                return new Relay().fromGlobalId((String)input);
            }
            throw new CoercingParseValueException("Unexpected type " + input.getClass().getSimpleName());
        }

        public Relay.ResolvedGlobalId parseLiteral(Object input) throws CoercingParseLiteralException {
            if (input instanceof StringValue) {
                return new Relay().fromGlobalId(((StringValue)input).getValue());
            }
            throw new CoercingParseLiteralException("Unexpected type " + input.getClass().getSimpleName());
        }
    }).build();
    public static final GraphQLScalarType GRAMS_SCALAR = GraphQLScalarType.newScalar().name("Grams").coercing((Coercing)new Coercing<Gram, Double>(){

        public Double serialize(Object dataFetcherResult) throws CoercingSerializeException {
            if (dataFetcherResult instanceof Gram) {
                Gram gram = (Gram)dataFetcherResult;
                return gram.asDouble();
            }
            return null;
        }

        public Gram parseValue(Object input) throws CoercingParseValueException {
            if (input instanceof Double) {
                Double doubleValue = (Double)input;
                return Gram.of(doubleValue);
            }
            if (input instanceof Integer) {
                Integer intValue = (Integer)input;
                return Gram.of(intValue.intValue());
            }
            throw new CoercingParseValueException("Expected a number, got %s %s".formatted(input.getClass().getSimpleName(), input));
        }

        public Gram parseLiteral(Object input) throws CoercingParseLiteralException {
            if (input instanceof FloatValue) {
                FloatValue floatValue = (FloatValue)input;
                return Gram.of(floatValue.getValue().doubleValue());
            }
            if (input instanceof IntValue) {
                IntValue intValue = (IntValue)input;
                return Gram.of(intValue.getValue().doubleValue());
            }
            throw new CoercingParseLiteralException("Expected a number, got: " + input.getClass().getSimpleName());
        }
    }).build();
    public static final GraphQLScalarType RATIO_SCALAR = GraphQLScalarType.newScalar().name("Ratio").coercing((Coercing)new Coercing<Double, Double>(){
        private static final String VALIDATION_ERROR_MESSAGE = "Value is under 0 or greater than 1.";

        public Double serialize(Object dataFetcherResult) throws CoercingSerializeException {
            CoercingSerializeException validationException = new CoercingSerializeException(VALIDATION_ERROR_MESSAGE);
            if (dataFetcherResult instanceof Double) {
                Double doubleValue = (Double)dataFetcherResult;
                return 8.validateRatio(doubleValue).orElseThrow(() -> validationException);
            }
            if (dataFetcherResult instanceof Float) {
                Float floatValue = (Float)dataFetcherResult;
                return 8.validateRatio(floatValue.doubleValue()).orElseThrow(() -> validationException);
            }
            throw new CoercingSerializeException("Cannot serialize object of class %s as a ratio".formatted(dataFetcherResult.getClass().getSimpleName()));
        }

        public Double parseValue(Object input) throws CoercingParseValueException {
            if (input instanceof Double) {
                Double doubleValue = (Double)input;
                return 8.validateRatio(doubleValue).orElseThrow(() -> new CoercingParseValueException(VALIDATION_ERROR_MESSAGE));
            }
            if (input instanceof Integer) {
                Integer intValue = (Integer)input;
                return 8.validateRatio(intValue.intValue()).orElseThrow(() -> new CoercingParseValueException(VALIDATION_ERROR_MESSAGE));
            }
            throw new CoercingParseValueException("Expected a number, got %s %s".formatted(input.getClass().getSimpleName(), input));
        }

        public Double parseLiteral(Object input) throws CoercingParseLiteralException {
            if (input instanceof FloatValue) {
                FloatValue ratio = (FloatValue)input;
                return 8.validateRatio(ratio.getValue().doubleValue()).orElseThrow(() -> new CoercingParseLiteralException(VALIDATION_ERROR_MESSAGE));
            }
            if (input instanceof IntValue) {
                IntValue ratio = (IntValue)input;
                return 8.validateRatio(ratio.getValue().doubleValue()).orElseThrow(() -> new CoercingParseLiteralException(VALIDATION_ERROR_MESSAGE));
            }
            throw new CoercingParseLiteralException("Expected a number, got: " + input.getClass().getSimpleName());
        }

        private static Optional<Double> validateRatio(double ratio) {
            if (ratio >= -0.001 && ratio <= 1.001) {
                return Optional.of(ratio);
            }
            return Optional.empty();
        }
    }).build();
    public static final GraphQLScalarType RELUCTANCE_SCALAR = GraphQLScalarType.newScalar().name("Reluctance").coercing((Coercing)new Coercing<Double, Double>(){
        private static final double MIN_Reluctance = 0.1;
        private static final double MAX_Reluctance = 100000.0;
        private static final String VALIDATION_ERROR_MESSAGE = "Reluctance needs to be between %s and %s".formatted(0.1, 100000.0);

        public Double serialize(Object dataFetcherResult) throws CoercingSerializeException {
            if (dataFetcherResult instanceof Double) {
                Double doubleValue = (Double)dataFetcherResult;
                return doubleValue;
            }
            if (dataFetcherResult instanceof Float) {
                Float floatValue = (Float)dataFetcherResult;
                return floatValue.doubleValue();
            }
            throw new CoercingSerializeException("Cannot serialize object of class %s as a reluctance".formatted(dataFetcherResult.getClass().getSimpleName()));
        }

        public Double parseValue(Object input) throws CoercingParseValueException {
            if (input instanceof Double) {
                Double doubleValue = (Double)input;
                return 9.validateReluctance(doubleValue).orElseThrow(() -> new CoercingParseValueException(VALIDATION_ERROR_MESSAGE));
            }
            if (input instanceof Integer) {
                Integer intValue = (Integer)input;
                return 9.validateReluctance(intValue.intValue()).orElseThrow(() -> new CoercingParseValueException(VALIDATION_ERROR_MESSAGE));
            }
            throw new CoercingParseValueException("Expected a number, got %s %s".formatted(input.getClass().getSimpleName(), input));
        }

        public Double parseLiteral(Object input) throws CoercingParseLiteralException {
            if (input instanceof FloatValue) {
                FloatValue reluctance = (FloatValue)input;
                return 9.validateReluctance(reluctance.getValue().doubleValue()).orElseThrow(() -> new CoercingParseLiteralException(VALIDATION_ERROR_MESSAGE));
            }
            if (input instanceof IntValue) {
                IntValue reluctance = (IntValue)input;
                return 9.validateReluctance(reluctance.getValue().doubleValue()).orElseThrow(() -> new CoercingParseLiteralException(VALIDATION_ERROR_MESSAGE));
            }
            throw new CoercingParseLiteralException("Expected a number, got: " + input.getClass().getSimpleName());
        }

        private static Optional<Double> validateReluctance(double reluctance) {
            if (reluctance >= 0.099 && reluctance <= 100000.001) {
                return Optional.of(reluctance);
            }
            return Optional.empty();
        }
    }).build();
}

