/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.gtfs;

import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opentripplanner.apis.gtfs.generated.GraphQLTypes;
import org.opentripplanner.apis.gtfs.mapping.TransitModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.AccessModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.DirectModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.EgressModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.StreetModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.TransferModeMapper;
import org.opentripplanner.apis.gtfs.mapping.routerequest.VehicleOptimizationTypeMapper;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.preference.BikePreferences;
import org.opentripplanner.routing.api.request.preference.CarPreferences;
import org.opentripplanner.routing.api.request.preference.ScooterPreferences;
import org.opentripplanner.routing.api.request.preference.TimeSlopeSafetyTriangle;
import org.opentripplanner.routing.api.request.preference.TransferPreferences;
import org.opentripplanner.routing.api.request.preference.TransitPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleWalkingPreferences;
import org.opentripplanner.routing.api.request.preference.WalkPreferences;
import org.opentripplanner.routing.api.request.preference.filter.VehicleParkingFilter;
import org.opentripplanner.routing.api.request.preference.filter.VehicleParkingSelect;
import org.opentripplanner.routing.api.request.request.JourneyRequest;
import org.opentripplanner.routing.core.VehicleRoutingOptimizeType;
import org.opentripplanner.transit.model.basic.TransitMode;

public class DefaultValueInjector
extends GraphQLTypeVisitorStub
implements GraphQLTypeVisitor {
    private final Map<String, Value<?>> defaultForKey;

    public DefaultValueInjector(RouteRequest defaultRouteRequest) {
        this.defaultForKey = DefaultValueInjector.createDefaultMapping(defaultRouteRequest);
    }

    public TraversalControl visitGraphQLArgument(GraphQLArgument argument, TraverserContext<GraphQLSchemaElement> context) {
        Value<?> defaultValue = this.getDefaultValueForSchemaObject(context, argument.getName());
        if (defaultValue != null) {
            return this.changeNode(context, (GraphQLSchemaElement)argument.transform(builder -> builder.defaultValueLiteral(defaultValue).build()));
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField field, TraverserContext<GraphQLSchemaElement> context) {
        Value<?> defaultValue = this.getDefaultValueForSchemaObject(context, field.getName());
        if (defaultValue != null) {
            return this.changeNode(context, (GraphQLSchemaElement)field.transform(builder -> builder.defaultValueLiteral(defaultValue).build()));
        }
        return TraversalControl.CONTINUE;
    }

    private Value<?> getDefaultValueForSchemaObject(TraverserContext<GraphQLSchemaElement> context, String name) {
        GraphQLNamedSchemaElement parent = (GraphQLNamedSchemaElement)context.getParentNode();
        String parentName = parent.getName();
        String key = parentName + "." + name;
        return this.defaultForKey.get(key);
    }

    private static Map<String, Value<?>> createDefaultMapping(RouteRequest defaultRouteRequest) {
        DefaultMappingBuilder builder = new DefaultMappingBuilder().intReq("planConnection.first", defaultRouteRequest.numItineraries()).stringOpt("planConnection.searchWindow", defaultRouteRequest.searchWindow());
        DefaultValueInjector.setBikeDefaults(defaultRouteRequest.preferences().bike(), builder);
        DefaultValueInjector.setCarDefaults(defaultRouteRequest.preferences().car(), builder);
        DefaultValueInjector.setModeDefaults(defaultRouteRequest.journey(), defaultRouteRequest.preferences().transit(), builder);
        DefaultValueInjector.setScooterDefaults(defaultRouteRequest.preferences().scooter(), builder);
        DefaultValueInjector.setTransitDefaults(defaultRouteRequest.preferences().transit(), builder);
        DefaultValueInjector.setTransferDefaults(defaultRouteRequest.preferences().transfer(), builder);
        DefaultValueInjector.setWalkDefaults(defaultRouteRequest.preferences().walk(), builder);
        DefaultValueInjector.setWheelchairDefaults(defaultRouteRequest, builder);
        return builder.build();
    }

    private static void setBikeDefaults(BikePreferences bike, DefaultMappingBuilder builder) {
        builder.intReq("BicyclePreferencesInput.boardCost", bike.boardCost()).floatReq("BicyclePreferencesInput.reluctance", bike.reluctance()).floatReq("BicyclePreferencesInput.speed", bike.speed()).objectReq("BicyclePreferencesInput.optimization", DefaultValueInjector.mapVehicleOptimize(bike.optimizeType(), bike.optimizeTriangle(), VehicleOptimizationTypeMapper::mapForBicycle));
        DefaultValueInjector.setBikeParkingDefaults(bike.parking(), builder);
        DefaultValueInjector.setBikeRentalDefaults(bike.rental(), builder);
        DefaultValueInjector.setBikeWalkingDefaults(bike.walking(), builder);
    }

    private static void setBikeParkingDefaults(VehicleParkingPreferences parking, DefaultMappingBuilder builder) {
        builder.intReq("BicycleParkingPreferencesInput.unpreferredCost", parking.unpreferredVehicleParkingTagCost().toSeconds()).arrayReq("BicycleParkingPreferencesInput.filters", DefaultValueInjector.mapVehicleParkingFilter(parking.filter())).arrayReq("BicycleParkingPreferencesInput.preferred", DefaultValueInjector.mapVehicleParkingFilter(parking.preferred()));
    }

    private static void setBikeRentalDefaults(VehicleRentalPreferences rental, DefaultMappingBuilder builder) {
        builder.arrayStringsOpt("BicycleRentalPreferencesInput.allowedNetworks", rental.allowedNetworks().isEmpty() ? null : rental.allowedNetworks()).arrayStringsReq("BicycleRentalPreferencesInput.bannedNetworks", rental.bannedNetworks()).boolReq("DestinationBicyclePolicyInput.allowKeeping", rental.allowArrivingInRentedVehicleAtDestination()).intReq("DestinationBicyclePolicyInput.keepingCost", rental.arrivingInRentalVehicleAtDestinationCost().toSeconds());
    }

    private static void setBikeWalkingDefaults(VehicleWalkingPreferences walking, DefaultMappingBuilder builder) {
        builder.intReq("BicycleWalkPreferencesCostInput.mountDismountCost", walking.mountDismountCost().toSeconds()).floatReq("BicycleWalkPreferencesCostInput.reluctance", walking.reluctance()).stringReq("BicycleWalkPreferencesInput.mountDismountTime", walking.mountDismountTime()).floatReq("BicycleWalkPreferencesInput.speed", walking.speed());
    }

    private static void setCarDefaults(CarPreferences car, DefaultMappingBuilder builder) {
        builder.floatReq("CarPreferencesInput.reluctance", car.reluctance()).intReq("CarPreferencesInput.boardCost", car.boardCost());
        DefaultValueInjector.setCarParkingDefaults(car.parking(), builder);
        DefaultValueInjector.setCarRentalDefaults(car.rental(), builder);
    }

    private static void setCarParkingDefaults(VehicleParkingPreferences parking, DefaultMappingBuilder builder) {
        builder.intReq("CarParkingPreferencesInput.unpreferredCost", parking.unpreferredVehicleParkingTagCost().toSeconds()).arrayReq("CarParkingPreferencesInput.filters", DefaultValueInjector.mapVehicleParkingFilter(parking.filter())).arrayReq("CarParkingPreferencesInput.preferred", DefaultValueInjector.mapVehicleParkingFilter(parking.preferred()));
    }

    private static void setCarRentalDefaults(VehicleRentalPreferences rental, DefaultMappingBuilder builder) {
        builder.arrayStringsOpt("CarRentalPreferencesInput.allowedNetworks", rental.allowedNetworks().isEmpty() ? null : rental.allowedNetworks()).arrayStringsReq("CarRentalPreferencesInput.bannedNetworks", rental.bannedNetworks());
    }

    private static void setModeDefaults(JourneyRequest journey, TransitPreferences transit, DefaultMappingBuilder builder) {
        builder.enumListReq("PlanModesInput.direct", StreetModeMapper.getStreetModesForApi(journey.direct().mode()).stream().map(mode -> DirectModeMapper.map(mode)).toList()).enumListReq("PlanTransitModesInput.access", StreetModeMapper.getStreetModesForApi(journey.access().mode()).stream().map(mode -> AccessModeMapper.map(mode)).toList()).enumListReq("PlanTransitModesInput.egress", StreetModeMapper.getStreetModesForApi(journey.egress().mode()).stream().map(mode -> EgressModeMapper.map(mode)).toList()).enumListReq("PlanTransitModesInput.transfer", StreetModeMapper.getStreetModesForApi(journey.transfer().mode()).stream().map(mode -> TransferModeMapper.map(mode)).toList()).arrayReq("PlanTransitModesInput.transit", DefaultValueInjector.mapTransitModes(transit.reluctanceForMode()));
    }

    private static void setScooterDefaults(ScooterPreferences scooter, DefaultMappingBuilder builder) {
        builder.floatReq("ScooterPreferencesInput.reluctance", scooter.reluctance()).floatReq("ScooterPreferencesInput.speed", scooter.speed()).objectReq("ScooterPreferencesInput.optimization", DefaultValueInjector.mapVehicleOptimize(scooter.optimizeType(), scooter.optimizeTriangle(), VehicleOptimizationTypeMapper::mapForScooter));
        DefaultValueInjector.setScooterRentalDefaults(scooter.rental(), builder);
    }

    private static void setScooterRentalDefaults(VehicleRentalPreferences rental, DefaultMappingBuilder builder) {
        builder.arrayStringsOpt("ScooterRentalPreferencesInput.allowedNetworks", rental.allowedNetworks().isEmpty() ? null : rental.allowedNetworks()).arrayStringsReq("ScooterRentalPreferencesInput.bannedNetworks", rental.bannedNetworks()).boolReq("DestinationScooterPolicyInput.allowKeeping", rental.allowArrivingInRentedVehicleAtDestination()).intReq("DestinationScooterPolicyInput.keepingCost", rental.arrivingInRentalVehicleAtDestinationCost().toSeconds());
    }

    private static void setTransitDefaults(TransitPreferences transit, DefaultMappingBuilder builder) {
        builder.stringReq("AlightPreferencesInput.slack", transit.alightSlack().defaultValue()).stringReq("BoardPreferencesInput.slack", transit.boardSlack().defaultValue()).boolReq("TimetablePreferencesInput.excludeRealTimeUpdates", transit.ignoreRealtimeUpdates()).boolReq("TimetablePreferencesInput.includePlannedCancellations", transit.includePlannedCancellations()).boolReq("TimetablePreferencesInput.includeRealTimeCancellations", transit.includeRealtimeCancellations());
    }

    private static void setTransferDefaults(TransferPreferences transfer, DefaultMappingBuilder builder) {
        builder.floatReq("BoardPreferencesInput.waitReluctance", transfer.waitReluctance()).intReq("TransferPreferencesInput.cost", transfer.cost()).intReq("TransferPreferencesInput.maximumAdditionalTransfers", transfer.maxAdditionalTransfers()).intReq("TransferPreferencesInput.maximumTransfers", transfer.maxTransfers() - 1).stringReq("TransferPreferencesInput.slack", transfer.slack());
    }

    private static void setWalkDefaults(WalkPreferences walk, DefaultMappingBuilder builder) {
        builder.intReq("WalkPreferencesInput.boardCost", walk.boardCost()).floatReq("WalkPreferencesInput.reluctance", walk.reluctance()).floatReq("WalkPreferencesInput.safetyFactor", walk.safetyFactor()).floatReq("WalkPreferencesInput.speed", walk.speed());
    }

    private static void setWheelchairDefaults(RouteRequest defaultRouteRequest, DefaultMappingBuilder builder) {
        builder.boolReq("WheelchairPreferencesInput.enabled", defaultRouteRequest.journey().wheelchair());
    }

    private static ArrayValue mapTransitModes(Map<TransitMode, Double> reluctanceForMode) {
        List<Value> modesWithReluctance = Arrays.stream(GraphQLTypes.GraphQLTransitMode.values()).map(mode -> DefaultValueInjector.mapTransitMode(mode, (Double)reluctanceForMode.get(TransitModeMapper.map(mode)))).toList();
        return ArrayValue.newArrayValue().values(modesWithReluctance).build();
    }

    private static Value mapTransitMode(GraphQLTypes.GraphQLTransitMode mode, @Nullable Double reluctance) {
        ObjectValue.Builder objectBuilder = ObjectValue.newObjectValue().objectField(ObjectField.newObjectField().name("mode").value((Value)EnumValue.of((String)mode.name())).build());
        if (reluctance != null) {
            objectBuilder.objectField(ObjectField.newObjectField().name("cost").value((Value)ObjectValue.newObjectValue().objectField(ObjectField.newObjectField().name("reluctance").value((Value)FloatValue.of((double)reluctance)).build()).build()).build());
        }
        return objectBuilder.build();
    }

    private static ObjectValue mapVehicleOptimize(VehicleRoutingOptimizeType type, TimeSlopeSafetyTriangle triangle, Function<VehicleRoutingOptimizeType, Enum> typeMapper) {
        ObjectField optimizationField = type == VehicleRoutingOptimizeType.TRIANGLE ? ObjectField.newObjectField().name("triangle").value((Value)ObjectValue.newObjectValue().objectField(ObjectField.newObjectField().name("flatness").value((Value)FloatValue.of((double)triangle.slope())).build()).objectField(ObjectField.newObjectField().name("safety").value((Value)FloatValue.of((double)triangle.safety())).build()).objectField(ObjectField.newObjectField().name("time").value((Value)FloatValue.of((double)triangle.time())).build()).build()).build() : ObjectField.newObjectField().name("type").value((Value)EnumValue.of((String)typeMapper.apply(type).name())).build();
        return ObjectValue.newObjectValue().objectField(optimizationField).build();
    }

    private static ArrayValue mapVehicleParkingFilter(VehicleParkingFilter filter) {
        ArrayValue.Builder arrayBuilder = ArrayValue.newArrayValue();
        if (!filter.not().isEmpty() || !filter.select().isEmpty()) {
            arrayBuilder.value((Value)ObjectValue.newObjectValue().objectField(DefaultValueInjector.mapVehicleParkingSelects("not", filter.not())).objectField(DefaultValueInjector.mapVehicleParkingSelects("select", filter.select())).build());
        }
        return arrayBuilder.build();
    }

    private static ObjectField mapVehicleParkingSelects(String fieldName, List<VehicleParkingSelect> selectList) {
        List<Value> selects = selectList.stream().map(select -> ObjectValue.newObjectValue().objectField(ObjectField.newObjectField().name("tags").value((Value)ArrayValue.newArrayValue().values(select.tags().stream().map(tag -> StringValue.of((String)tag)).toList()).build()).build()).build()).toList();
        return ObjectField.newObjectField().name(fieldName).value((Value)ArrayValue.newArrayValue().values(selects).build()).build();
    }

    private static class DefaultMappingBuilder {
        private final Map<String, Value<?>> defaultValueForKey = new HashMap();

        private DefaultMappingBuilder() {
        }

        public DefaultMappingBuilder intReq(String key, int value) {
            this.defaultValueForKey.put(key, (Value<?>)IntValue.of((int)value));
            return this;
        }

        public DefaultMappingBuilder floatReq(String key, double value) {
            this.defaultValueForKey.put(key, (Value<?>)FloatValue.of((double)value));
            return this;
        }

        public DefaultMappingBuilder stringReq(String key, Object value) {
            this.defaultValueForKey.put(key, (Value<?>)StringValue.of((String)value.toString()));
            return this;
        }

        public DefaultMappingBuilder stringOpt(String key, @Nullable Object value) {
            if (value != null) {
                this.defaultValueForKey.put(key, (Value<?>)StringValue.of((String)value.toString()));
            }
            return this;
        }

        public DefaultMappingBuilder boolReq(String key, boolean value) {
            this.defaultValueForKey.put(key, (Value<?>)BooleanValue.of((boolean)value));
            return this;
        }

        public DefaultMappingBuilder enumListReq(String key, List<Enum> valueList) {
            this.defaultValueForKey.put(key, (Value<?>)ArrayValue.newArrayValue().values(valueList.stream().map(value -> new EnumValue(value.name())).toList()).build());
            return this;
        }

        public DefaultMappingBuilder objectReq(String key, ObjectValue value) {
            this.defaultValueForKey.put(key, (Value<?>)value);
            return this;
        }

        public DefaultMappingBuilder arrayReq(String key, ArrayValue value) {
            this.defaultValueForKey.put(key, (Value<?>)value);
            return this;
        }

        public DefaultMappingBuilder arrayStringsReq(String key, Collection<String> values) {
            this.defaultValueForKey.put(key, (Value<?>)ArrayValue.newArrayValue().values(values.stream().map(value -> StringValue.of((String)value)).toList()).build());
            return this;
        }

        public DefaultMappingBuilder arrayStringsOpt(String key, @Nullable Collection<String> values) {
            if (values != null) {
                this.defaultValueForKey.put(key, (Value<?>)ArrayValue.newArrayValue().values(values.stream().map(value -> StringValue.of((String)value)).toList()).build());
            }
            return this;
        }

        public Map<String, Value<?>> build() {
            return this.defaultValueForKey;
        }
    }
}

