/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opentripplanner.api.resource.ServerInfo;
import org.opentripplanner.api.resource.UpdaterStatusResource;
import org.opentripplanner.apis.gtfs.GtfsGraphQLAPI;
import org.opentripplanner.apis.transmodel.TransmodelAPI;
import org.opentripplanner.apis.vectortiles.DebugVectorTilesResource;
import org.opentripplanner.ext.actuator.ActuatorAPI;
import org.opentripplanner.ext.debugrastertiles.api.resource.DebugRasterTileResource;
import org.opentripplanner.ext.geocoder.GeocoderResource;
import org.opentripplanner.ext.parkAndRideApi.ParkAndRideResource;
import org.opentripplanner.ext.reportapi.resource.ReportResource;
import org.opentripplanner.ext.trias.trias.TriasResource;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.framework.application.OTPFeature;

public class APIEndpoints {
    private final List<Class<?>> resources = new ArrayList();

    private APIEndpoints() {
        this.addIfEnabled(OTPFeature.APIServerInfo, ServerInfo.class);
        this.addIfEnabled(OTPFeature.APIUpdaterStatus, UpdaterStatusResource.class);
        this.addIfEnabled(OTPFeature.DebugUi, DebugVectorTilesResource.class);
        this.addIfEnabled(OTPFeature.GtfsGraphQlApi, GtfsGraphQLAPI.class);
        this.addIfEnabled(OTPFeature.GtfsGraphQlApi, GtfsGraphQLAPI.GtfsGraphQLAPIOldPath.class);
        this.addIfEnabled(OTPFeature.TransmodelGraphQlApi, TransmodelAPI.class);
        this.addIfEnabled(OTPFeature.TransmodelGraphQlApi, TransmodelAPI.TransmodelAPIOldPath.class);
        this.addIfEnabled(OTPFeature.ActuatorAPI, ActuatorAPI.class);
        this.addIfEnabled(OTPFeature.DebugRasterTiles, DebugRasterTileResource.class);
        this.addIfEnabled(OTPFeature.ReportApi, ReportResource.class);
        this.addIfEnabled(OTPFeature.SandboxAPIMapboxVectorTilesApi, VectorTilesResource.class);
        this.addIfEnabled(OTPFeature.SandboxAPIParkAndRideApi, ParkAndRideResource.class);
        this.addIfEnabled(OTPFeature.SandboxAPIGeocoder, GeocoderResource.class);
        this.addIfEnabled(OTPFeature.TriasApi, TriasResource.class);
    }

    public static Collection<? extends Class<?>> listAPIEndpoints() {
        return Collections.unmodifiableCollection(new APIEndpoints().resources);
    }

    private void addIfEnabled(OTPFeature apiFeature, Class<?> resource) {
        if (apiFeature.isOn()) {
            this.add(resource);
        }
    }

    private void add(Class<?> resource) {
        this.resources.add(resource);
    }
}

