/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.parameter;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.opentripplanner.api.parameter.ApiRequestMode;
import org.opentripplanner.api.parameter.QualifiedMode;
import org.opentripplanner.api.parameter.Qualifier;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.routing.api.request.RequestModesBuilder;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.transit.model.basic.TransitMode;

public class QualifiedModeSet
implements Serializable {
    public Set<QualifiedMode> qModes = new HashSet<QualifiedMode>();

    public QualifiedModeSet(String[] modes) {
        for (String qMode : modes) {
            this.qModes.add(new QualifiedMode(qMode));
        }
    }

    public QualifiedModeSet(String s) {
        this(s.split(","));
    }

    public List<TransitMode> getTransitModes() {
        return this.qModes.stream().flatMap(qMode -> qMode.mode.getTransitModes().stream()).toList();
    }

    public RequestModes getRequestModes() {
        RequestModesBuilder mBuilder = RequestModes.of();
        QualifiedMode requestMode = null;
        List<QualifiedMode> filteredModes = this.qModes.stream().filter(m -> m.mode == ApiRequestMode.WALK || m.mode == ApiRequestMode.BICYCLE || m.mode == ApiRequestMode.SCOOTER || m.mode == ApiRequestMode.CAR).toList();
        if (filteredModes.size() > 1) {
            List<QualifiedMode> filteredModesWithoutWalk = filteredModes.stream().filter(Predicate.not(m -> m.mode == ApiRequestMode.WALK)).toList();
            if (filteredModesWithoutWalk.size() > 1) {
                throw new IllegalStateException("Multiple non-walk modes provided " + String.valueOf(filteredModesWithoutWalk));
            }
            requestMode = filteredModesWithoutWalk.isEmpty() ? filteredModes.get(0) : filteredModesWithoutWalk.get(0);
        } else if (!filteredModes.isEmpty()) {
            requestMode = filteredModes.get(0);
        }
        if (requestMode != null) {
            switch (requestMode.mode) {
                case WALK: {
                    mBuilder.withAllStreetModes(StreetMode.WALK);
                    break;
                }
                case BICYCLE: {
                    if (requestMode.qualifiers.contains((Object)Qualifier.RENT)) {
                        mBuilder.withAllStreetModes(StreetMode.BIKE_RENTAL);
                        mBuilder.withTransferMode(StreetMode.WALK);
                        break;
                    }
                    if (requestMode.qualifiers.contains((Object)Qualifier.PARK)) {
                        mBuilder.withAccessMode(StreetMode.BIKE_TO_PARK);
                        mBuilder.withEgressMode(StreetMode.WALK);
                        mBuilder.withDirectMode(StreetMode.BIKE_TO_PARK);
                        mBuilder.withTransferMode(StreetMode.WALK);
                        break;
                    }
                    mBuilder.withAllStreetModes(StreetMode.BIKE);
                    break;
                }
                case SCOOTER: {
                    if (requestMode.qualifiers.contains((Object)Qualifier.RENT)) {
                        mBuilder.withAllStreetModes(StreetMode.SCOOTER_RENTAL);
                        mBuilder.withTransferMode(StreetMode.WALK);
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case CAR: {
                    if (requestMode.qualifiers.contains((Object)Qualifier.RENT)) {
                        mBuilder.withAllStreetModes(StreetMode.CAR_RENTAL);
                        mBuilder.withTransferMode(StreetMode.WALK);
                        break;
                    }
                    if (requestMode.qualifiers.contains((Object)Qualifier.PARK)) {
                        mBuilder.withAccessMode(StreetMode.CAR_TO_PARK);
                        mBuilder.withTransferMode(StreetMode.WALK);
                        mBuilder.withEgressMode(StreetMode.WALK);
                        mBuilder.withDirectMode(StreetMode.CAR_TO_PARK);
                        break;
                    }
                    if (requestMode.qualifiers.contains((Object)Qualifier.PICKUP)) {
                        mBuilder.withAccessMode(StreetMode.WALK);
                        mBuilder.withTransferMode(StreetMode.WALK);
                        mBuilder.withEgressMode(StreetMode.CAR_PICKUP);
                        mBuilder.withDirectMode(StreetMode.CAR_PICKUP);
                        break;
                    }
                    if (requestMode.qualifiers.contains((Object)Qualifier.DROPOFF)) {
                        mBuilder.withAccessMode(StreetMode.CAR_PICKUP);
                        mBuilder.withTransferMode(StreetMode.WALK);
                        mBuilder.withEgressMode(StreetMode.WALK);
                        mBuilder.withDirectMode(StreetMode.CAR_PICKUP);
                        break;
                    }
                    if (requestMode.qualifiers.contains((Object)Qualifier.HAIL)) {
                        mBuilder.withAccessMode(StreetMode.CAR_HAILING);
                        mBuilder.withTransferMode(StreetMode.WALK);
                        mBuilder.withEgressMode(StreetMode.CAR_HAILING);
                        mBuilder.withDirectMode(StreetMode.WALK);
                        break;
                    }
                    mBuilder.withAccessMode(StreetMode.CAR);
                    mBuilder.withTransferMode(StreetMode.CAR);
                    mBuilder.withEgressMode(StreetMode.CAR);
                    mBuilder.withDirectMode(StreetMode.CAR);
                }
            }
        }
        for (QualifiedMode qMode : this.qModes) {
            if (!qMode.mode.equals((Object)ApiRequestMode.FLEX)) continue;
            if (qMode.qualifiers.contains((Object)Qualifier.ACCESS)) {
                mBuilder.withAccessMode(StreetMode.FLEXIBLE);
                continue;
            }
            if (qMode.qualifiers.contains((Object)Qualifier.EGRESS)) {
                mBuilder.withEgressMode(StreetMode.FLEXIBLE);
                continue;
            }
            if (!qMode.qualifiers.contains((Object)Qualifier.DIRECT)) continue;
            mBuilder.withDirectMode(StreetMode.FLEXIBLE);
        }
        return mBuilder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (QualifiedMode qm : this.qModes) {
            sb.append(qm.toString());
            sb.append(" ");
        }
        return sb.toString();
    }
}

