/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.framework.http.OtpHttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class OTPExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(OTPExceptionMapper.class);

    public Response toResponse(Exception ex) {
        if (ex instanceof WebApplicationException) {
            String header = "";
            if (ex instanceof BadRequestException) {
                header = "FOUR HUNDRED\n\n";
            } else if (ex instanceof NotFoundException) {
                header = "FOUR ZERO FOUR\n\n";
            }
            return Response.fromResponse((Response)((WebApplicationException)ex).getResponse()).entity((Object)(header + ex.getMessage())).build();
        }
        if (ex instanceof OtpAppException) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("OTP Application error: " + ex.getMessage())).type("text/plain").build();
        }
        if (ex instanceof OTPRequestTimeoutException) {
            return Response.status((Response.StatusType)OtpHttpStatus.STATUS_UNPROCESSABLE_ENTITY).entity((Object)"OTP API Processing Timeout").type("text/plain").build();
        }
        if (ex instanceof JsonParseException || ex instanceof MismatchedInputException) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).type("text/plain").build();
        }
        LOG.error("Unhandled exception", (Throwable)ex);
        return Response.serverError().entity((Object)(ex.toString() + " " + ex.getMessage())).type("text/plain").build();
    }
}

