/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.common;

import java.util.Locale;
import org.opentripplanner.framework.resources.ResourceBundleAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Message {
    PLAN_OK(200),
    SYSTEM_ERROR(500),
    UNPROCESSABLE_REQUEST(422),
    GRAPH_UNAVAILABLE(503),
    OUTSIDE_BOUNDS(400),
    PATH_NOT_FOUND(404),
    NO_TRANSIT_TIMES(406),
    BOGUS_PARAMETER(413),
    GEOCODE_FROM_NOT_FOUND(440),
    GEOCODE_TO_NOT_FOUND(450),
    GEOCODE_FROM_TO_NOT_FOUND(460),
    GEOCODE_INTERMEDIATE_NOT_FOUND(465),
    TOO_CLOSE(409),
    LOCATION_NOT_ACCESSIBLE(470),
    UNDERSPECIFIED_TRIANGLE(370),
    TRIANGLE_NOT_AFFINE(371),
    TRIANGLE_OPTIMIZE_TYPE_NOT_SET(372),
    TRIANGLE_VALUES_NOT_SET(373);

    private static final Logger LOG;
    private final ResourceBundleAdaptor config = new ResourceBundleAdaptor(Message.class);
    private final int m_id;

    private Message(int id) {
        this.m_id = id;
    }

    public int getId() {
        return this.m_id;
    }

    public String get(Locale l) {
        try {
            return this.config.get(this.name(), l);
        }
        catch (Exception e) {
            LOG.warn("No entry in Message.properties file could be found for string {}", (Object)this.name());
            return "";
        }
    }

    public String get() {
        return this.get(Locale.getDefault());
    }

    static {
        LOG = LoggerFactory.getLogger(Message.class);
    }
}

