package org.opentripplanner.standalone.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.io.File;
import javax.annotation.processing.Generated;
import org.opentripplanner.datastore.OtpDataStore;
import org.opentripplanner.datastore.api.OtpDataStoreConfig;
import org.opentripplanner.datastore.base.DataSourceRepository;
import org.opentripplanner.datastore.configure.DataStoreModule_ProvideDataStoreFactory;
import org.opentripplanner.ext.datastore.gs.GsDataSourceModule;
import org.opentripplanner.ext.datastore.gs.GsDataSourceModule_ProvideGoogleStorageDataSourceRepositoryFactory;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.emission.configure.EmissionRepositoryModule_ProvideEmissionRepositoryFactory;
import org.opentripplanner.ext.fares.configure.FareModule;
import org.opentripplanner.ext.fares.configure.FareModule_FactoryFactory;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.ext.stopconsolidation.internal.DefaultStopConsolidationRepository;
import org.opentripplanner.ext.stopconsolidation.internal.DefaultStopConsolidationRepository_Factory;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.GraphBuilderDataSources_Factory;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.osminfo.internal.DefaultOsmInfoGraphBuildRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.internal.DefaultVehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.internal.DefaultVehicleParkingRepository_Factory;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.service.worldenvelope.internal.DefaultWorldEnvelopeRepository;
import org.opentripplanner.service.worldenvelope.internal.DefaultWorldEnvelopeRepository_Factory;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.OtpConfigLoader;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvideBuildConfigFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_BaseDirectoryFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesConfigLoaderFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesDataStoreConfigFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesModelFactory;
import org.opentripplanner.standalone.config.configure.LoadConfigModule_ProvidesTransitServicePeriodFactory;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.service.SiteRepository;
import org.opentripplanner.transit.service.TimetableRepository;

@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class DaggerLoadApplicationFactory {
  private DaggerLoadApplicationFactory() {
  }

  public static LoadApplicationFactory.Builder builder() {
    return new Builder();
  }

  private static final class Builder implements LoadApplicationFactory.Builder {
    private CommandLineParameters commandLineParameters;

    @Override
    public Builder commandLineParameters(CommandLineParameters cli) {
      this.commandLineParameters = Preconditions.checkNotNull(cli);
      return this;
    }

    @Override
    public LoadApplicationFactory build() {
      Preconditions.checkBuilderRequirement(commandLineParameters, CommandLineParameters.class);
      return new LoadApplicationFactoryImpl(new GsDataSourceModule(), new FareModule(), commandLineParameters);
    }
  }

  private static final class LoadApplicationFactoryImpl implements LoadApplicationFactory {
    private final LoadApplicationFactoryImpl loadApplicationFactoryImpl = this;

    Provider<CommandLineParameters> commandLineParametersProvider;

    Provider<File> baseDirectoryProvider;

    Provider<OtpConfigLoader> providesConfigLoaderProvider;

    Provider<ConfigModel> providesModelProvider;

    Provider<BuildConfig> provideBuildConfigProvider;

    Provider<OtpDataStoreConfig> providesDataStoreConfigProvider;

    Provider<DataSourceRepository> provideGoogleStorageDataSourceRepositoryProvider;

    Provider<OtpDataStore> provideDataStoreProvider;

    Provider<DefaultWorldEnvelopeRepository> defaultWorldEnvelopeRepositoryProvider;

    Provider<GraphBuilderDataSources> graphBuilderDataSourcesProvider;

    Provider<EmissionRepository> provideEmissionRepositoryProvider;

    Provider<DefaultStopConsolidationRepository> defaultStopConsolidationRepositoryProvider;

    Provider<FareServiceFactory> factoryProvider;

    Provider<DefaultVehicleParkingRepository> defaultVehicleParkingRepositoryProvider;

    LoadApplicationFactoryImpl(GsDataSourceModule gsDataSourceModuleParam,
        FareModule fareModuleParam, CommandLineParameters commandLineParametersParam) {

      initialize(gsDataSourceModuleParam, fareModuleParam, commandLineParametersParam);

    }

    BuildConfig buildConfig() {
      return ConfigModule_ProvideBuildConfigFactory.provideBuildConfig(providesModelProvider.get());
    }

    ServiceDateInterval transitServicePeriodServiceDateInterval() {
      return LoadConfigModule_ProvidesTransitServicePeriodFactory.providesTransitServicePeriod(buildConfig());
    }

    OpeningHoursCalendarService openingHoursCalendarService() {
      return new OpeningHoursCalendarService(new Deduplicator(), transitServicePeriodServiceDateInterval());
    }

    @SuppressWarnings("unchecked")
    private void initialize(final GsDataSourceModule gsDataSourceModuleParam,
        final FareModule fareModuleParam, final CommandLineParameters commandLineParametersParam) {
      this.commandLineParametersProvider = InstanceFactory.create(commandLineParametersParam);
      this.baseDirectoryProvider = LoadConfigModule_BaseDirectoryFactory.create(commandLineParametersProvider);
      this.providesConfigLoaderProvider = LoadConfigModule_ProvidesConfigLoaderFactory.create(baseDirectoryProvider);
      this.providesModelProvider = DoubleCheck.provider(LoadConfigModule_ProvidesModelFactory.create(providesConfigLoaderProvider));
      this.provideBuildConfigProvider = ConfigModule_ProvideBuildConfigFactory.create(providesModelProvider);
      this.providesDataStoreConfigProvider = LoadConfigModule_ProvidesDataStoreConfigFactory.create(provideBuildConfigProvider);
      this.provideGoogleStorageDataSourceRepositoryProvider = DoubleCheck.provider(GsDataSourceModule_ProvideGoogleStorageDataSourceRepositoryFactory.create(gsDataSourceModuleParam, providesDataStoreConfigProvider));
      this.provideDataStoreProvider = DoubleCheck.provider(DataStoreModule_ProvideDataStoreFactory.create(baseDirectoryProvider, providesDataStoreConfigProvider, provideGoogleStorageDataSourceRepositoryProvider));
      this.defaultWorldEnvelopeRepositoryProvider = DoubleCheck.provider(DefaultWorldEnvelopeRepository_Factory.create());
      this.graphBuilderDataSourcesProvider = DoubleCheck.provider(GraphBuilderDataSources_Factory.create(commandLineParametersProvider, provideBuildConfigProvider, provideDataStoreProvider, baseDirectoryProvider));
      this.provideEmissionRepositoryProvider = DoubleCheck.provider(EmissionRepositoryModule_ProvideEmissionRepositoryFactory.create(provideBuildConfigProvider));
      this.defaultStopConsolidationRepositoryProvider = DoubleCheck.provider(DefaultStopConsolidationRepository_Factory.create());
      this.factoryProvider = DoubleCheck.provider(FareModule_FactoryFactory.create(fareModuleParam, provideBuildConfigProvider));
      this.defaultVehicleParkingRepositoryProvider = DoubleCheck.provider(DefaultVehicleParkingRepository_Factory.create());
    }

    @Override
    public OtpDataStore datastore() {
      return provideDataStoreProvider.get();
    }

    @Override
    public ConfigModel configModel() {
      return providesModelProvider.get();
    }

    @Override
    public Graph emptyGraph() {
      return new Graph(new Deduplicator(), openingHoursCalendarService());
    }

    @Override
    public OsmInfoGraphBuildRepository emptyOsmInfoGraphBuildRepository() {
      return new DefaultOsmInfoGraphBuildRepository();
    }

    @Override
    public TimetableRepository emptyTimetableRepository() {
      return new TimetableRepository(new SiteRepository(), new Deduplicator());
    }

    @Override
    public WorldEnvelopeRepository emptyWorldEnvelopeRepository() {
      return defaultWorldEnvelopeRepositoryProvider.get();
    }

    @Override
    public GraphBuilderDataSources graphBuilderDataSources() {
      return graphBuilderDataSourcesProvider.get();
    }

    @Override
    public EmissionRepository emptyEmissionsDataModel() {
      return provideEmissionRepositoryProvider.get();
    }

    @Override
    public StopConsolidationRepository emptyStopConsolidationRepository() {
      return defaultStopConsolidationRepositoryProvider.get();
    }

    @Override
    public StreetLimitationParameters emptyStreetLimitationParameters() {
      return new StreetLimitationParameters();
    }

    @Override
    public FareServiceFactory emptyFareServiceFactory() {
      return factoryProvider.get();
    }

    @Override
    public VehicleParkingRepository emptyVehicleParkingRepository() {
      return defaultVehicleParkingRepositoryProvider.get();
    }
  }
}
