package org.opentripplanner.standalone.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import graphql.schema.GraphQLSchema;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.opentripplanner.apis.gtfs.configure.SchemaModule;
import org.opentripplanner.apis.gtfs.configure.SchemaModule_ProvideSchemaFactory;
import org.opentripplanner.apis.transmodel.configure.TransmodelSchemaModule;
import org.opentripplanner.apis.transmodel.configure.TransmodelSchemaModule_ProvideTransmodelSchemaFactory;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.emission.configure.EmissionServiceModule;
import org.opentripplanner.ext.emission.configure.EmissionServiceModule_ProvideEmissionServiceFactory;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.ext.geocoder.configure.GeocoderModule;
import org.opentripplanner.ext.geocoder.configure.GeocoderModule_LuceneIndexFactory;
import org.opentripplanner.ext.interactivelauncher.configuration.InteractiveLauncherModule;
import org.opentripplanner.ext.interactivelauncher.configuration.InteractiveLauncherModule_RequestDecoratorFactory;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.ridehailing.configure.RideHailingServicesModule;
import org.opentripplanner.ext.ridehailing.configure.RideHailingServicesModule_ServicesFactory;
import org.opentripplanner.ext.sorlandsbanen.SorlandsbanenNorwayService;
import org.opentripplanner.ext.sorlandsbanen.configure.SorlandsbanenNorwayModule;
import org.opentripplanner.ext.sorlandsbanen.configure.SorlandsbanenNorwayModule_ProvidesSorlandsbanenNorwayServiceFactory;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationService;
import org.opentripplanner.ext.stopconsolidation.configure.StopConsolidationServiceModule;
import org.opentripplanner.ext.stopconsolidation.configure.StopConsolidationServiceModule_ServiceFactory;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueSummary;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.raptor.api.request.RaptorEnvironment;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryDecorator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.RealTimeRaptorTransitDataUpdater;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.routing.linking.configure.VertexLinkerRoutingModule_LinkerFactory;
import org.opentripplanner.routing.via.ViaCoordinateTransferFactory;
import org.opentripplanner.routing.via.configure.ViaModule_ProvidesViaTransferResolverFactory;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleRepository;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleService;
import org.opentripplanner.service.realtimevehicles.internal.DefaultRealtimeVehicleService;
import org.opentripplanner.service.realtimevehicles.internal.DefaultRealtimeVehicleService_Factory;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingService;
import org.opentripplanner.service.vehicleparking.internal.DefaultVehicleParkingService;
import org.opentripplanner.service.vehicleparking.internal.DefaultVehicleParkingService_Factory;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.vehiclerental.internal.DefaultVehicleRentalService;
import org.opentripplanner.service.vehiclerental.internal.DefaultVehicleRentalService_Factory;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeService;
import org.opentripplanner.service.worldenvelope.internal.DefaultWorldEnvelopeService;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.DebugUiConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvideBuildConfigFactory;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvideDebugUiConfigFactory;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvideRouterConfigFactory;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvidesRaptorConfigFactory;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvidesRaptorEnvironmentFactory;
import org.opentripplanner.standalone.server.MetricsLogging;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.street.service.StreetLimitationParametersService;
import org.opentripplanner.street.service.StreetLimitationParametersServiceModule;
import org.opentripplanner.street.service.StreetLimitationParametersServiceModule_ProvideStreetLimitationParametersServiceFactory;
import org.opentripplanner.transit.configure.TransitModule_RealtimeRaptorTransitDataUpdaterFactory;
import org.opentripplanner.transit.configure.TransitModule_TimetableSnapshotFactory;
import org.opentripplanner.transit.configure.TransitModule_TimetableSnapshotManagerFactory;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.DefaultTransitService_Factory;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.updater.trip.TimetableSnapshotManager;
import org.opentripplanner.visualizer.GraphVisualizer;

@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class DaggerConstructApplicationFactory {
  private DaggerConstructApplicationFactory() {
  }

  public static ConstructApplicationFactory.Builder builder() {
    return new Builder();
  }

  private static final class Builder implements ConstructApplicationFactory.Builder {
    private ConfigModel configModel;

    private Graph graph;

    private TimetableRepository timetableRepository;

    private GraphVisualizer graphVisualizer;

    private WorldEnvelopeRepository worldEnvelopeRepository;

    private StopConsolidationRepository stopConsolidationRepository;

    private VehicleParkingRepository vehicleParkingRepository;

    private DataImportIssueSummary dataImportIssueSummary;

    private EmissionRepository emissionRepository;

    private RouteRequest schema;

    private StreetLimitationParameters streetLimitationParameters;

    private FareServiceFactory fareServiceFactory;

    @Override
    public Builder configModel(ConfigModel config) {
      this.configModel = Preconditions.checkNotNull(config);
      return this;
    }

    @Override
    public Builder graph(Graph graph) {
      this.graph = Preconditions.checkNotNull(graph);
      return this;
    }

    @Override
    public Builder timetableRepository(TimetableRepository timetableRepository) {
      this.timetableRepository = Preconditions.checkNotNull(timetableRepository);
      return this;
    }

    @Override
    public Builder graphVisualizer(@Nullable GraphVisualizer graphVisualizer) {
      this.graphVisualizer = graphVisualizer;
      return this;
    }

    @Override
    public Builder worldEnvelopeRepository(WorldEnvelopeRepository worldEnvelopeRepository) {
      this.worldEnvelopeRepository = Preconditions.checkNotNull(worldEnvelopeRepository);
      return this;
    }

    @Override
    public Builder stopConsolidationRepository(
        @Nullable StopConsolidationRepository stopConsolidationRepository) {
      this.stopConsolidationRepository = stopConsolidationRepository;
      return this;
    }

    @Override
    public Builder vehicleParkingRepository(VehicleParkingRepository parkingRepository) {
      this.vehicleParkingRepository = Preconditions.checkNotNull(parkingRepository);
      return this;
    }

    @Override
    public Builder dataImportIssueSummary(DataImportIssueSummary issueSummary) {
      this.dataImportIssueSummary = Preconditions.checkNotNull(issueSummary);
      return this;
    }

    @Override
    public Builder emissionRepository(EmissionRepository emissionRepository) {
      this.emissionRepository = Preconditions.checkNotNull(emissionRepository);
      return this;
    }

    @Override
    public Builder schema(RouteRequest defaultRouteRequest) {
      this.schema = Preconditions.checkNotNull(defaultRouteRequest);
      return this;
    }

    @Override
    public Builder streetLimitationParameters(
        StreetLimitationParameters streetLimitationParameters) {
      this.streetLimitationParameters = Preconditions.checkNotNull(streetLimitationParameters);
      return this;
    }

    @Override
    public Builder fareServiceFactory(FareServiceFactory fareService) {
      this.fareServiceFactory = Preconditions.checkNotNull(fareService);
      return this;
    }

    @Override
    public ConstructApplicationFactory build() {
      Preconditions.checkBuilderRequirement(configModel, ConfigModel.class);
      Preconditions.checkBuilderRequirement(graph, Graph.class);
      Preconditions.checkBuilderRequirement(timetableRepository, TimetableRepository.class);
      Preconditions.checkBuilderRequirement(worldEnvelopeRepository, WorldEnvelopeRepository.class);
      Preconditions.checkBuilderRequirement(vehicleParkingRepository, VehicleParkingRepository.class);
      Preconditions.checkBuilderRequirement(dataImportIssueSummary, DataImportIssueSummary.class);
      Preconditions.checkBuilderRequirement(emissionRepository, EmissionRepository.class);
      Preconditions.checkBuilderRequirement(schema, RouteRequest.class);
      Preconditions.checkBuilderRequirement(streetLimitationParameters, StreetLimitationParameters.class);
      Preconditions.checkBuilderRequirement(fareServiceFactory, FareServiceFactory.class);
      return new ConstructApplicationFactoryImpl(new ConstructApplicationModule(), new EmissionServiceModule(), new GeocoderModule(), new InteractiveLauncherModule(), new RideHailingServicesModule(), new SchemaModule(), new TransmodelSchemaModule(), new SorlandsbanenNorwayModule(), new StopConsolidationServiceModule(), new StreetLimitationParametersServiceModule(), configModel, graph, timetableRepository, graphVisualizer, worldEnvelopeRepository, stopConsolidationRepository, vehicleParkingRepository, dataImportIssueSummary, emissionRepository, schema, streetLimitationParameters, fareServiceFactory);
    }
  }

  private static final class ConstructApplicationFactoryImpl implements ConstructApplicationFactory {
    private final ConfigModel configModel;

    private final Graph graph;

    private final TimetableRepository timetableRepository;

    private final WorldEnvelopeRepository worldEnvelopeRepository;

    private final VehicleParkingRepository vehicleParkingRepository;

    private final DataImportIssueSummary dataImportIssueSummary;

    private final EmissionRepository emissionRepository;

    @Nullable
    private final GraphVisualizer graphVisualizer;

    private final ConstructApplicationModule constructApplicationModule;

    private final EmissionServiceModule emissionServiceModule;

    private final SorlandsbanenNorwayModule sorlandsbanenNorwayModule;

    private final InteractiveLauncherModule interactiveLauncherModule;

    @Nullable
    private final StopConsolidationRepository stopConsolidationRepository;

    private final StreetLimitationParameters streetLimitationParameters;

    private final FareServiceFactory fareServiceFactory;

    private final ConstructApplicationFactoryImpl constructApplicationFactoryImpl = this;

    Provider<ConfigModel> configModelProvider;

    Provider<RouterConfig> provideRouterConfigProvider;

    Provider<RaptorEnvironment> providesRaptorEnvironmentProvider;

    Provider<RaptorConfig<TripSchedule>> providesRaptorConfigProvider;

    Provider<Graph> graphProvider;

    Provider<StreetLimitationParameters> streetLimitationParametersProvider;

    Provider<VertexLinker> linkerProvider;

    Provider<TimetableRepository> timetableRepositoryProvider;

    Provider<RealTimeRaptorTransitDataUpdater> realtimeRaptorTransitDataUpdaterProvider;

    Provider<TimetableSnapshotManager> timetableSnapshotManagerProvider;

    Provider<TimetableSnapshot> timetableSnapshotProvider;

    Provider<DefaultTransitService> defaultTransitServiceProvider;

    Provider<DefaultRealtimeVehicleService> defaultRealtimeVehicleServiceProvider;

    Provider<DefaultVehicleRentalService> defaultVehicleRentalServiceProvider;

    Provider<VehicleParkingRepository> vehicleParkingRepositoryProvider;

    Provider<DefaultVehicleParkingService> defaultVehicleParkingServiceProvider;

    Provider<List<RideHailingService>> servicesProvider;

    Provider<StopConsolidationRepository> stopConsolidationRepositoryProvider;

    Provider<StopConsolidationService> serviceProvider;

    Provider<StreetLimitationParametersService> provideStreetLimitationParametersServiceProvider;

    Provider<RouteRequest> schemaProvider;

    Provider<GraphQLSchema> provideSchemaProvider;

    Provider<GraphQLSchema> provideTransmodelSchemaProvider;

    Provider<LuceneIndex> luceneIndexProvider;

    Provider<FareServiceFactory> fareServiceFactoryProvider;

    Provider<FareService> fareServiceProvider;

    ConstructApplicationFactoryImpl(ConstructApplicationModule constructApplicationModuleParam,
        EmissionServiceModule emissionServiceModuleParam, GeocoderModule geocoderModuleParam,
        InteractiveLauncherModule interactiveLauncherModuleParam,
        RideHailingServicesModule rideHailingServicesModuleParam, SchemaModule schemaModuleParam,
        TransmodelSchemaModule transmodelSchemaModuleParam,
        SorlandsbanenNorwayModule sorlandsbanenNorwayModuleParam,
        StopConsolidationServiceModule stopConsolidationServiceModuleParam,
        StreetLimitationParametersServiceModule streetLimitationParametersServiceModuleParam,
        ConfigModel configModelParam, Graph graphParam,
        TimetableRepository timetableRepositoryParam, GraphVisualizer graphVisualizerParam,
        WorldEnvelopeRepository worldEnvelopeRepositoryParam,
        StopConsolidationRepository stopConsolidationRepositoryParam,
        VehicleParkingRepository vehicleParkingRepositoryParam,
        DataImportIssueSummary dataImportIssueSummaryParam,
        EmissionRepository emissionRepositoryParam, RouteRequest schemaParam,
        StreetLimitationParameters streetLimitationParametersParam,
        FareServiceFactory fareServiceFactoryParam) {
      this.configModel = configModelParam;
      this.graph = graphParam;
      this.timetableRepository = timetableRepositoryParam;
      this.worldEnvelopeRepository = worldEnvelopeRepositoryParam;
      this.vehicleParkingRepository = vehicleParkingRepositoryParam;
      this.dataImportIssueSummary = dataImportIssueSummaryParam;
      this.emissionRepository = emissionRepositoryParam;
      this.graphVisualizer = graphVisualizerParam;
      this.constructApplicationModule = constructApplicationModuleParam;
      this.emissionServiceModule = emissionServiceModuleParam;
      this.sorlandsbanenNorwayModule = sorlandsbanenNorwayModuleParam;
      this.interactiveLauncherModule = interactiveLauncherModuleParam;
      this.stopConsolidationRepository = stopConsolidationRepositoryParam;
      this.streetLimitationParameters = streetLimitationParametersParam;
      this.fareServiceFactory = fareServiceFactoryParam;
      initialize(constructApplicationModuleParam, emissionServiceModuleParam, geocoderModuleParam, interactiveLauncherModuleParam, rideHailingServicesModuleParam, schemaModuleParam, transmodelSchemaModuleParam, sorlandsbanenNorwayModuleParam, stopConsolidationServiceModuleParam, streetLimitationParametersServiceModuleParam, configModelParam, graphParam, timetableRepositoryParam, graphVisualizerParam, worldEnvelopeRepositoryParam, stopConsolidationRepositoryParam, vehicleParkingRepositoryParam, dataImportIssueSummaryParam, emissionRepositoryParam, schemaParam, streetLimitationParametersParam, fareServiceFactoryParam);
      initialize2(constructApplicationModuleParam, emissionServiceModuleParam, geocoderModuleParam, interactiveLauncherModuleParam, rideHailingServicesModuleParam, schemaModuleParam, transmodelSchemaModuleParam, sorlandsbanenNorwayModuleParam, stopConsolidationServiceModuleParam, streetLimitationParametersServiceModuleParam, configModelParam, graphParam, timetableRepositoryParam, graphVisualizerParam, worldEnvelopeRepositoryParam, stopConsolidationRepositoryParam, vehicleParkingRepositoryParam, dataImportIssueSummaryParam, emissionRepositoryParam, schemaParam, streetLimitationParametersParam, fareServiceFactoryParam);

    }

    DefaultWorldEnvelopeService defaultWorldEnvelopeService() {
      return new DefaultWorldEnvelopeService(worldEnvelopeRepository);
    }

    TimetableSnapshot timetableSnapshot() {
      return TransitModule_TimetableSnapshotFactory.timetableSnapshot(timetableSnapshotManagerProvider.get());
    }

    DefaultTransitService defaultTransitService() {
      return new DefaultTransitService(timetableRepository, timetableSnapshot());
    }

    RouterConfig routerConfig() {
      return ConfigModule_ProvideRouterConfigFactory.provideRouterConfig(configModel);
    }

    DebugUiConfig debugUiConfig() {
      return ConfigModule_ProvideDebugUiConfigFactory.provideDebugUiConfig(configModel);
    }

    TraverseVisitor<?, ?> traverseVisitorOfAnd() {
      return constructApplicationModule.traverseVisitor(graphVisualizer);
    }

    ItineraryDecorator emissionDecoratorItineraryDecorator() {
      return EmissionServiceModule_ProvideEmissionServiceFactory.provideEmissionService(emissionServiceModule, emissionRepository);
    }

    BuildConfig buildConfig() {
      return ConfigModule_ProvideBuildConfigFactory.provideBuildConfig(configModel);
    }

    @SuppressWarnings("unchecked")
    private void initialize(final ConstructApplicationModule constructApplicationModuleParam,
        final EmissionServiceModule emissionServiceModuleParam,
        final GeocoderModule geocoderModuleParam,
        final InteractiveLauncherModule interactiveLauncherModuleParam,
        final RideHailingServicesModule rideHailingServicesModuleParam,
        final SchemaModule schemaModuleParam,
        final TransmodelSchemaModule transmodelSchemaModuleParam,
        final SorlandsbanenNorwayModule sorlandsbanenNorwayModuleParam,
        final StopConsolidationServiceModule stopConsolidationServiceModuleParam,
        final StreetLimitationParametersServiceModule streetLimitationParametersServiceModuleParam,
        final ConfigModel configModelParam, final Graph graphParam,
        final TimetableRepository timetableRepositoryParam,
        final GraphVisualizer graphVisualizerParam,
        final WorldEnvelopeRepository worldEnvelopeRepositoryParam,
        final StopConsolidationRepository stopConsolidationRepositoryParam,
        final VehicleParkingRepository vehicleParkingRepositoryParam,
        final DataImportIssueSummary dataImportIssueSummaryParam,
        final EmissionRepository emissionRepositoryParam, final RouteRequest schemaParam,
        final StreetLimitationParameters streetLimitationParametersParam,
        final FareServiceFactory fareServiceFactoryParam) {
      this.configModelProvider = InstanceFactory.create(configModelParam);
      this.provideRouterConfigProvider = ConfigModule_ProvideRouterConfigFactory.create(configModelProvider);
      this.providesRaptorEnvironmentProvider = DoubleCheck.provider(ConfigModule_ProvidesRaptorEnvironmentFactory.create(provideRouterConfigProvider));
      this.providesRaptorConfigProvider = DoubleCheck.provider(ConfigModule_ProvidesRaptorConfigFactory.create(provideRouterConfigProvider, providesRaptorEnvironmentProvider));
      this.graphProvider = InstanceFactory.create(graphParam);
      this.streetLimitationParametersProvider = InstanceFactory.create(streetLimitationParametersParam);
      this.linkerProvider = DoubleCheck.provider(VertexLinkerRoutingModule_LinkerFactory.create(graphProvider, streetLimitationParametersProvider));
      this.timetableRepositoryProvider = InstanceFactory.create(timetableRepositoryParam);
      this.realtimeRaptorTransitDataUpdaterProvider = DoubleCheck.provider(TransitModule_RealtimeRaptorTransitDataUpdaterFactory.create(timetableRepositoryProvider));
      this.timetableSnapshotManagerProvider = DoubleCheck.provider(TransitModule_TimetableSnapshotManagerFactory.create(realtimeRaptorTransitDataUpdaterProvider, configModelProvider, timetableRepositoryProvider));
      this.timetableSnapshotProvider = TransitModule_TimetableSnapshotFactory.create(timetableSnapshotManagerProvider);
      this.defaultTransitServiceProvider = DefaultTransitService_Factory.create(timetableRepositoryProvider, timetableSnapshotProvider);
      this.defaultRealtimeVehicleServiceProvider = DoubleCheck.provider(DefaultRealtimeVehicleService_Factory.create(((Provider) (defaultTransitServiceProvider))));
      this.defaultVehicleRentalServiceProvider = DoubleCheck.provider(DefaultVehicleRentalService_Factory.create());
      this.vehicleParkingRepositoryProvider = InstanceFactory.create(vehicleParkingRepositoryParam);
      this.defaultVehicleParkingServiceProvider = DoubleCheck.provider(DefaultVehicleParkingService_Factory.create(vehicleParkingRepositoryProvider));
      this.servicesProvider = DoubleCheck.provider(RideHailingServicesModule_ServicesFactory.create(rideHailingServicesModuleParam, provideRouterConfigProvider));
      this.stopConsolidationRepositoryProvider = InstanceFactory.createNullable(stopConsolidationRepositoryParam);
      this.serviceProvider = DoubleCheck.provider(StopConsolidationServiceModule_ServiceFactory.create(stopConsolidationServiceModuleParam, stopConsolidationRepositoryProvider, timetableRepositoryProvider));
      this.provideStreetLimitationParametersServiceProvider = DoubleCheck.provider(StreetLimitationParametersServiceModule_ProvideStreetLimitationParametersServiceFactory.create(streetLimitationParametersServiceModuleParam, streetLimitationParametersProvider));
      this.schemaProvider = InstanceFactory.create(schemaParam);
      this.provideSchemaProvider = DoubleCheck.provider(SchemaModule_ProvideSchemaFactory.create(schemaModuleParam, schemaProvider));
      this.provideTransmodelSchemaProvider = DoubleCheck.provider(TransmodelSchemaModule_ProvideTransmodelSchemaFactory.create(transmodelSchemaModuleParam, schemaProvider, timetableRepositoryProvider, provideRouterConfigProvider));
      this.luceneIndexProvider = DoubleCheck.provider(GeocoderModule_LuceneIndexFactory.create(geocoderModuleParam, timetableRepositoryProvider, serviceProvider));
      this.fareServiceFactoryProvider = InstanceFactory.create(fareServiceFactoryParam);
    }

    @SuppressWarnings("unchecked")
    private void initialize2(final ConstructApplicationModule constructApplicationModuleParam,
        final EmissionServiceModule emissionServiceModuleParam,
        final GeocoderModule geocoderModuleParam,
        final InteractiveLauncherModule interactiveLauncherModuleParam,
        final RideHailingServicesModule rideHailingServicesModuleParam,
        final SchemaModule schemaModuleParam,
        final TransmodelSchemaModule transmodelSchemaModuleParam,
        final SorlandsbanenNorwayModule sorlandsbanenNorwayModuleParam,
        final StopConsolidationServiceModule stopConsolidationServiceModuleParam,
        final StreetLimitationParametersServiceModule streetLimitationParametersServiceModuleParam,
        final ConfigModel configModelParam, final Graph graphParam,
        final TimetableRepository timetableRepositoryParam,
        final GraphVisualizer graphVisualizerParam,
        final WorldEnvelopeRepository worldEnvelopeRepositoryParam,
        final StopConsolidationRepository stopConsolidationRepositoryParam,
        final VehicleParkingRepository vehicleParkingRepositoryParam,
        final DataImportIssueSummary dataImportIssueSummaryParam,
        final EmissionRepository emissionRepositoryParam, final RouteRequest schemaParam,
        final StreetLimitationParameters streetLimitationParametersParam,
        final FareServiceFactory fareServiceFactoryParam) {
      this.fareServiceProvider = DoubleCheck.provider(ConstructApplicationModule_FareServiceFactory.create(constructApplicationModuleParam, fareServiceFactoryProvider));
    }

    @Override
    public ConfigModel config() {
      return configModel;
    }

    @Override
    public RaptorConfig<TripSchedule> raptorConfig() {
      return providesRaptorConfigProvider.get();
    }

    @Override
    public Graph graph() {
      return graph;
    }

    @Override
    public VertexLinker vertexLinker() {
      return linkerProvider.get();
    }

    @Override
    public TimetableRepository timetableRepository() {
      return timetableRepository;
    }

    @Override
    public WorldEnvelopeRepository worldEnvelopeRepository() {
      return worldEnvelopeRepository;
    }

    @Override
    public WorldEnvelopeService worldEnvelopeService() {
      return defaultWorldEnvelopeService();
    }

    @Override
    public RealtimeVehicleRepository realtimeVehicleRepository() {
      return defaultRealtimeVehicleServiceProvider.get();
    }

    @Override
    public RealtimeVehicleService realtimeVehicleService() {
      return defaultRealtimeVehicleServiceProvider.get();
    }

    @Override
    public VehicleRentalRepository vehicleRentalRepository() {
      return defaultVehicleRentalServiceProvider.get();
    }

    @Override
    public VehicleRentalService vehicleRentalService() {
      return defaultVehicleRentalServiceProvider.get();
    }

    @Override
    public VehicleParkingRepository vehicleParkingRepository() {
      return vehicleParkingRepository;
    }

    @Override
    public VehicleParkingService vehicleParkingService() {
      return defaultVehicleParkingServiceProvider.get();
    }

    @Override
    public TimetableSnapshotManager timetableSnapshotManager() {
      return timetableSnapshotManagerProvider.get();
    }

    @Override
    public DataImportIssueSummary dataImportIssueSummary() {
      return dataImportIssueSummary;
    }

    @Override
    @Nullable
    public EmissionRepository emissionRepository() {
      return emissionRepository;
    }

    @Override
    @Nullable
    public GraphVisualizer graphVisualizer() {
      return graphVisualizer;
    }

    @Override
    public TransitService transitService() {
      return defaultTransitService();
    }

    @Override
    public OtpServerRequestContext createServerContext() {
      return ConstructApplicationModule_ProvidesServerContextFactory.providesServerContext(constructApplicationModule, routerConfig(), debugUiConfig(), providesRaptorConfigProvider.get(), graph, linkerProvider.get(), defaultTransitService(), defaultWorldEnvelopeService(), defaultRealtimeVehicleServiceProvider.get(), defaultVehicleRentalServiceProvider.get(), defaultVehicleParkingServiceProvider.get(), servicesProvider.get(), viaTransferResolver(), serviceProvider.get(), provideStreetLimitationParametersServiceProvider.get(), traverseVisitorOfAnd(), emissionDecoratorItineraryDecorator(), provideSchemaProvider.get(), provideTransmodelSchemaProvider.get(), SorlandsbanenNorwayModule_ProvidesSorlandsbanenNorwayServiceFactory.providesSorlandsbanenNorwayService(sorlandsbanenNorwayModule), InteractiveLauncherModule_RequestDecoratorFactory.requestDecorator(interactiveLauncherModule), luceneIndexProvider.get(), fareServiceProvider.get());
    }

    @Override
    public MetricsLogging metricsLogging() {
      return new MetricsLogging(timetableRepository, providesRaptorConfigProvider.get(), dataImportIssueSummary);
    }

    @Override
    public ViaCoordinateTransferFactory viaTransferResolver() {
      return ViaModule_ProvidesViaTransferResolverFactory.providesViaTransferResolver(buildConfig(), defaultTransitService(), graph, linkerProvider.get());
    }

    @Override
    @Nullable
    public StopConsolidationRepository stopConsolidationRepository() {
      return stopConsolidationRepository;
    }

    @Override
    public StreetLimitationParameters streetLimitationParameters() {
      return streetLimitationParameters;
    }

    @Override
    @Nullable
    public SorlandsbanenNorwayService enturSorlandsbanenService() {
      return SorlandsbanenNorwayModule_ProvidesSorlandsbanenNorwayServiceFactory.providesSorlandsbanenNorwayService(sorlandsbanenNorwayModule);
    }

    @Override
    @Nullable
    public GraphQLSchema gtfsSchema() {
      return provideSchemaProvider.get();
    }

    @Override
    @Nullable
    public GraphQLSchema transmodelSchema() {
      return provideTransmodelSchemaProvider.get();
    }

    @Override
    @Nullable
    public LuceneIndex luceneIndex() {
      return luceneIndexProvider.get();
    }

    @Override
    public FareServiceFactory fareServiceFactory() {
      return fareServiceFactory;
    }
  }
}
