package org.opentripplanner.standalone.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import graphql.schema.GraphQLSchema;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.ext.interactivelauncher.api.LauncherRequestDecorator;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.sorlandsbanen.SorlandsbanenNorwayService;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationService;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryDecorator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.routing.via.ViaCoordinateTransferFactory;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleService;
import org.opentripplanner.service.vehicleparking.VehicleParkingService;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeService;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.DebugUiConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.street.service.StreetLimitationParametersService;
import org.opentripplanner.transit.service.TransitService;

@ScopeMetadata
@QualifierMetadata({
    "org.opentripplanner.routing.algorithm.filterchain.ext.EmissionDecorator",
    "org.opentripplanner.apis.gtfs.configure.GtfsSchema",
    "org.opentripplanner.apis.transmodel.configure.TransmodelSchema"
})
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class ConstructApplicationModule_ProvidesServerContextFactory implements Factory<OtpServerRequestContext> {
  private final ConstructApplicationModule module;

  private final Provider<RouterConfig> routerConfigProvider;

  private final Provider<DebugUiConfig> debugUiConfigProvider;

  private final Provider<RaptorConfig<TripSchedule>> raptorConfigProvider;

  private final Provider<Graph> graphProvider;

  private final Provider<VertexLinker> vertexLinkerProvider;

  private final Provider<TransitService> transitServiceProvider;

  private final Provider<WorldEnvelopeService> worldEnvelopeServiceProvider;

  private final Provider<RealtimeVehicleService> realtimeVehicleServiceProvider;

  private final Provider<VehicleRentalService> vehicleRentalServiceProvider;

  private final Provider<VehicleParkingService> vehicleParkingServiceProvider;

  private final Provider<List<RideHailingService>> rideHailingServicesProvider;

  private final Provider<ViaCoordinateTransferFactory> viaTransferResolverProvider;

  private final Provider<StopConsolidationService> stopConsolidationServiceProvider;

  private final Provider<StreetLimitationParametersService> streetLimitationParametersServiceProvider;

  private final Provider<TraverseVisitor<?, ?>> traverseVisitorProvider;

  private final Provider<ItineraryDecorator> emissionItineraryDecoratorProvider;

  private final Provider<GraphQLSchema> gtfsSchemaProvider;

  private final Provider<GraphQLSchema> transmodelSchemaProvider;

  private final Provider<SorlandsbanenNorwayService> sorlandsbanenServiceProvider;

  private final Provider<LauncherRequestDecorator> launcherRequestDecoratorProvider;

  private final Provider<LuceneIndex> luceneIndexProvider;

  private final Provider<FareService> fareServiceProvider;

  private ConstructApplicationModule_ProvidesServerContextFactory(ConstructApplicationModule module,
      Provider<RouterConfig> routerConfigProvider, Provider<DebugUiConfig> debugUiConfigProvider,
      Provider<RaptorConfig<TripSchedule>> raptorConfigProvider, Provider<Graph> graphProvider,
      Provider<VertexLinker> vertexLinkerProvider, Provider<TransitService> transitServiceProvider,
      Provider<WorldEnvelopeService> worldEnvelopeServiceProvider,
      Provider<RealtimeVehicleService> realtimeVehicleServiceProvider,
      Provider<VehicleRentalService> vehicleRentalServiceProvider,
      Provider<VehicleParkingService> vehicleParkingServiceProvider,
      Provider<List<RideHailingService>> rideHailingServicesProvider,
      Provider<ViaCoordinateTransferFactory> viaTransferResolverProvider,
      Provider<StopConsolidationService> stopConsolidationServiceProvider,
      Provider<StreetLimitationParametersService> streetLimitationParametersServiceProvider,
      Provider<TraverseVisitor<?, ?>> traverseVisitorProvider,
      Provider<ItineraryDecorator> emissionItineraryDecoratorProvider,
      Provider<GraphQLSchema> gtfsSchemaProvider, Provider<GraphQLSchema> transmodelSchemaProvider,
      Provider<SorlandsbanenNorwayService> sorlandsbanenServiceProvider,
      Provider<LauncherRequestDecorator> launcherRequestDecoratorProvider,
      Provider<LuceneIndex> luceneIndexProvider, Provider<FareService> fareServiceProvider) {
    this.module = module;
    this.routerConfigProvider = routerConfigProvider;
    this.debugUiConfigProvider = debugUiConfigProvider;
    this.raptorConfigProvider = raptorConfigProvider;
    this.graphProvider = graphProvider;
    this.vertexLinkerProvider = vertexLinkerProvider;
    this.transitServiceProvider = transitServiceProvider;
    this.worldEnvelopeServiceProvider = worldEnvelopeServiceProvider;
    this.realtimeVehicleServiceProvider = realtimeVehicleServiceProvider;
    this.vehicleRentalServiceProvider = vehicleRentalServiceProvider;
    this.vehicleParkingServiceProvider = vehicleParkingServiceProvider;
    this.rideHailingServicesProvider = rideHailingServicesProvider;
    this.viaTransferResolverProvider = viaTransferResolverProvider;
    this.stopConsolidationServiceProvider = stopConsolidationServiceProvider;
    this.streetLimitationParametersServiceProvider = streetLimitationParametersServiceProvider;
    this.traverseVisitorProvider = traverseVisitorProvider;
    this.emissionItineraryDecoratorProvider = emissionItineraryDecoratorProvider;
    this.gtfsSchemaProvider = gtfsSchemaProvider;
    this.transmodelSchemaProvider = transmodelSchemaProvider;
    this.sorlandsbanenServiceProvider = sorlandsbanenServiceProvider;
    this.launcherRequestDecoratorProvider = launcherRequestDecoratorProvider;
    this.luceneIndexProvider = luceneIndexProvider;
    this.fareServiceProvider = fareServiceProvider;
  }

  @Override
  public OtpServerRequestContext get() {
    return providesServerContext(module, routerConfigProvider.get(), debugUiConfigProvider.get(), raptorConfigProvider.get(), graphProvider.get(), vertexLinkerProvider.get(), transitServiceProvider.get(), worldEnvelopeServiceProvider.get(), realtimeVehicleServiceProvider.get(), vehicleRentalServiceProvider.get(), vehicleParkingServiceProvider.get(), rideHailingServicesProvider.get(), viaTransferResolverProvider.get(), stopConsolidationServiceProvider.get(), streetLimitationParametersServiceProvider.get(), traverseVisitorProvider.get(), emissionItineraryDecoratorProvider.get(), gtfsSchemaProvider.get(), transmodelSchemaProvider.get(), sorlandsbanenServiceProvider.get(), launcherRequestDecoratorProvider.get(), luceneIndexProvider.get(), fareServiceProvider.get());
  }

  public static ConstructApplicationModule_ProvidesServerContextFactory create(
      ConstructApplicationModule module, Provider<RouterConfig> routerConfigProvider,
      Provider<DebugUiConfig> debugUiConfigProvider,
      Provider<RaptorConfig<TripSchedule>> raptorConfigProvider, Provider<Graph> graphProvider,
      Provider<VertexLinker> vertexLinkerProvider, Provider<TransitService> transitServiceProvider,
      Provider<WorldEnvelopeService> worldEnvelopeServiceProvider,
      Provider<RealtimeVehicleService> realtimeVehicleServiceProvider,
      Provider<VehicleRentalService> vehicleRentalServiceProvider,
      Provider<VehicleParkingService> vehicleParkingServiceProvider,
      Provider<List<RideHailingService>> rideHailingServicesProvider,
      Provider<ViaCoordinateTransferFactory> viaTransferResolverProvider,
      Provider<StopConsolidationService> stopConsolidationServiceProvider,
      Provider<StreetLimitationParametersService> streetLimitationParametersServiceProvider,
      Provider<TraverseVisitor<?, ?>> traverseVisitorProvider,
      Provider<ItineraryDecorator> emissionItineraryDecoratorProvider,
      Provider<GraphQLSchema> gtfsSchemaProvider, Provider<GraphQLSchema> transmodelSchemaProvider,
      Provider<SorlandsbanenNorwayService> sorlandsbanenServiceProvider,
      Provider<LauncherRequestDecorator> launcherRequestDecoratorProvider,
      Provider<LuceneIndex> luceneIndexProvider, Provider<FareService> fareServiceProvider) {
    return new ConstructApplicationModule_ProvidesServerContextFactory(module, routerConfigProvider, debugUiConfigProvider, raptorConfigProvider, graphProvider, vertexLinkerProvider, transitServiceProvider, worldEnvelopeServiceProvider, realtimeVehicleServiceProvider, vehicleRentalServiceProvider, vehicleParkingServiceProvider, rideHailingServicesProvider, viaTransferResolverProvider, stopConsolidationServiceProvider, streetLimitationParametersServiceProvider, traverseVisitorProvider, emissionItineraryDecoratorProvider, gtfsSchemaProvider, transmodelSchemaProvider, sorlandsbanenServiceProvider, launcherRequestDecoratorProvider, luceneIndexProvider, fareServiceProvider);
  }

  public static OtpServerRequestContext providesServerContext(ConstructApplicationModule instance,
      RouterConfig routerConfig, DebugUiConfig debugUiConfig,
      RaptorConfig<TripSchedule> raptorConfig, Graph graph, VertexLinker vertexLinker,
      TransitService transitService, WorldEnvelopeService worldEnvelopeService,
      RealtimeVehicleService realtimeVehicleService, VehicleRentalService vehicleRentalService,
      VehicleParkingService vehicleParkingService, List<RideHailingService> rideHailingServices,
      ViaCoordinateTransferFactory viaTransferResolver,
      @Nullable StopConsolidationService stopConsolidationService,
      StreetLimitationParametersService streetLimitationParametersService,
      @Nullable TraverseVisitor<?, ?> traverseVisitor,
      @Nullable ItineraryDecorator emissionItineraryDecorator, @Nullable GraphQLSchema gtfsSchema,
      @Nullable GraphQLSchema transmodelSchema,
      @Nullable SorlandsbanenNorwayService sorlandsbanenService,
      LauncherRequestDecorator launcherRequestDecorator, @Nullable LuceneIndex luceneIndex,
      FareService fareService) {
    return Preconditions.checkNotNullFromProvides(instance.providesServerContext(routerConfig, debugUiConfig, raptorConfig, graph, vertexLinker, transitService, worldEnvelopeService, realtimeVehicleService, vehicleRentalService, vehicleParkingService, rideHailingServices, viaTransferResolver, stopConsolidationService, streetLimitationParametersService, traverseVisitor, emissionItineraryDecorator, gtfsSchema, transmodelSchema, sorlandsbanenService, launcherRequestDecorator, luceneIndex, fareService));
  }
}
