package org.opentripplanner.standalone.config.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.raptor.api.request.RaptorEnvironment;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.standalone.config.RouterConfig;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class ConfigModule_ProvidesRaptorConfigFactory implements Factory<RaptorConfig<TripSchedule>> {
  private final Provider<RouterConfig> routerConfigProvider;

  private final Provider<RaptorEnvironment> environmentProvider;

  private ConfigModule_ProvidesRaptorConfigFactory(Provider<RouterConfig> routerConfigProvider,
      Provider<RaptorEnvironment> environmentProvider) {
    this.routerConfigProvider = routerConfigProvider;
    this.environmentProvider = environmentProvider;
  }

  @Override
  public RaptorConfig<TripSchedule> get() {
    return providesRaptorConfig(routerConfigProvider.get(), environmentProvider.get());
  }

  public static ConfigModule_ProvidesRaptorConfigFactory create(
      Provider<RouterConfig> routerConfigProvider,
      Provider<RaptorEnvironment> environmentProvider) {
    return new ConfigModule_ProvidesRaptorConfigFactory(routerConfigProvider, environmentProvider);
  }

  public static RaptorConfig<TripSchedule> providesRaptorConfig(RouterConfig routerConfig,
      RaptorEnvironment environment) {
    return Preconditions.checkNotNullFromProvides(ConfigModule.providesRaptorConfig(routerConfig, environment));
  }
}
