package org.opentripplanner.graph_builder.module.geometry;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.transit.service.TimetableRepository;

@ScopeMetadata
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class CalculateWorldEnvelopeModule_Factory implements Factory<CalculateWorldEnvelopeModule> {
  private final Provider<Graph> graphProvider;

  private final Provider<TimetableRepository> timetableRepositoryProvider;

  private final Provider<WorldEnvelopeRepository> worldEnvelopeRepositoryProvider;

  private CalculateWorldEnvelopeModule_Factory(Provider<Graph> graphProvider,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<WorldEnvelopeRepository> worldEnvelopeRepositoryProvider) {
    this.graphProvider = graphProvider;
    this.timetableRepositoryProvider = timetableRepositoryProvider;
    this.worldEnvelopeRepositoryProvider = worldEnvelopeRepositoryProvider;
  }

  @Override
  public CalculateWorldEnvelopeModule get() {
    return newInstance(graphProvider.get(), timetableRepositoryProvider.get(), worldEnvelopeRepositoryProvider.get());
  }

  public static CalculateWorldEnvelopeModule_Factory create(Provider<Graph> graphProvider,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<WorldEnvelopeRepository> worldEnvelopeRepositoryProvider) {
    return new CalculateWorldEnvelopeModule_Factory(graphProvider, timetableRepositoryProvider, worldEnvelopeRepositoryProvider);
  }

  public static CalculateWorldEnvelopeModule newInstance(Graph graph,
      TimetableRepository timetableRepository, WorldEnvelopeRepository worldEnvelopeRepository) {
    return new CalculateWorldEnvelopeModule(graph, timetableRepository, worldEnvelopeRepository);
  }
}
