package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.graph_builder.module.TurnRestrictionModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class GraphBuilderModules_ProvideTurnRestrictionModuleFactory implements Factory<TurnRestrictionModule> {
  private final Provider<Graph> graphProvider;

  private final Provider<OsmInfoGraphBuildRepository> osmInfoGraphBuildRepositoryProvider;

  private GraphBuilderModules_ProvideTurnRestrictionModuleFactory(Provider<Graph> graphProvider,
      Provider<OsmInfoGraphBuildRepository> osmInfoGraphBuildRepositoryProvider) {
    this.graphProvider = graphProvider;
    this.osmInfoGraphBuildRepositoryProvider = osmInfoGraphBuildRepositoryProvider;
  }

  @Override
  public TurnRestrictionModule get() {
    return provideTurnRestrictionModule(graphProvider.get(), osmInfoGraphBuildRepositoryProvider.get());
  }

  public static GraphBuilderModules_ProvideTurnRestrictionModuleFactory create(
      Provider<Graph> graphProvider,
      Provider<OsmInfoGraphBuildRepository> osmInfoGraphBuildRepositoryProvider) {
    return new GraphBuilderModules_ProvideTurnRestrictionModuleFactory(graphProvider, osmInfoGraphBuildRepositoryProvider);
  }

  public static TurnRestrictionModule provideTurnRestrictionModule(Graph graph,
      OsmInfoGraphBuildRepository osmInfoGraphBuildRepository) {
    return Preconditions.checkNotNullFromProvides(GraphBuilderModules.provideTurnRestrictionModule(graph, osmInfoGraphBuildRepository));
  }
}
