package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.module.islandpruning.PruneIslands;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.service.TimetableRepository;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class GraphBuilderModules_ProvidePruneIslandsFactory implements Factory<PruneIslands> {
  private final Provider<BuildConfig> configProvider;

  private final Provider<Graph> graphProvider;

  private final Provider<VehicleParkingRepository> parkingRepositoryProvider;

  private final Provider<TimetableRepository> timetableRepositoryProvider;

  private final Provider<DataImportIssueStore> issueStoreProvider;

  private final Provider<VertexLinker> linkerProvider;

  private GraphBuilderModules_ProvidePruneIslandsFactory(Provider<BuildConfig> configProvider,
      Provider<Graph> graphProvider, Provider<VehicleParkingRepository> parkingRepositoryProvider,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<DataImportIssueStore> issueStoreProvider, Provider<VertexLinker> linkerProvider) {
    this.configProvider = configProvider;
    this.graphProvider = graphProvider;
    this.parkingRepositoryProvider = parkingRepositoryProvider;
    this.timetableRepositoryProvider = timetableRepositoryProvider;
    this.issueStoreProvider = issueStoreProvider;
    this.linkerProvider = linkerProvider;
  }

  @Override
  public PruneIslands get() {
    return providePruneIslands(configProvider.get(), graphProvider.get(), parkingRepositoryProvider.get(), timetableRepositoryProvider.get(), issueStoreProvider.get(), linkerProvider.get());
  }

  public static GraphBuilderModules_ProvidePruneIslandsFactory create(
      Provider<BuildConfig> configProvider, Provider<Graph> graphProvider,
      Provider<VehicleParkingRepository> parkingRepositoryProvider,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<DataImportIssueStore> issueStoreProvider, Provider<VertexLinker> linkerProvider) {
    return new GraphBuilderModules_ProvidePruneIslandsFactory(configProvider, graphProvider, parkingRepositoryProvider, timetableRepositoryProvider, issueStoreProvider, linkerProvider);
  }

  public static PruneIslands providePruneIslands(BuildConfig config, Graph graph,
      VehicleParkingRepository parkingRepository, TimetableRepository timetableRepository,
      DataImportIssueStore issueStore, VertexLinker linker) {
    return Preconditions.checkNotNullFromProvides(GraphBuilderModules.providePruneIslands(config, graph, parkingRepository, timetableRepository, issueStore, linker));
  }
}
