package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.netex.NetexModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.service.TimetableRepository;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class GraphBuilderModules_ProvideNetexModuleFactory implements Factory<NetexModule> {
  private final Provider<GraphBuilderDataSources> dataSourcesProvider;

  private final Provider<BuildConfig> configProvider;

  private final Provider<Graph> graphProvider;

  private final Provider<TimetableRepository> timetableRepositoryProvider;

  private final Provider<VehicleParkingRepository> parkingServiceProvider;

  private final Provider<DataImportIssueStore> issueStoreProvider;

  private GraphBuilderModules_ProvideNetexModuleFactory(
      Provider<GraphBuilderDataSources> dataSourcesProvider, Provider<BuildConfig> configProvider,
      Provider<Graph> graphProvider, Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<VehicleParkingRepository> parkingServiceProvider,
      Provider<DataImportIssueStore> issueStoreProvider) {
    this.dataSourcesProvider = dataSourcesProvider;
    this.configProvider = configProvider;
    this.graphProvider = graphProvider;
    this.timetableRepositoryProvider = timetableRepositoryProvider;
    this.parkingServiceProvider = parkingServiceProvider;
    this.issueStoreProvider = issueStoreProvider;
  }

  @Override
  public NetexModule get() {
    return provideNetexModule(dataSourcesProvider.get(), configProvider.get(), graphProvider.get(), timetableRepositoryProvider.get(), parkingServiceProvider.get(), issueStoreProvider.get());
  }

  public static GraphBuilderModules_ProvideNetexModuleFactory create(
      Provider<GraphBuilderDataSources> dataSourcesProvider, Provider<BuildConfig> configProvider,
      Provider<Graph> graphProvider, Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<VehicleParkingRepository> parkingServiceProvider,
      Provider<DataImportIssueStore> issueStoreProvider) {
    return new GraphBuilderModules_ProvideNetexModuleFactory(dataSourcesProvider, configProvider, graphProvider, timetableRepositoryProvider, parkingServiceProvider, issueStoreProvider);
  }

  public static NetexModule provideNetexModule(GraphBuilderDataSources dataSources,
      BuildConfig config, Graph graph, TimetableRepository timetableRepository,
      VehicleParkingRepository parkingService, DataImportIssueStore issueStore) {
    return Preconditions.checkNotNullFromProvides(GraphBuilderModules.provideNetexModule(dataSources, config, graph, timetableRepository, parkingService, issueStore));
  }
}
