package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.gtfs.graphbuilder.GtfsModule;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.service.TimetableRepository;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class GraphBuilderModules_ProvideGtfsModuleFactory implements Factory<GtfsModule> {
  private final Provider<GraphBuilderDataSources> dataSourcesProvider;

  private final Provider<BuildConfig> configProvider;

  private final Provider<Graph> graphProvider;

  private final Provider<TimetableRepository> timetableRepositoryProvider;

  private final Provider<DataImportIssueStore> issueStoreProvider;

  private final Provider<FareServiceFactory> fareServiceFactoryProvider;

  private GraphBuilderModules_ProvideGtfsModuleFactory(
      Provider<GraphBuilderDataSources> dataSourcesProvider, Provider<BuildConfig> configProvider,
      Provider<Graph> graphProvider, Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<DataImportIssueStore> issueStoreProvider,
      Provider<FareServiceFactory> fareServiceFactoryProvider) {
    this.dataSourcesProvider = dataSourcesProvider;
    this.configProvider = configProvider;
    this.graphProvider = graphProvider;
    this.timetableRepositoryProvider = timetableRepositoryProvider;
    this.issueStoreProvider = issueStoreProvider;
    this.fareServiceFactoryProvider = fareServiceFactoryProvider;
  }

  @Override
  public GtfsModule get() {
    return provideGtfsModule(dataSourcesProvider.get(), configProvider.get(), graphProvider.get(), timetableRepositoryProvider.get(), issueStoreProvider.get(), fareServiceFactoryProvider.get());
  }

  public static GraphBuilderModules_ProvideGtfsModuleFactory create(
      Provider<GraphBuilderDataSources> dataSourcesProvider, Provider<BuildConfig> configProvider,
      Provider<Graph> graphProvider, Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<DataImportIssueStore> issueStoreProvider,
      Provider<FareServiceFactory> fareServiceFactoryProvider) {
    return new GraphBuilderModules_ProvideGtfsModuleFactory(dataSourcesProvider, configProvider, graphProvider, timetableRepositoryProvider, issueStoreProvider, fareServiceFactoryProvider);
  }

  public static GtfsModule provideGtfsModule(GraphBuilderDataSources dataSources,
      BuildConfig config, Graph graph, TimetableRepository timetableRepository,
      DataImportIssueStore issueStore, FareServiceFactory fareServiceFactory) {
    return Preconditions.checkNotNullFromProvides(GraphBuilderModules.provideGtfsModule(dataSources, config, graph, timetableRepository, issueStore, fareServiceFactory));
  }
}
