package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import java.util.List;
import javax.annotation.processing.Generated;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.module.ned.ElevationModule;
import org.opentripplanner.graph_builder.module.osm.OsmModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.config.BuildConfig;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class GraphBuilderModules_ProvideElevationModulesFactory implements Factory<List<ElevationModule>> {
  private final Provider<BuildConfig> configProvider;

  private final Provider<GraphBuilderDataSources> dataSourcesProvider;

  private final Provider<Graph> graphProvider;

  private final Provider<OsmModule> osmModuleProvider;

  private final Provider<DataImportIssueStore> issueStoreProvider;

  private GraphBuilderModules_ProvideElevationModulesFactory(Provider<BuildConfig> configProvider,
      Provider<GraphBuilderDataSources> dataSourcesProvider, Provider<Graph> graphProvider,
      Provider<OsmModule> osmModuleProvider, Provider<DataImportIssueStore> issueStoreProvider) {
    this.configProvider = configProvider;
    this.dataSourcesProvider = dataSourcesProvider;
    this.graphProvider = graphProvider;
    this.osmModuleProvider = osmModuleProvider;
    this.issueStoreProvider = issueStoreProvider;
  }

  @Override
  public List<ElevationModule> get() {
    return provideElevationModules(configProvider.get(), dataSourcesProvider.get(), graphProvider.get(), osmModuleProvider.get(), issueStoreProvider.get());
  }

  public static GraphBuilderModules_ProvideElevationModulesFactory create(
      Provider<BuildConfig> configProvider, Provider<GraphBuilderDataSources> dataSourcesProvider,
      Provider<Graph> graphProvider, Provider<OsmModule> osmModuleProvider,
      Provider<DataImportIssueStore> issueStoreProvider) {
    return new GraphBuilderModules_ProvideElevationModulesFactory(configProvider, dataSourcesProvider, graphProvider, osmModuleProvider, issueStoreProvider);
  }

  public static List<ElevationModule> provideElevationModules(BuildConfig config,
      GraphBuilderDataSources dataSources, Graph graph, OsmModule osmModule,
      DataImportIssueStore issueStore) {
    return Preconditions.checkNotNullFromProvides(GraphBuilderModules.provideElevationModules(config, dataSources, graph, osmModule, issueStore));
  }
}
