package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.ext.transferanalyzer.DirectTransferAnalyzer;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.service.TimetableRepository;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class GraphBuilderModules_ProvideDirectTransferAnalyzerFactory implements Factory<DirectTransferAnalyzer> {
  private final Provider<BuildConfig> configProvider;

  private final Provider<Graph> graphProvider;

  private final Provider<VertexLinker> linkerProvider;

  private final Provider<TimetableRepository> timetableRepositoryProvider;

  private final Provider<DataImportIssueStore> issueStoreProvider;

  private GraphBuilderModules_ProvideDirectTransferAnalyzerFactory(
      Provider<BuildConfig> configProvider, Provider<Graph> graphProvider,
      Provider<VertexLinker> linkerProvider,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<DataImportIssueStore> issueStoreProvider) {
    this.configProvider = configProvider;
    this.graphProvider = graphProvider;
    this.linkerProvider = linkerProvider;
    this.timetableRepositoryProvider = timetableRepositoryProvider;
    this.issueStoreProvider = issueStoreProvider;
  }

  @Override
  public DirectTransferAnalyzer get() {
    return provideDirectTransferAnalyzer(configProvider.get(), graphProvider.get(), linkerProvider.get(), timetableRepositoryProvider.get(), issueStoreProvider.get());
  }

  public static GraphBuilderModules_ProvideDirectTransferAnalyzerFactory create(
      Provider<BuildConfig> configProvider, Provider<Graph> graphProvider,
      Provider<VertexLinker> linkerProvider,
      Provider<TimetableRepository> timetableRepositoryProvider,
      Provider<DataImportIssueStore> issueStoreProvider) {
    return new GraphBuilderModules_ProvideDirectTransferAnalyzerFactory(configProvider, graphProvider, linkerProvider, timetableRepositoryProvider, issueStoreProvider);
  }

  public static DirectTransferAnalyzer provideDirectTransferAnalyzer(BuildConfig config,
      Graph graph, VertexLinker linker, TimetableRepository timetableRepository,
      DataImportIssueStore issueStore) {
    return Preconditions.checkNotNullFromProvides(GraphBuilderModules.provideDirectTransferAnalyzer(config, graph, linker, timetableRepository, issueStore));
  }
}
