package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import javax.annotation.processing.Generated;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.report.DataImportIssueReporter;
import org.opentripplanner.standalone.config.BuildConfig;

@ScopeMetadata("jakarta.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast",
    "deprecation",
    "nullness:initialization.field.uninitialized"
})
public final class GraphBuilderModules_ProvideDataImportIssuesToHTMLFactory implements Factory<DataImportIssueReporter> {
  private final Provider<GraphBuilderDataSources> dataSourcesProvider;

  private final Provider<BuildConfig> configProvider;

  private final Provider<DataImportIssueStore> issueStoreProvider;

  private GraphBuilderModules_ProvideDataImportIssuesToHTMLFactory(
      Provider<GraphBuilderDataSources> dataSourcesProvider, Provider<BuildConfig> configProvider,
      Provider<DataImportIssueStore> issueStoreProvider) {
    this.dataSourcesProvider = dataSourcesProvider;
    this.configProvider = configProvider;
    this.issueStoreProvider = issueStoreProvider;
  }

  @Override
  public DataImportIssueReporter get() {
    return provideDataImportIssuesToHTML(dataSourcesProvider.get(), configProvider.get(), issueStoreProvider.get());
  }

  public static GraphBuilderModules_ProvideDataImportIssuesToHTMLFactory create(
      Provider<GraphBuilderDataSources> dataSourcesProvider, Provider<BuildConfig> configProvider,
      Provider<DataImportIssueStore> issueStoreProvider) {
    return new GraphBuilderModules_ProvideDataImportIssuesToHTMLFactory(dataSourcesProvider, configProvider, issueStoreProvider);
  }

  public static DataImportIssueReporter provideDataImportIssuesToHTML(
      GraphBuilderDataSources dataSources, BuildConfig config, DataImportIssueStore issueStore) {
    return Preconditions.checkNotNullFromProvides(GraphBuilderModules.provideDataImportIssuesToHTML(dataSources, config, issueStore));
  }
}
